//$TypeScriptDoc, myScroller$

#include "ET++.h"

#include "ShellTextView.h"
#include "StyledText.h"
#include "Menu.h"
#include "TypeScriptDoc.h"
#include "CmdNo.h"

const int cTYPESCRIPTMENU= cUSERCMD+100;

//---- myScroller -------------------------------------------------------------

class myScroller: public Scroller {
    TypeScriptDoc *tsd;
public:
    MetaDef(myScroller);
    myScroller(TypeScriptDoc *s, VObject *v) : (v)
	{ tsd= s; }
    void SetExtent(Point e);
};

MetaImpl0(myScroller);

void myScroller::SetExtent(Point e)
{
    Scroller::SetExtent(e); 
    tsd->ChangeSize(vf->ContentRect());
}

//---- TypeScriptDoc ----------------------------------------------------------

MetaImpl(TypeScriptDoc, (I_O(view), I_O(text), I_I(cnt)));

TypeScriptDoc::TypeScriptDoc(int c): (cDocTypeAscii)
{
    cnt= c;
    fd= gFixedFont;
    if (Getenv("ET_NO_STYLEDCODE"))
	text= new GapText(256, fd);
    else
	text= new StyledText(256, fd);
}

TypeScriptDoc::~TypeScriptDoc()
{
    SafeDelete(view); 
    SafeDelete(text);
}

Window *TypeScriptDoc::DoMakeWindows()
{   
    static char *argv[] = { "/bin/csh", 0 };
    char *shell= Getenv("SHELL");
    if (shell)
	argv[0]= shell;
    view= new ShellTextView(this, Rectangle(Point(1000,cFit)), text, 
							       argv[0], argv);
    
    return new Window(this, Point(650, 440), eWinDefault,
	new myScroller(this, view),
	form("%s (%d)", view->GetArgv()[0], cnt)
    );
}
 
void TypeScriptDoc::ChangeSize(Rectangle r)
{ 
    int cols= r.extent.x / fd->Width(' ');
    int rows= r.extent.y / TextViewLineHeight(fd, view->GetSpacing()); 
    view->SetTtySize(rows, cols);
}

void TypeScriptDoc::DoCreateMenu(class Menu *m)
{
    Document::DoCreateMenu(m);
    
    Menu *typescript= new Menu("typescript");

    typescript->AppendItems(
		      "become console",     cBECOMECONSOLE,
		      "auto reveal ",       cAUTOREVEAL,
		      "reconnect",          cRECONNECT,
		      "clear transcript ",  cCLEAR,
		      0);

    m->InsertItemAfter(cLASTEDIT, "doit", cDOIT);
    m->AppendMenu(typescript, cTYPESCRIPTMENU);
}

void TypeScriptDoc::DoSetupMenu(Menu *m)
{
    Document::DoSetupMenu(m);
    m->DisableItem(cSAVE);    
    m->DisableItem(cREVERT);    
    m->EnableItem(cTYPESCRIPTMENU);    
}

void TypeScriptDoc::DoWrite(ostream &s, int)
{
    text->PrintOnAsPureText(s);
}

void TypeScriptDoc::DoRead(istream &s, class FileType *)
{
    text->ReadFromAsPureText(s);
    if (text->IsKindOf(StyledText)) {
	StyledText *styledtext= (StyledText*) text;
	TextRunArray *st= new TextRunArray(styledtext);
	fd= gFixedFont;
	st->Insert(new Style(fd), 0, 0, text->Size());
	delete styledtext->SetStyles(st);
    }
    view->SetText(text);
}

bool TypeScriptDoc::CanLoadDocument(FileType *ft)
{
    return ft->IsAscii();
}
