//$AnnotatedItem,EditMessageSheet$
#include "AnnotatedItem.h"
#include "DialogItems.h"
#include "Dialog.h"
#include "Scroller.h"
#include "Window.h"
#include "TextView.h"
#include "VObjectText.h"
#include "VObjectTextView.h"

//---- class EditMessageSheet -----------------------------------

class EditMessageSheet: public Dialog {
    AnnotatedItem *mt;
    TextView *tv;
public: 
    MetaDef(EditMessageSheet);
    
    EditMessageSheet(AnnotatedItem *t) : (0, eBWinBlock)
	{ mt= t; }
	    
    ~EditMessageSheet()
	{ SafeDelete(tv); }
    void Control(int id, int part, void *v);
    VObject *DoCreateDialog();
};

MetaImpl0(EditMessageSheet);

void EditMessageSheet::Control(int id, int part, void* v)
{
    if (part == cPartAction && id == cIdOk) 
	mt->SetMessage((VObjectText*)tv->GetText());
    Dialog::Control(id,part,v);
}

VObject *EditMessageSheet::DoCreateDialog()
{
    VObject *vop;
    vop= new BorderItem(
	new BorderItem(
	    new Cluster(2, eVObjHLeft, 10,
		new Scroller(
		    tv= new VObjectTextView(this, Rectangle(300,cFit), 
					    mt->GetMessage()), Point(300, 150)
		),
		new ActionButton (cIdOk, "Ok"), 
		0
	    ),
	    Point(10,10),
	    3
	),
	Point(2,2),
	1
    );
    tv->SetFlag(eTextNoFind);
    return vop;
}

//---- AnnotatedItem -----------------------------------------------------------

static short AnnotatedItemBits[]= {
#   include "images/AnnotatedItem.im"
};

static short AnnotatedInvBits[]= {
#   include "images/AnnotatedItemFeedback.im"
};

static StaticBitmap AnnotatedItemImage(Point(20,16), AnnotatedItemBits);
static StaticBitmap AnnotatedItemInv(Point(20,16), AnnotatedInvBits);

MetaImpl0(AnnotatedItem);
  
AnnotatedItem::AnnotatedItem(char *message)
			   : (0, &AnnotatedItemImage, &AnnotatedItemInv, FALSE)
{
    Enable(TRUE);
    msg= new VObjectText(message);
}

AnnotatedItem::AnnotatedItem()
{
    Enable(TRUE); 
    msg= new VObjectText;
}
    
AnnotatedItem::~AnnotatedItem()
{
    SafeDelete (msg);
}

void AnnotatedItem::SetMessage(VObjectText *m)
{
    msg= m;
} 

VObjectText *AnnotatedItem::GetMessage()
{ 
    return msg; 
}

void AnnotatedItem::ItemSelected()
{
    if (! msg)
	return;

    EditMessageSheet *em= new EditMessageSheet(this);
    em->Show();
    delete em;    
}

GrCursor AnnotatedItem::GetCursor(Point)
{
    return eCrsHand;
}

ostream& AnnotatedItem::PrintOn (ostream&s)
{
    ImageButton::PrintOn(s);
    return s << msg;
}

istream& AnnotatedItem::ReadFrom(istream &s)
{
    ImageButton::ReadFrom(s);
    return s >> msg;
}
