<include sgml.mac>
.so macros
.TL 
ET++ Installation Notes (April 1989)
.AI
Department of Computer Science, University of Z\(uerich
Winterthurerstr. 190, CH-8057 Zurich, Switzerland
.P
This is the first public domain distribution of ET++. 
The distribution is organized hierarchically as follows:
.TS
tab(!) ;
lfTT l.
et
  .cshrc!example profile (mandatory environment variables)
  CSHRC!same as above
  C++!patches to AT&T's cfront 1.2.1
  src!source code of ET++ class library
    MALLOC!extended malloc
    SUNWINDOW!interface for SunView/SunWindows
    SERVER!a window server running under SunView
    XSERVER!interface for X11.3(beta)
    NEWS!interface for the NeWS window system (experimental)
    PIC!interface for producing pic output (experimental)
    POSTSCRIPT!interface for producing postscript output
    SUNOS!interface for SUNOS
    PROGENV!ET++'s programming environment
    images!bitmap images
  applications!example applications developed with ET++
  postscript!postscript libraries
  doc!this installation guide
   !ET++ \- Introduction Paper
   !GNU's regular expressions syntax
  fonts!fonts for SunView
  xfonts!fonts for X11
  bin!utility programs for ET++
  bin.68020!binaries of ET++ example programs for SUNOS 4.0
  dyn.68020!*.o files for dynamic loading/linking with "app"
  util!
    makedep!public domain makefile dependency generator
    patch!public domain utility for applying patches
  lib!a fixed version of libc.a for SunOS 4.0(EXPORT)
.TE
.\"..................................
.H 1 "Hardware and Software Requirements"
About 16 MBytes of disk space are required to install ET++. ET++ currently runs
on SUN-2 and SUN-3 architectures. In order to run ET++ on a SUN-4 support for
variable argument lists has to be implemented for C++ on this architecture.
The standard definition of <path <varargs.h\>> cannot be used with function
prototypes as found in ANSI C or C++. ET++ uses the <code <stdarg.h>>
interface distributed with cfront for handling variable argument lists.
Until now running ET++ on a SUN-4 has never been tried out.
.P
ET++ applications run on color screens but the current version does not support
colors.
.P
ET++ runs under the SunOS releases 3.4, 3.5, 4.0 and 4.0.1. There are some
problems under 4.0 due to a bug that is fixed in 4.0.1. The symptom of this bug
is that an ET++ application can only be executed once. Attempts to start an
application a second time fail with a strange <quote core dump>. To overcome this bug
link all ET++ applications static (<ref etld>). SunOS 4.0(<bold EXPORT>) has
another bug buried in <path libc.a> which does not allow to statically link
applications. A fixed version of <path libc.a> for SunOS 4.0(EXPORT) is
included in <path lib/libc.a>.
.P
ET++ currently supports the following window systems:
.IP \-
SunView (the primary ET++ development environment)
.IP \-
X11.3(beta)
.IP \-
NeWS 1.1 (support for NeWS is not completely finished)
.P
The ET++ collection classes are window system independent and can be used on
all platforms.
.P
ET++ was developed with <bold "cfront 1.2.1 2/16/87">. In order to compile ET++ with
this version of cfront some bugs have to be fixed. The corresponding patches 
are shipped with this distribution.
.QP
<bold Notice: > These bug fixes require the source code for cfront 1.2.1
.P
An attempt to compile ET++ with a beta version of the Oregon C++ compiler was not
successful.
.\"......................
.H 1 "Installation Procedure"
The ET++ software is location independent, e.g. it can be installed at any
place in the file system. Choose the directory where ET++ should be installed,
for example <path /local>. Extract the files: 
.P1
tar -xvfb /dev/rst0 126
.P2
The standard location for ET++ is <path /local/et>. If the standard location is
not used the environment variable <code ET_DIR> has to be set accordingly. For
example, if ET++ is installed in <path /home/oolibs/et>, <code ET_DIR> has to
be set to <path /home/oolibs/et>. The installation directory is referred to as
<code ET_DIR> in the following explanations.
.P
If you are running SunOS 4.0 or 4.0.1 on a SUN3 you are ready to experiment
with some ET++ applications located in <etpath /bin.68020>. Before starting an
application the environment variable <code ET_DIR> has to be set as described
above.  These ET++ applications were compiled to include the ET++ programming
environment. Refer to the section entitled
<quote The Built-in Programming Environment> in the paper
<quote ET++ Introduction> for a description on how to
invoke it and to get some information about its functionality. The applications
run under SunView and X11.
.H 2 "Applying the Patches to cfront"
If you are using cfront 1.2.1 apply the patches in <code cfront.patch> stored
in <etpath /C++>. A version of the patch program is included in the directory
<etpath /util/patch>.
.P
Install the <code CC> driver shell script.  The standard <code CC> for cfront
1.2.1 was modified to call <code nm> during munch with the <code -p> option in
order give some control over the calling order of static constructors. Standard
<code CC> calls <code nm> without any option. The other modification was the
additional definition of the symbol <code __COMPILEDIR__> to refer to the
pathname of the current directory. <code __COMPILEDIR__> is only used by the
browser of the ET++ programming environment to locate the source code of a
class. If not set by <code CC> the symbol is defined as <code ""> and the
environment variable <code ET_SRC_PATH> can be used to specify a list of search
paths for source files.
.H 2 "Edit <etpath /src/Types.h>"
If your C++ compiler uses ANSI C as the underlying C definition modify the
token concatenating macros <code _NAME1_>, <code _NAME2_>, <code _NAME3_>
to use the ANSI C string concatenation operator <code ##>.
.H 2 "Configuring the ET++ library in <etpath /src/makefile>"
Edit the macros <code MUNCH> and <code LIBCC> to match the location of the
<code munch> part and the standard library of C++. The makefile builds a local copy of
the standard C++ library (<path libC2.a>) with files <path _dtor.o> and <path _ctor.o> removed. This
is necessary for optimizing the link step (<ref see 2.6>).
.P
ET++ class library includes support for several different window systems and
printing devices. The makefile in <etpath /C++/src> includes under the section
entitled <quote configuration> some macros to tailor ET++ to a specific environment.
.P
.H 3 "Selecting the Window System Interfaces"
By default all supported window system interfaces are included. This allows
an application linked with this version of the library to run on all
these platforms without any recompiling.
.P1
WS_OFILES       =   $(SUNSERVER) $(NEWSSERVER) $(XSERVER) $(SUNWINDOW)
WS_IFDEFS       =   -DWS_SUNSERVER -DWS_NEWS -DWS_X -DWS_SUNWINDOW
WS_DIRS         =   SUN XSERVER SERVER NEWS
.P2
To remove a window system interface, delete the corresponding entry from these
lines. The macro names stand for:
.TS
tab(!) ;
lfTT l.
SUNSERVER!interface to a server for the sunwindow system
NEWSSERVER!interface for NeWS 1.1, this interface is only experimental
XSERVER!interface for X11.3(BETA)
SUNWINDOW!interface for sunwindow/sunview
.TE
The following example shows the definition of the macros for a version of ET++
which includes only the X interface
.P1
WS_OFILES       =   $(XSERVER)
WS_IFDEFS       =   -DWS_X
WS_DIRS         =   XSERVER
.P2
.H 3 "Selecting the Printers"
ET++ supports generating either postscript or pic output. By default both
formats are included. To remove a printer interface, adapt the macros as
described above.
.P1
PR_OFILES       =   $(POSTSCRIPT) $(PIC)
PR_IFDEFS       =   -DPR_POSTSCRIPT -DPR_PIC
PR_DIRS         =   POSTSCRIPT PIC
.P2
.H 3 "Operating System Interface"
Currently, only an interface for SUNOS is supported.
.H 3 "Programming Environment"
By default the ET++ library and therefore all the ET++ applications linked with
it include a programming environment (an inspector, and a browser). These tools
add 30KB to an ET++ application but have no influence on the execution speed. 
In order to remove this inspecting and
browsing code in a final version of an application modify the
macros as shown below:
.P1
PE_OFILES       =  # $(ET_PROGENV) 
PE_IFDEFS       =  # -DET_PROGENV
PE_DIRS         =  # PROGENV
.P2
Recompile the class library with <code make config> and relink your application.
<code make config> should be called whenever the <code PE_> or the 
<code WS_> macros are changed.
.\"........................
.H 2 "Adapting <etpath /src/order>"
The file <path order> has been introduced to solve the problem of the correct calling
order for static constructors/destructors. <path Order> contains a list of object
file names with static constructors. The constructors will be called in the
reverse order specified in the file. <path Order> has to include the pathname to
the standard C++ library in order to call its static constructors. The absolute
pathname to the standard C++ library has to be adapted according to your
local configuration:
.P1
\&...
Set.o
ObjArray.o
\f(TB/local/lib/libC.a\fP \(<-
Storage.o
.P2
.\".....................
.H 2 "Building the ET++ Library"
The ET++ classes are built by running <code make> in <etpath /src>.  This step
will take around 40 minutes on a SUN 3/260. The output of this step is not an
archive including the ET++ object files but a relocatable object file with the
name <path et.o>. Experience has shown that this approach speeds up linking of
an ET++ application. An ET++ application linked with an archive is not
significantly smaller than an application linked with a relocatable object file
containing all the object files.
.P
With the command <code make col> you may build a library including the ET++
collections without any graphical and window system dependent classes.
.P
.H 2 "Adapting <code etld>"
The shell script <code etld> has been introduced to optimize linking for the
AT&T implementation of C++ on BSD systems. <code Etld> avoids linking an
application twice in order to find out all the static constructors/destructors.
The idea is to cache all the static constructors/destructors from <path et.o>
in a file <path et.ctdt> and to merge those with the constructors/destructors
found in the application object files. The shell script is stored in <etpath
/bin>. The macros described below have to be adapted.
.P
.TB STATIC_OPT
specifies the options to be used when an application is
statically linked.
.P
For SUNOS 4.0(EXPORT): 
.P1
STATIC_OPT="-Bstatic -L${ET_DIR}/lib" 
.P2  
For SUNOS 4.0 or SUNOS 4.0.1: 
.P1
STATIC_OPT="-Bstatic" 
.P2          
.TB MUNCH
specifies the location of munch 
.P
.TB LIBS
lists additional libraries to be linked
.P
For SUNOS 3.4, 3.5 (without shared libraries)
.P1
LIBS="-lm -lC"
.P2
For SUNOS 4.0 and above, if ET++ has been configured to include an interface to
SunWindow/SunView. The shared window libraries have to be listed in addition to
-lm and -lC:
.P1 
LIBS="-lsuntool -lsunwindow -lpixrect -lm -lC"
.P2
.\"------------------------------
.H 2 "Compiling the Fonts for X11"
The ET++ distribution includes fonts for X11 in snf and bdf format. The snf
fonts were generated for SUN3 architectures and have to be regenerated for other
environments from the bdf descriptions. In order to compile the fonts adapt the
makefile in <etpath /xfonts>. <code FC> has to be defined to refer to the X11 font
compiler.
.H 2 "Compiling the ET++ Example Applications"
After step 2.7 you are ready to build the ET++ example applications. They are
compiled by calling <code make> in the directory <etpath /applications>.
More information about these example applications can be found in 
"ET++ Introduction"
.H 2 "Compiling ET++ Support Applications"
The directory <etpath /src> contains the source code for some additional ET++
applications. A window server running under SunView can be compiled with <code
make server>. This server is only useful if the ET++ applications include the
corresponding window system interface, e.g. by compiling them with a version
of the ET++ library with <code SUNSERVER> enabled. The server is started by
calling <path server>, all ET++ applications started afterwards will automatically
connect with this server.
.P
In order to support cut/copy/paste operations among different application
processes under SunWindow, a special clipboard server is required. If the clipboard server is
not running applications can only execute cut/copy/paste operations between
their own windows. <code Make clipboard> compiles the SunWindow clipboard server.
The clipboard is started by calling <code clipboard>.
.P
The application <code app> generated with <code make app> starts up any ET++
application and dynamically links the missing classes for this application.
<code App> is called with the name of the application as argument, e.g. <code
app micky>, after dynamically linking all the classes required by this
application <code micky> will start up as usual. The search path to be used to
find object files can be set in the environment variable <code ET_DYN_PATH>.
<etpath /dyn.68020> contains all the neccessary .o files to dynamically load 
applications <path micky>, <path vobedit>, <path miniedit>, and <path layout>.
.QP
<bold Notice:> <code App> is not completely finished yet
.P
The command <code make install> moves these additional applications to 
<etpath /bin>.
.\"..................................
.H 1 "Maintaining the ET++ Class Library"
Whenever a new class with a static constructor is added to the ET++ class
library (<path et.o>) the name of the object file has to be inserted at the beginning
of <etpath /src/order>.
\"...............................
. H 1 "Known cfront 1.2.1 Dependencies"
The file <etpath /src/Object.h> includes the member function <code overridden>
that allows to test whether a method is overridden in a subclass.
.P1
int overridden(int *ip, ObjMemberFunc p)
    { return ((int*)_vptr)[(int)p-1] != ip[(int)p-1]; }
.P2
The implementation of this test depends on the implementation of <code vtbls> of
cfront 1.2.1. The body of this function can be replaced with
.P1 
    { return TRUE; }
.P2
if you are not using AT&T's cfront.
Overridden is used by ET++ only to eliminate some function calls.
.P
The file <etpath /src/Class.C> includes a reference to the vtbl pointer
in the debugging method <code Class::DisplayOn>. This code segment
can be deleted without any loss of functionality.
.P
The file <etpath /src/SUNWINDOW/sunwindow.c> is the implementation of the C++
class <code SunWindowPort> in pure C! For this reason, the structure layout and
the name of member functions were chosen to match the cfront-generated names. A
portable solution to this problem, would be to implement the members of <code
SunWindowPort> as stubs calling the corresponding external C functions.
.H 1 "Hardcopy Documentation"
The <etpath /doc> directory includes the document "ET++ \- Introduction" stored
in <code intro.tbl.ms>.  This document describes the stylistic conventions used
in ET++ and gives an overview of the ET++ classes. It is based on troff and can
be printed with the help of the makefile stored in <etpath /doc>. This document
uses a simple preprocessor for troff called <code sgml>. This program is
included in the <etpath /doc> directory and can be build with the makefile.  A
copy of the paper "Design and Implementation of ET++" is shipped with the
distribution (sorry for the bad quality) and is available through the mail from
the following address:
.P1
ET++ Information
Institut fuer Informatik
University of Zurich
Winterthurerstr. 190
CH-8057 Zuerich
.P2

