#ifndef CodeTextView_First
#define CodeTextView_First
 
#include "FixedLineTextView.h"

extern Rectangle gCodeTextViewRect;

//---- CodeTextView --------------------------------------------------------
// a TextView for editing programm text with a fixed line spacing.
// adds: auto indenting
//       highlighting matching brackets
//       (double clicking on a bracket selects the text enclosed by the brackets)

class CodeTextView: public FixedLineTextView {
    bool autoIndent;
    Point cursorPos;
    void MatchBracketForward(int from, int obracket, int cbracket);
    void MatchBracketBackward(int from, int obracket, int cbracket);
    void ExitCursorMode();
    int CursorPos(int ch, int line, EvtCursorDir d, Point);
    class Style *commentStyle;
    class Style *functionStyle;
    class Style *classDeclStyle;
    class Style *plainStyle;
public:
    MetaDef(CodeTextView);

    CodeTextView(EvtHandler *eh, Rectangle r, 
	     Text *t, eTextJust m= eLeft,
	     eSpacing= eOne, TextViewFlags= eVObjDefault, 
	     Point border = gBorder, int id = -1);    
	    // for efficency reasons do not set contentRect.extent.x to cFit
	    
    //---- formatting of source code
    void FormatCode();
    void SetDefaultStyle();
    void Comment(class AutoTextIter*, class TextRunArray *);
    void LineEndComment(class AutoTextIter*, class TextRunArray *);
    void FunctionOrMethod(int at, int lastComment, class TextRunArray *);
    bool IsClassDecl(int at);
    void ClassDecl(int at, class TextRunArray *);
    
    //---- controller methods 
    Command *DoLeftButtonDownCommand(Point, Token, int); // matching brackets
    Command *DoKeyCommand(int, Point, Token);      // auto indent
    Command *DoMenuCommand(int);
    Command *DoOtherEventCommand(Point p, Token t);
    Command *DoCursorKeyCommand(EvtCursorDir, Point, Token);    
    void SetAutoIndent(bool);
    bool GetAutoIndent();
};

#endif CodeTextView_First  
