//$FindDialog,ChangeAllCommand$

#include "RegularExp.h"
#include "FindDialog.h"
#include "Alert.h"
#include "String.h"
#include "DialogItems.h"
#include "TextView.h"
#include "Window.h"
#include "Document.h"

const int cIdFind             = cIdFirstUser + 1,
	  cIdChange           = cIdFirstUser + 2,
	  cIdChangeBorder     = cIdFirstUser + 3,
	  cIdDoFind           = cIdFirstUser + 4,
	  cIdDoChange         = cIdFirstUser + 5,
	  cIdDoChangeAll      = cIdFirstUser + 6,
	  cIdFindOpt          = cIdFirstUser + 7,
	  cIdFindMode         = cIdFirstUser + 16,
	  cIdChangeAllScope   = cIdFirstUser + 26;

//---- FindDialog ---------------------------------------------------------------


MetaImpl(FindDialog, (I_O(rex), I_O(tvp), I_O(ei1), I_O(ei2),
    I_B(atEnd), I_B(atBegin), I_B(ignoreCase), I_B(matchWord), I_B(forward)));


FindDialog::FindDialog(char *title, TextView *tv) : (title, eWinDefault)
{
    tvp= tv;
    rex= new RegularExp("");
    pattern= 0;
    forward= TRUE;
    atEnd= atBegin= ignoreCase= matchWord= selectionOnly= FALSE;
}

FindDialog::~FindDialog()
{
    SafeDelete(rex);
    SafeDelete(pattern);
}

VObject *FindDialog::DoCreateDialog()
{
    //---- dialog parts ----
    VObject *Find=
	new BorderItem ("Find What", ei1= new EditTextItem(cIdFind, "", 300));

    VObject *Mode=
	new BorderItem ("Direction",
	    new OneOfCluster(cIdFindMode, eVObjHLeft, 5, "Forward", "Backward", 0),
	    Point(6,4)
	);
    VObject *Options=
	new BorderItem ("Options",
	    new ManyOfCluster(cIdFindOpt, eVObjHLeft, 5,
					"Ignore Case", "Match Whole Word", 0),
	    Point(6,4)
	);

    VObject *ChangeAllScope=
	new BorderItem ("Change All Scope",
	    new OneOfCluster(cIdChangeAllScope, eVObjHLeft, 5,
					"All of Document", "Selection Only", 0),
	    Point(6,4)
	);

    VObject *Change=
	new BorderItem (cIdChangeBorder, "Change To",
	    ei2= new EditTextItem(cIdChange, "", 300)
	);

    VObject *Actions=
	new Cluster (cIdNone, eVObjVBase/*|eVObjHExpand*/, 10, 
	    new ActionButton (cIdDoFind, "Find Next", TRUE), 
	    new ActionButton (cIdDoChange, "Change, Then Find"), 
	    new ActionButton (cIdDoChangeAll, "Change All"),
	    0
	);

    //---- overall layout ----
    return
	new BorderItem(
	    new Cluster(cIdNone, eVObjHLeft|eVObjHExpand, 10,
		Find,
		new Cluster (cIdNone, eVObjVCenter, 10,
		    Mode,
		    Options,
		    ChangeAllScope,
		    0 
		),
		Change,
		Actions,
		0
	    ),
	    10, 0
	);
}

void FindDialog::DoSetup()
{
    bool b= ei1->GetTextSize() > 0;
    EnableItem(cIdDoFind, b);
    EnableItem(cIdDoChange, b);
    EnableItem(cIdDoChangeAll, b);
    EnableItem(cIdChangeBorder, b);
}

void FindDialog::Control(int id, int p, void *v)
{
    switch (id) {

    case cIdFind:
	Dialog::Control(id, p, v);
	if (p == cPartChangedText)
	    DoSetup();
	break;

    case cIdDoFind:
	DoFind(ei1, forward);
	tvp->RevealSelection();
	break;

    case cIdDoChange:
	DoChange(ei1, ei2->GetText());
	break;

    case cIdDoChangeAll:
	DoChangeAll(ei1, ei2->GetText());
	break;

    case cIdFindOpt:
	switch(p) {
	case cIdFindOpt:
	    ignoreCase= !ignoreCase;
	    break;
	case cIdFindOpt+1:
	    matchWord= !matchWord;
	    break;
	}   
	break;

    case cIdFindMode:
	switch(p) {
	case cIdFindMode:
	    forward= TRUE;
	    break;
	case cIdFindMode+1:
	    forward= FALSE;
	    break;
	}   
	break;

    case cIdChangeAllScope:
	switch(p) {
	case cIdChangeAllScope:
	    selectionOnly= FALSE;
	    break;
	case cIdChangeAllScope+1:
	    selectionOnly= TRUE;
	    break;
	}   
	break;

    default:
	Dialog::Control(id, p, v); 
	break;
    }
}

void FindDialog::DoChange(EditTextItem *e, Text *c)
{
    int from, to, f1, t1;

    tvp->GetSelection(&from, &to);
    if (forward)
	tvp->SetSelection(from, from);
    else
	tvp->SetSelection(to, to);
    if (DoFind(e, forward)) {
	tvp->GetSelection(&f1,&t1);
	if (f1 == from && t1 == to) {
	    tvp->GetSelection(&from, &to);
	    tvp->PerformCommand(tvp->InsertText(c));
	    if (!forward)
		tvp->SetSelection(from, from);
	    DoFind(ei1, forward);
	}
    }
    tvp->RevealSelection();
}

void FindDialog::DoChangeAll(EditTextItem *e, Text *c)
{

    if (CautionAlert.Show("\"Change All\" not undo-able") == cIdYes) {
	int from, to;

	tvp->GetSelection(&from, &to);
	if (!selectionOnly) {
	    from= 0;
	    to= tvp->GetText()->Size();
	}
	tvp->PerformCommand(new ChangeAllCommand(tvp, this, e, c, from, to));
    }
}

bool FindDialog::DoFind(EditTextItem *e, bool direction, bool msg)
{
    bool found;
    char *wpattern= 0;

    if (atEnd) {
	tvp->Home();
	atEnd= FALSE;
    }
    if (atBegin) {
	tvp->Bottom();
	atBegin= FALSE;
    }  

    SafeDelete(pattern);
    char *p= pattern= e->GetText()->AsString();
    if (matchWord) {
	wpattern= strprintf((char*)rex->MatchWordPattern(), pattern);
	p= wpattern;
    }
    rex->Reset(p, ignoreCase);
    SafeDelete(wpattern);
    if (rex->GetExprState()) {
	NoteAlert.Show(rex->GetExprState());
	return FALSE;
    }
    found= tvp->SelectRegExpr(rex, direction);
    if (!found && msg) {
	NoteAlert.Show("\"%s\" not found", pattern);
	if (direction)
	    atEnd= TRUE;
	else
	    atBegin= TRUE;
    }
    return found;
}

//---- class ChangeAllCommand -------------------------------------------------

ChangeAllCommand::ChangeAllCommand(TextView *tv, FindDialog *fdd, 
			 EditTextItem *fnd, Text* c, int f, int t)
			 : (cCHANGEALL, "ChangeAll", eCmdCausesChange | eCmdDoDelete)
{
    tvp= tv;
    fd= fdd;
    from= f;
    to= t;
    find= fnd;
    change= c;
};

void ChangeAllCommand::DoIt()
{
    int f, t, nChanges= 0;

    tvp->SetSelection(from, from);
    while (!TestInterrupt("search") && fd->DoFind(find, TRUE, FALSE)) {
	tvp->GetSelection(&f, &t);
	if (t > to)
	    break;
	tvp->Paste(change);
	nChanges++;
    }
    if (nChanges) {
	tvp->ForceRedraw();
	tvp->RevealSelection();
	tvp->UpdateEvent();
    }
    NoteAlert.Show("%d occurrences changed", nChanges);
}
