//$MenuItem,Menu,MenuLineItem$
#include "Menu.h"
#include "SortedObjList.h"
#include "OrdCollection.h"
#include "String.h"
#include "BlankWin.h"

static const Point cMenuItemBorder(4,0);

const int cPullRight= 16;

//---- MenuItem ----------------------------------------------------------------

MetaImpl(MenuItem, (I_O(nextMenu), I_I(subid)));

MenuItem::MenuItem(int id, VObject *g, class Menu *nm= 0)
		    : ( id,
			eVObjVCenter,
			Point(5,0),
			g,
			new TextItem("\336", new Font(eFontSymbol, gSysFont->Size()), cMenuItemBorder),
			0)
{
    nextMenu= nm;
    subid= -1;
}

MenuItem::~MenuItem()
{
    SafeDelete(nextMenu);
}

void MenuItem::Enable(bool b, bool)
{
    Cluster::Enable(b, FALSE);
    if (nextMenu && !b)
	nextMenu->DisableAll();
}

VObject *MenuItem::Detect(BoolFun find, void *arg)
{
    if (VObject::Detect(find, arg))
	return this;
    if (nextMenu)
	return nextMenu->Detect(find, arg);
    return 0;
}

void *MenuItem::Hit()
{
    int id;

    if (Enabled()) {
	if (subid >= 0) {
	    id= subid;
	    subid= -1;
	} else
	    id= GetId();
    } else
	id= subid= -1;
    return (void*) id;
}

void MenuItem::DoOnItem(int m, Point p)
{
    int w= At(1)->Width();
    if (m == 2 && nextMenu && Enabled() && ContainsPoint(p)) {
	if (p.x > lastxpos && 
		(p.x > enterxpos + cPullRight || p.x >contentRect.SE().x-w)) {
	    p.y= contentRect.Center().y + 8;
	    subid= nextMenu->Show(p, this);
	    lastxpos= contentRect.SE().x+1;
	} else
	    lastxpos= p.x;
    } else {
	lastxpos= contentRect.SE().x+1;
	enterxpos= p.x;
    }
}

ostream& MenuItem::PrintOn(ostream &s)
{
    Cluster::PrintOn(s);
    return s << nextMenu SP;
}

istream& MenuItem::ReadFrom(istream &s)
{
    Cluster::ReadFrom(s);
    subid= -1;
    return s >> nextMenu;
}

//---- MenuLineItem ------------------------------------------------------------

MetaImpl0(MenuLineItem);

MenuLineItem::MenuLineItem() : (TRUE, 1, 20, cIdNone)
{
    ResetFlag(eVObjEnabled);
}

void MenuLineItem::Enable(bool, bool)
{
    ResetFlag(eVObjEnabled);
}

//---- Menu --------------------------------------------------------------------

MetaImpl(Menu, (I_O(title), I_O(clipper), I_I(selection), I_P(theItem), I_O(window)));

Menu::Menu(char *t, bool s, int r, int c, bool st)
					    : (0, 0, eCVDontStuckToBorder, r, c)
{
    Init(new TextItem(t), s, st);
}

Menu::Menu(VObject *t, bool s, int r, int c, bool st) : (0, 0, eCVDontStuckToBorder, r, c)
{
    Init(t, s, st);
}

Menu::~Menu()
{
    SafeDelete(window);
}

void Menu::Init(VObject *t, bool s, bool st)
{
    if (s)
	SetCollection(new SortedObjList);
    else
	SetCollection(new OrdCollection);
    title= t;
    SetFlag(eMenuIsNew);
    theItem= selection= -1;
    level= 0;
    window= 0;
    if (st)
	SetFlag(eMenuTitle);
}

Point Menu::InitialPos()
{
    return ItemRect(theItem.x, theItem.y).W()+Point(4,0);
}

void Menu::Update()
{
    if (TestFlag(eCVModified)) {
	CollectionView::Update();
	if (window == 0) {
	    VObject *bal;
	    clipper= new Clipper(this);
	    if (TestFlag(eMenuTitle))
		bal= new ShadowBorderItem(title, clipper);
	    else
		bal= new ShadowBorderItem(clipper, 1);
	    window= new BlankWin(bal, gPoint_1, eBWinOverlay+eBWinBlock);
	    window->contentRect.extent= gPoint0;
	    window->Update();
	}
	window->contentRect.extent= gPoint0;
	//if (title && TestFlag(eMenuTitle))
	//    SetMinExtent(Point(window->GetMinSize().extent.x, 0));
	if (! TestFlag(eMenuNoScroll))
	    clipper->SetMinExtent(ItemRect(2,15).origin);
    }
}

int Menu::Show(Point p, VObject *fp)
{
    level++;
    ResetFlag(eMenuIsNew);
    SetFlag(eCVModified);
    Update();
    
    if (theItem == gPoint_1 || theItem.x >= 2 || theItem.y >= 15)
	SetNoSelection();
    else
	SetSelection(Rectangle(theItem, 1));

    Token t(eEvtLeftButton, 0, clipper->GetPortPoint(InitialPos()));
    window->PushBackEvent(t);
    window->OpenAt(p-t.Pos, fp);
    level--;
    return selection;
}

void Menu::Close()
{
    window->Close();
}

void Menu::DoOnItem(int m, VObject *gop, Point p)
{
    if (level > 1 && (p.x < 3 || p.y < -15))
	Close();
    else if (gop && gop->IsKindOf(MenuItem))
	((MenuItem*)gop)->DoOnItem(m, p);
}

void Menu::DoSelect(Rectangle sel)
{
    MenuItem *mi;

    if (sel.IsEmpty())
	theItem= selection= -1;
    else {
	theItem= sel.origin;
	mi= (MenuItem*) GetItem(theItem.x, theItem.y);
	if (mi->Enabled()) {
	    if (mi->IsKindOf(MenuItem))
		selection= (int) mi->Hit();
	    else
		selection= mi->GetId();
	} else
	    selection= -1;
    }
    Close();
}

void Menu::Insert(VObject *mip)
{
    Guard(GetCollection(), SeqCollection)->AddFirst(mip);
}

void Menu::InsertItem(char *s, int id)
{
    Insert(MakeMenuItem(s, id));
}

void Menu::Append(VObject *mip)
{
    GetCollection()->Add(mip);
}

void Menu::InsertBefore(int id, VObject *mip)
{
    VObject *gop= FindItem(id);
    SeqCollection *col= Guard(GetCollection(), SeqCollection);

    if (gop)
	col->InsertBefore(gop, mip);
    else
	col->AddFirst(mip);
}

void Menu::InsertAfter(int id, VObject *mip)
{
    VObject *gop= FindItem(id);
    SeqCollection *col= Guard(GetCollection(), SeqCollection);

    if (gop)
	col->InsertAfter(gop, mip);
    else
	GetCollection()->Add(mip);
}

void Menu::InsertItemAfter(int atId, char *s, int id)
{
    InsertAfter(atId, MakeMenuItem(s, id));
}

void Menu::InsertItemBefore(int atId, char *s, int id)
{
    InsertBefore(atId, MakeMenuItem(s, id));
}

void Menu::AppendItem(char *s, int id)
{
    GetCollection()->Add(MakeMenuItem(s, id));
}

void Menu::AppendItems(char *a1, ...)
{
    if (a1 == 0)
	return;

    va_list ap;
    int id= cIdNone; 
    va_start(ap, a1); 
    if (strcmp(a1, "-")) 
	id= va_arg(ap, int);  
		      
    Append(MakeMenuItem(a1, id));
    InsertVItems(-1, FALSE, ap);
    va_end(ap);
}

void Menu::InsertItemsBefore(int atId, char *, ...)
{
    va_list ap;    
    va_start(ap, atId);
    InsertVItems(atId, TRUE, ap);
    va_end(ap);
}

void Menu::InsertItemsAfter(int atId, char *, ...)
{
    va_list ap;    
    va_start(ap, atId);
    InsertVItems(atId, FALSE, ap);
    va_end(ap);
}

VObject *Menu::MakeMenuItem(char *s, int id)
{
    if (strcmp(s, "-") == 0)
	return new MenuLineItem;
    return new TextItem(id, s, gSysFont, cMenuItemBorder);
}

void Menu::InsertVItems(int atId, bool before, va_list ap)
{
    SeqCollection *col=  Guard(GetCollection(),SeqCollection);
    char *s;
    int id;
    VObject *gop, *atgop= 0;

    if (atId != -1)
	atgop= FindItem(atId);

    for (int i= 0; s= va_arg(ap, char*); i++) {
	if (strcmp(s, "-"))
	    id= va_arg(ap, int);
	gop= MakeMenuItem(s, id);
	if (atgop == 0)
	    col->Add(gop); 
	else if (before && i== 0)
	    col->InsertBefore(atgop, gop);
	else
	    col->InsertAfter(atgop, gop);
	atgop= gop;
    }
}

void Menu::DisableAll()
{
    GetCollection()->ForEach(VObject,Enable)(FALSE, FALSE);
}

void Menu::ReplaceItem(int id, char *s)
{
    TextItem *t= (TextItem*) FindItem(id);

    if (t && t->IsKindOf(TextItem)) {
	t->SetString(s);
	Modified();
	// GetCollection()->Changed();
    }
}

VObject *Menu::Detect(BoolFun find, void *arg)
{
    Iter next(GetCollection());
    register VObject *g1, *g2;

    while (g1= (VObject*) next())
	if (g2= g1->Detect(find, arg))
	    return g2;
    return 0;
}

Menu *Menu::FindMenuItem(int id)
{
    VObject *gop= FindItem(id);
    if (!gop || !gop->IsKindOf(MenuItem))
	return 0;
    MenuItem *mip= (MenuItem*)gop;
    return mip->ContMenu();
}

void Menu::EnableItem(int id, bool b)
{
    VObject *gop= FindItem(id);
    if (gop)
	gop->Enable(b, FALSE);
}

void Menu::EnableItems(int i1, int, ...)
{
    int *a= &i1;

    for (int i= 0; a[i]; i++)
	EnableItem(a[i]);
}

void Menu::SetSelectedItem(int id)
{
    theItem= ItemPos(FindItem(id));
}

void Menu::SetSelectedItem(Point i)
{
    theItem= i;
}

void Menu::AppendMenu(Menu *m, int id)
{
    char *t= m->GetTitle()->AsString();
    VObject *ti= new TextItem(t, gSysFont, cMenuItemBorder);
    GetCollection()->Add(new MenuItem(id, ti, m));
}

ostream& Menu::PrintOn(ostream &s)
{
    CollectionView::PrintOn(s);
    return s << title SP;
}

istream& Menu::ReadFrom(istream &s)
{
    CollectionView::ReadFrom(s);
    theItem= selection= -1;
    level= 0;
    window= 0;
    s >> title;
    SetFlag(eCVModified);
    Update();
    SetFlag(eMenuIsNew);
    return s;
}

void Menu::InspectorId(char *buf, int sz)
{
    if (title)
	title->InspectorId(buf, sz);
    else
	CollectionView::InspectorId(buf, sz);
}
