//$ObjArray,ObjArrayIter$
#include "ObjArray.h"
#include "Error.h"
#include "Storage.h"
#include "FixedSizeStorage.h"
#include "String.h"

char *cOutOfBoundsError= "out of bounds %d size %d in %x";
char *cMethodName= "operator[]";

//---- class ObjArray ---------------------------------------------------------

MetaImpl(ObjArray, (I_I(lb), I_OV(cont,size)));

ObjArray::ObjArray(int s, int lowerBound)                
{ 
    if (s <= 0)
	s= 10;
    cont= new ObjPtr[size= s];
    lb= lowerBound;
}

ObjArray::~ObjArray()
{
    SafeDelete(cont);
}

void ObjArray::InitNew()
{
    cont= new ObjPtr[cCollectionInitCap];
    lb= 0;
}

void ObjArray::FreeAll()
{
    register int i;

    for (i= 0; i < size; i++) {
	if (cont[i]) {
	    cont[i]->FreeAll();
	    SafeDelete(cont[i]);
	}
    }
    size= 0;
}

ObjPtr ObjArray::RemoveAt(int i)
{ 
    ObjPtr t;

    if (!BoundsOk("RemoveAt", i))
	return 0;
    t= cont[i-lb];
    cont[i-lb]= 0; 
    Changed();
    return t;
}

ObjPtr ObjArray::Remove(ObjPtr a)
{   
    register int i;
    register ObjPtr op;

    for (i = 0; i < size; i++) {
	op= cont[i];
	if (op && op->IsEqual(a)) {
	    cont[i]= 0;
	    Changed();
	    return op;
	}
    }
    return 0;
}

ObjPtr ObjArray::RemovePtr(ObjPtr a)
{   
    register int i;
    register ObjPtr op;

    for (i = 0; i < size; i++) {
	op= cont[i];
	if (op && op == a) {
	    cont[i]= 0;
	    Changed();
	    return op;
	}
    }
    return 0;
}

void ObjArray::Expand(int newSize)
{
    if (newSize < 0) {
	Error ("Expand", "newSize < 0");
	return;
    }
    if (newSize == size)
	return;
    if (newSize <= size) {
	// if the array is shrinked check whether there are nonempty entries
	for (int j = newSize; j < size; j++)
	    if (cont[j] != 0) {
		Error ("Expand", "expand would cut off nonempty entries");
		return;
	    }
    }            
    Realloc(&cont, newSize * sizeof(ObjPtr));
    size= newSize;
}

Iterator *ObjArray::GetIterator()
{
    return new ObjArrayIter(this);
}

ObjPtr ObjArray::AtPut(int i, ObjPtr ob)
{ 
    if (!BoundsOk ("AtPut", i))
	return 0;
    ObjPtr t= cont[i-lb];
    cont[i-lb]= ob;
    Changed();
    return t;
}

void ObjArray::AtPutAndExpand(int i,ObjPtr op)
{
    if (i < lb) {
	Error ("AtPutAndExpand", "out of bounds at %d in %x", i, this);
	return;
    }
    if (i-lb >= size) 
	Expand (max(i, GrowBy(size)));
    cont[i-lb] = op; 
    Changed();
}

ObjPtr ObjArray::Add(ObjPtr op)
{
    register int i;

    if (cont == 0)
	cont= new ObjPtr[size= 10];
    for (i= 0; i < size; i++)
	if (cont[i] == 0)
	    break;
    if (i >= size)
	Expand(GrowBy(size));
    cont[i]= op; 
    Changed();
    return 0;
}

bool ObjArray::Contains (ObjPtr ob)
{
    register int i;

    for (i= 0; i < size; i++)
	if (cont[i] && ob->IsEqual(cont[i])) 
	    return TRUE;
    return FALSE;
}

bool ObjArray::ContainsPtr (ObjPtr ob)
{
    register int i;

    for (i= 0; i < size; i++)
	if (ob == cont[i]) 
	    return TRUE;
    return FALSE;
}

int ObjArray::ContainsAt (ObjPtr ob)
{
    register int i;

    for (i = 0; i < size; i++)
	if (ob->IsEqual(cont[i])) 
	    return i+lb;
    return -1;
}

int ObjArray::ContainsPtrAt (ObjPtr ob)
{
    register int i;

    for (i= 0; i < size; i++)
	if (ob == cont[i]) 
	    return i+lb;
    return -1;
}

ObjPtr ObjArray::At(int i)
{
    if (!BoundsOk("At", i))
	return 0;
    return cont[i-lb];
}

int ObjArray::Compare (ObjPtr)
{
    MayNotUse ("Compare");
    return -2;
}

bool ObjArray::IsEqual (ObjPtr ob)
{
    if (!ob->IsKindOf(ObjArray))
	return FALSE;
    ObjArray *t = (ObjArray *) ob; 
    if (t->size != size || t->lb != lb)
	return FALSE;
    for (int i= 0; i < Size(); i++) {
	if (cont[i] == 0 && t->cont[i] == 0)
	    continue;
	if (cont[i] == 0 || t->cont[i] == 0)
	    break;
	if (!cont[i]->IsEqual(t->cont[i]))
	    break;
    }
    return i == size;
}

ostream& ObjArray::PrintOn(ostream &s)
{
    Object::PrintOn(s); // supress Collection::PrintOn
    s << Size() SP;
    for (int i= 0; i < Size(); i++) 
	s << cont[i] SP;
    return s NL;
}

istream& ObjArray::ReadFrom(istream &s)
{
    Object::ReadFrom(s);
    delete cont;
    s >> size;
    cont= new ObjPtr[size];
    for (int i= 0; i < size; i++)
	s >> cont[i];
    return s;
}

int ObjArray::Hash ()
{
    register int i, hash;

    for (i= hash= size; i < size; i++)
	if (cont[i])
	    hash ^= cont[i]->Hash();
    return hash;
}

static int CompareFun(ObjPtr* a, ObjPtr* b) 
{ 
    if (*a == 0 || *b == 0)
	return 0;
    return (*a)->Compare(*b);
}

void ObjArray::Sort(int upto)
{
    extern qsort(...);

    qsort(cont, min(size, upto-lb), sizeof(ObjPtr), CompareFun);
}

int ObjArray::BinarySearch(ObjPtr op, int upto)
{
    extern char *bsearch(...);
    ObjPtr *res;

    res= (ObjPtr*)bsearch((char*)&op, cont, min(size,upto-lb), sizeof(ObjPtr),
								    CompareFun);
    if (res == 0)
	return -1;                                                                  
    return res - cont + lb;
}

//---- class ObjArray -------------------------------------------------------

FIXED_STORAGE(ObjArrayIter, 20);

ObjArrayIter::ObjArrayIter(Collection *s)
{
    FIXED_SIZE_ALLOC(ObjArrayIter);
    cs= (ObjArray*)s; ce= 0; 
}

ObjArrayIter::~ObjArrayIter()
{
    FIXED_SIZE_DEALLOC(ObjArrayIter);
}

void ObjArrayIter::Reset(Collection *s)
{
    if (s == 0)
	s= cs;
    cs= (ObjArray*)s;
    ce= 0;
}

ObjPtr ObjArrayIter::operator()()
{
    for (;ce < cs->size && cs->cont[ce] == 0; ce++)
	;
    if (ce < cs->size)
	return cs->cont[ce++];
    return 0;
}

bool ObjArrayIter::Filter(ObjPtr)
{
    return TRUE;
}
