#ifndef Object_First
#define Object_First

#include "Root.h"
#include "Types.h"

typedef class Object *ObjPtr;
typedef bool (*BoolFun)(ObjPtr,ObjPtr,void*);
typedef ObjPtr (*ObjPtrFun)(ObjPtr,ObjPtr,void*);
typedef void (Object::*ObjMemberFunc)(...);     // obsolete
typedef void (Object::*VoidObjMemberFunc)(...);
typedef unsigned char (Object::*BoolObjMemberFunc)(...);

extern ostream& ClassSavePtr(ostream&, Object*);
extern istream& ClassLoadPtr(istream&, Object*&);

enum ObjFlags {
    eObjIsDeleted   = BIT(1),
    eObjDefault     = 0,
    eObjLast        = 1
};

extern bool gInPrintOn;

const int cFlagMask= 0x00ffffff;

//---- private flags, clients can only test but not set them ------------

const int cObjNonDeleted    =       0x01000000,
	  cObjDelayChanges  =       0x02000000,
	  cObjVisited       =       0x04000000,
	  cObjOnHeap        =       0x08000000,
	  cObjIsProto       =       0x10000000;

//---- class Object -----------------------------------------------------

class Object : public Root {
friend class Class;
    class OrdCollection *dependents;
    int flags;

    int DoChanged(void*);       // only used to reduce function call in changed

public:
    //---- automatically added by macro hasprototype ---------------------------
    Object(class Class*);
    virtual class Class *IsA();
    virtual void Members();
    friend Class *ObjectClassType()
	{ return ((Object*)0)->Object::IsA(); }

    //---- ordinary methods ----------------------------------------------------
    Object(int f= eObjDefault);
    virtual ~Object();

    virtual void FreeAll();

    char *ClassName();
    ObjPtr New();
    virtual void InitNew();
    int overridden(int *ip, ObjMemberFunc p) // internal interface
	{ return ((int*)_vptr)[(int)p-1] != ip[(int)p-1]; }
#   define Overridden(class,method)overridden((int*)::_NAME2_(class,__vtbl),&class::method)

    //----- flag manipulation --------------------------------------------------
    void SetFlag(int f, bool b);
    void SetFlag(int f)
	{ flags|= f & cFlagMask; }
    void ResetFlag(int f)
	{ flags&= ~(f & cFlagMask); }
    bool TestFlag(int f)
	{ return (flags & f) != 0; }
    void InvertFlag(int f)
	{ flags^= f & cFlagMask; }

    void MarkAsDeleted()
	{ SetFlag(eObjIsDeleted); }
    bool IsDeleted()
	{ return TestFlag(eObjIsDeleted); }
    void SetVisited()
	{ flags|= cObjVisited; }
    void ClearVisited()
	{ flags&= ~cObjVisited; }
    
    //---- misc ----------------------------------------------------------------
    virtual void Inspect(bool block= FALSE);
    virtual void EditSource(bool declaration);
    virtual void InspectorId(char *buf, int bufSize);
    
    virtual void DoError(int level, char *location, va_list va);
    void Error(char *location, char *msgfmt, ...);
    void SysError(char *location, char *msgfmt, ...);
    void Warning(char *location, char *msgfmt, ...);
    void Fatal(char *location, char *msgfmt, ...);
    virtual Object *Clone();
    virtual Object *DeepClone();

    //---- fire walls ----------------------------------------------------------
    void AbstractMethod(char*);
    void MayNotUse(char*);
    Object *guard(bool, char*);

    //---- comparing -----------------------------------------------------------
    virtual int Hash ();
    virtual bool IsEqual (Object*);
    virtual int Compare (Object*);

    //---- converting ----------------------------------------------------------
    virtual char* AsString();

    //---- change propagation --------------------------------------------------
    void AddDependent (Object*);
    Object* RemoveDependent (Object*);
    class Iterator *GetDepIter ();
    void Changed ()
	{ dependents ? DoChanged(0) : 0; }
    void ChangedWhat (void* what)
	{ dependents ? DoChanged(what) : 0; }
    virtual void DoUpdate (Object*,void*);
    bool ChangeRequest();              // returns TRUE  when change request is ok = 
    bool UpdateRequest();
    virtual void ChiefDied (Object*);  // notify dependents, that I died
    void BroadCast (ObjPtrFun, void *Arg = NULL);
    void DelayChanges();
    void FlushChanges();
    virtual bool PrintOnWhenDependent(Object *);

    //---- activation passivation ----------------------------------------------
    virtual ostream& PrintOn (ostream&s);
    virtual istream& ReadFrom(istream &);
    virtual ostream& DisplayOn (ostream&s);

    friend ostream &operator<< (ostream &o, Object &p)
	{ return p.PrintOn(o); }

    friend istream &operator>> (istream &o, Object &p)
	{ return p.ReadFrom(o); }

    friend ostream &operator<< (ostream& s, ObjPtr p)
	{ return ClassSavePtr(s, p); }

    friend istream &operator>> (istream& s, ObjPtr &op)
	{ return ClassLoadPtr(s, op); }
};

// to delay the calls to Changed and ChangedWhat an instance of the class
// DelayChanges can be declared
// eg: Text::Cut() { DelayChanges dc(this); ... }

class DoDelayChanges {
    Object *op;
public:
    DoDelayChanges(Object *o)
	{ op= o; op->DelayChanges(); }
    ~DoDelayChanges()
	{ op->FlushChanges(); }
};

#include "Class.h"

#define IsKindOf(name) IsA()->isKindOf(_NAME2_(name,ClassType)())
#define Guard(p,name) ((name*)p->guard(p->IsKindOf(name),"name"))

extern class ObjectTable *gObjectTable;

#endif Object_First

