//$MarkObjects$
 
#include "Object.h"
#include "OrdCollection.h"
#include "Set.h"
#include "ObjectTable.h"
#include "System.h"
#include "Error.h"

//---- Object Table ----------------------------------------------------------
    
static OrdCollection delayed; // insertions while an iterator is active 
			      // are delayed

static bool died= FALSE;
static bool exists= FALSE;

ObjectTable        *gObjectTable= 0;
static ObjPtr      *gRootTable= 0;
static int          gRootSlot= 0;

ObjectTable::ObjectTable()
{
    convoi= cumconvoi =seed= 0;
    
    if (exists)
	Error("ObjectTable::ObjectTable", "only one instance of ObjectTable");
    exists= TRUE;
    cursor= 0;
    fromClass= 0;
    inIterator= FALSE;
    size= SetNextPrime(10000);
    table= new ObjPtr[size]; 
}

ObjectTable::~ObjectTable()
{
    SafeDelete(table);
    died= TRUE;
}

void ObjectTable::Start(Class *clp, bool mem)
{
    if (inIterator)
	Error("ObjectTable::Start", "iterator is already active");
    if (delayed.Size() != 0)
	delayed.Empty();
    inIterator= TRUE;
    fromClass= clp;
    members= mem;
    cursor= 0;
}

void ObjectTable::End()
{
    if (!inIterator)
	Error("ObjectTable::End", "End() called without Start()");
    inIterator= FALSE;
    Iter next(&delayed);
    Object *op;
    while (op= next())
	Add(op);
    if (delayed.Size())
	delayed.Empty();
    fromClass= 0;
    cursor= 0;
}

Object *ObjectTable::operator()()
{  
    Object *op;
    
    for ( ; cursor < size ; cursor++) {
	op= table[cursor];
	if (op != 0) {
	    if (fromClass == 0)
		break;
	    if (members && fromClass == op->IsA())
		break;
	    if (!members && op->IsA() && op->IsA()->isKindOf(fromClass))
		break;
	}
    }              
    if (cursor < size) 
	return (table[cursor++]);
    else 
	return (0);
}    

void ObjectTable::Add(ObjPtr op)
{
    int slot;
    if (died)
	return;
    if (op == 0)
	Error("ObjectTable::Add", "op is 0");
    if (inIterator) {
	delayed.Add(op);
	return;
    }
    slot = FindElement (op);
    table[slot]= op;
    tally++;
    if (HighWaterMark())
	Expand(2 * size);
}

bool ObjectTable::PtrIsValid(Object *op)
{
    return table[FindElement(op)] != 0;
}

int ObjectTable::FindElement (ObjPtr op)                                         
{
    register slot,n;
    ObjPtr slotOp;

    seed++;
    slot = ((int)op >> 2) % size;
    for (n = 0; n < size; n++) {
	convoi= max(convoi, n);
	cumconvoi+= n;
	if ((slotOp = table[slot]) == 0) 
	    return slot;
	if (op == slotOp) 
	    return slot;
	if (++slot == size) 
	    slot = 0;
    } 
    return 0;
}

void ObjectTable::Remove(ObjPtr op)
{
    int i;

    if (died)
	return;
    if (op == 0)
	Error("ObjectTable::Remove", "remove 0 from ObjectTable");
    if (inIterator)
	Error("ObjectTable::Remove", "remove while iterator is active");
    i= FindElement(op);
    if (table[i] == 0 && !op->TestFlag(cObjIsProto)) { 
	Error("ObjectTable::Remove", "%d not found at %d (%s)", (int)op, i,
							    op->ClassName());
	for (int j= 0; j < size; j++) {
	    if (table[j] == op) {
		Error("ObjectTable::Remove", "%d found at %d !!!", (int)op, j);
		i= j;
	    }
	}
    }
    table[i]= 0;
    FixCollisions(i);
    tally--;
}

void ObjectTable::FixCollisions (int index)                                         
{
    int oldIndex, nextIndex;
    Object *nextObject;
    
    oldIndex= index+1;
    for (;;oldIndex++) {
	if (oldIndex >= size)
	    oldIndex= 0;
	nextObject= table[oldIndex];
	if (nextObject == 0)
	    break;
	nextIndex= FindElement(nextObject);
	if (nextIndex != oldIndex) {
	    table[nextIndex]= nextObject;
	    table[oldIndex]= 0;
	}
    }
}

void ObjectTable::Expand(int newSize)
{
    ObjPtr *oldTable= table, op;

    int oldsize= size;
    newSize= SetNextPrime(newSize);
    table = new ObjPtr[newSize];
    size = newSize;
    tally= 0;
    for (int i= 0; i < oldsize; i++) {
	op= oldTable[i];
	if (op)
	    Add(op);
    }
    delete oldTable; 
}

void ObjectTable::HashStatistics()
{
    double mean= 0.0;
    if (seed)
	mean= (float)cumconvoi/(float)seed;
    cerr << "Hashing statistics of ObjectTable\n";
    cerr << "Capacity= " << size SP << "Tally= " << tally SP;
    cerr << "MaxConvoi= " << convoi SP << "Mean Convoi= " << mean NL;
}

void ObjectTable::Verify() 
{
    for (int i= 0; i < size; i++) {
	//if (table[i] && table[i]->_vptr == 0) {
	//    cerr << "VERIFY: " << (int) table[i] SP << "vptr == 0" NL;
	//    break;
	//}
	if (table[i]) {
	    Object *op= table[i];
	    op->IsA();
	}
    }
}

//---- friends ----------------------------------------------------------

void ObjectTableUpdateInstCount()
{
    register Class *clp;
    Object *op;
    
    if (gObjectTable == 0)
	return;
	
    Iter sp(ClassIterator());
    
    while (clp= (Class*) sp())
	clp->ResetInstanceCount();
    
    gObjectTable->Start();    
    while (op= (*gObjectTable)()) {
	if (op->IsA())
	    op->IsA()->AddInstance(); 
    } 
    gObjectTable->End();
}

int ObjectTableInstances()
{
    if (gObjectTable == 0)
	return 0;
    return gObjectTable->tally;
}

void ObjectTableAdd(Object *op)
{
#   ifdef ET_PROGENV

    extern bool gAddToInstTable;

    if (gAddToInstTable) {
	if (gObjectTable == 0 && !died)
	    gObjectTable= new ObjectTable;
	gObjectTable->Add(op);
    }
    
#   endif ET_PROGENV
}
    
void ObjectTableRemove(Object *op)
{ 
#   ifdef ET_PROGENV
    if (gObjectTable && !op->TestFlag(cObjIsProto)) 
	gObjectTable->Remove(op);
#   endif ET_PROGENV
}

bool ObjectTablePtrIsValid(Object *op)
{ 
    if (gObjectTable)
	return gObjectTable->PtrIsValid(op);
    return TRUE;
}

void ObjectTableAddRoot(Object *op)
{
#   ifdef ET_PROGENV    
    if (gRootTable == 0)
	gRootTable= new ObjPtr[200];
    gRootTable[gRootSlot++]= op;
#   endif ET_PROGENV
}

void ObjectTableAddRoots(Object *arg1, Object *, ...)
{
    Object *op;
    va_list ap;
    va_start(ap, arg1);
    for (int i= 0; op= va_arg(ap, Object*); i++)
	ObjectTableAddRoot(op);  
    va_end(ap);
}

//---- MarkObjects --------------------------------------------------------------        
	
class MarkObjects: public AccessMembers {
    Object *current;
public:
    MarkObjects()
	{ current= 0; }
    void Member(char *name, short offset, int type);
    void VectorMember(char *name, short offset, short offsetTolen, int type);
    void ConstVectorMember(char *name, short offset, short len, int type);
    void Mark(Object *op); 
    void MarkVector(short offset, short len); 
}; 

void MarkObjects::Mark(Object *op)
{ 
    Object *saved= current; 
    if (op && !op->TestFlag(cObjVisited)) { 
	current= op;
	current->SetVisited();
	op->IsA()->EnumerateMembers(this);
    }
    current= saved;
}

void MarkObjects::Member(char *, short offset, int type)
{
    if ((type > 0) && (type == (T_OBJECT+T_PTR))) {
	Object *o= *(Object**)((unsigned long) current + (unsigned long) offset);
	Mark(o);
    }    
}

void MarkObjects::VectorMember(char *, short offset, short offsetTolen, int type)
{
    extern bool ValidAddress(void*);
    if ((type > 0) && (type == (T_OBJECT+T_PTR+T_VEC))) {
	short s;
	int *lp= (int*) ((unsigned long) current + (unsigned long) offsetTolen);
	if (!ValidAddress(lp))
	    return;
	s= (short)*lp;
	MarkVector(offset, s);
    }
}

void MarkObjects::ConstVectorMember(char *, short offset, short len, int type)
{
    if ((type > 0) && (type == (T_OBJECT+T_PTR+T_ARR)))
	MarkVector(offset, len);
}
    
void MarkObjects::MarkVector(short offset, short s)
{
    Object **ov= *(Object***)((unsigned long) current + (unsigned long) offset);
    if (ov) 
	for (int i= 0; i < s; i++) 
	    if (ov[i])
		Mark(ov[i]);
}

void ObjectTableVisitObjects()
{
#   ifdef ET_PROGENV
    Object *op;
    char buf[200];
    
    if (!gObjectTable || !gRootTable)
	return;
    gObjectTable->Start();    
    while (op= (*gObjectTable)()) 
	op->ClearVisited();
    gObjectTable->End();
    
    MarkObjects m;
    cout << "Objects unreachable from:" NL;
    cout << "=========================" NL;
    buf[0]= '\0';
    for (int i= 0; i < gRootSlot; i++) {
	op= gRootTable[i];
	op->InspectorId(buf, sizeof buf);
	cout << form("\t0x%x (%s): %s\n", (int)op, op->ClassName(), buf);
	m.Mark(op);   
    } 
    cout << "-------------------------" NL;
    gObjectTable->Start();    
    while (op= (*gObjectTable)()) 
	if (!op->TestFlag(cObjVisited)) 
	    cout << form("0x%x (%s)\n", (int)op, op->ClassName());
    gObjectTable->End();
    cout << "=============================" NL;
#   endif ET_PROGENV
}

ONEXIT(ObjectTable)
{
    SafeDelete(gObjectTable);
    SafeDelete(gRootTable);
}
