#ifndef ObjectTable_First
#define ObjectTable_First

#include "Types.h"

extern class ObjectTable *gObjectTable; // only instance of object table 

//---- Object Table ----------------------------------------------------------
// this class registers all instances of Object or its subclasses
// in a hash table

class ObjectTable {
    Object **table;
    int size;           
    int tally;
    int cursor;              // for iterating
    class Class *fromClass;  // looking for instances of class in operator()()
    bool members;            // return only direct members of a clas in "   "
    bool inIterator;        

    //---- statistics
    int convoi;
    long cumconvoi;
    int seed;

    void Expand(int newsize);
    bool HighWaterMark ()
	{ return tally >= ((3 * size /4)); }
    int FindElement (Object*);
    void FixCollisions (int index);
public:
    ObjectTable();
    ~ObjectTable();
    void HashStatistics();
    void Add(Object*);
    void Remove(Object*);
    bool PtrIsValid(Object *);      // check wether the given pointer is valid
    void Start(Class *cl= 0, bool members= TRUE);
    Object *operator()();
    void End();
    void Verify();
    //---- friends
    friend void ObjectTableAdd(Object *op);
    friend void ObjectTableAddRoot(Object *op); // add a root object
    friend void ObjectTableAddRoots(Object*, Object*, ...);
    friend void ObjectTableRemove(Object *op);
    friend void ObjectTableUpdateInstCount();
    friend bool ObjectTablePtrIsValid(Object *);
    friend void ObjectTableVisitObjects();  // visit all objects, reachable 
					    // from root objects
    friend int ObjectTableInstances();     // return total number of instances 
};

#endif ObjectTable

