#ifndef OrdCollection_First
#define OrdCollection_First

#include "SeqCollection.h"
#include "ObjArray.h"

//---- ordered collection ------------------------------------------

class OrdCollection: public SeqCollection {
friend class OrdCollectionIter;
friend class RevOrdCollectionIter;
    ObjArray *cont;    
    void RemoveDeleted();
    bool LowWaterMark()
	{ return  (size < (cont->Size() / 4) && size > cCollectionInitCap); }
    ObjPtr DoRemoveAt(int index);    

public:
    MetaDef(OrdCollection);
    OrdCollection(int s= 1);
    ~OrdCollection();

    void FreeAll();
    void Empty(int initSize = cCollectionInitCap);
    void InitNew();
    ObjPtr Add(ObjPtr);
    void AddAt(int,ObjPtr); // add an element at the position i 
    void InsertAfter(ObjPtr after, ObjPtr op);
    void InsertBefore(ObjPtr before, ObjPtr op);
    ObjPtr Remove(ObjPtr);
    ObjPtr RemovePtr(ObjPtr);
    ObjPtr RemoveAt(int); // remove and element at the given position
    ObjPtr At(int i);
    ObjPtr AtAfter(ObjPtr op); // returns 0 if op is the last item
    ObjPtr AtBefore(ObjPtr op); // return 0 if op is the first item
    ObjPtr First();
    ObjPtr Last();
    void Sort(); 
	// based on compare
    int BinarySearch(ObjPtr); 
	// the collection has to be sorted !! -1 == not found
    int Capacity();

    //---- enumerating
    Iterator *GetIterator(); 
    Iterator *ReversedIterator();
};

class OrdCollectionIter : public Iterator {
protected:
    int ce;
    OrdCollection *cs;
public:
    OrdCollectionIter(Collection *s);
    ~OrdCollectionIter();
    ObjPtr operator()();
    Collection *Coll();
    void Reset(Collection *s= 0);
};

class RevOrdCollectionIter : public OrdCollectionIter {
public:
    RevOrdCollectionIter(Collection *s);
    ObjPtr operator()();    
    void Reset(Collection *s= 0);
};

#endif OrdCollection_First
