#ifndef Browser_First
#define Browser_First

#include "Document.h"
#include "CollectionView.h"
#include "ObjArray.h"
#include "TreeView.h"

//---- BrowserDoc ------------------------------------------------------------

class BrowserDoc: public Document {
    class CodeTextView *textview;
    class ClassListView *listview;
    class Text *text;
    Class *ccl;
    bool isCCode, definition;
    class OrdCollection *log;

    void DoSetClass(Class *, bool decl, bool unique);
    char *FirstWordOfSelection();

public:
    MetaDef(BrowserDoc);
    BrowserDoc();
    ~BrowserDoc();

    Window *DoMakeWindows();
    bool Open();
    void DoRead(istream &s, FileType *);
    void DoWrite(ostream &s, int);
    bool CanImportDocument(FileType *);
    Command *DoImport(istream& s, FileType *);

    void SetClass(Class *, bool decl);
    void SelectSourceLine(bool redraw);
    void SetMode(bool decl);
    Class *GetClass()
	{ return ccl; }
    bool GetMode()
	{ return definition; }
    void DoCreateMenu(Menu *menu);
    Command *DoMenuCommand(int cmd);
    void DoSetupMenu(Menu *menu);
    void Log(Class *cl);
    void Spawn();
    void EditSelectedClass();
};

//---- ClassListView ---------------------------------------------------------

class ClassListView: public CollectionView {
    OrdCollection *ClassItems;
    BrowserDoc *browserDoc;
public:
    MetaDef(ClassListView);
    ClassListView(class BrowserDoc *);
    ~ClassListView();
    void LoadClasses();
    void SelectCurrentClass();
    void DoSelect(Rectangle r);
    void DoUpdate (Object*,void*);
};

//---- Class table for Flat Inheritance View ----------------------------------

class FihClassTable: public Object {
    class ObjArray *table;
    int maxlevel, nClasses; 
public:
    MetaDef(FihClassTable);
    FihClassTable();
    ~FihClassTable();
    void AtPut(int row, int col, Object *op)
	{ table->AtPut(nClasses*row + col, op); } 
    Object *At(int row, int col)
	{ return table->At(nClasses*row + col); } 
    VObject *MakeCell(Class *clp, bool bold= FALSE); 
    int Rows()
	{ return nClasses; }
    int Cols()
	{ return maxlevel; }
    Collection *Table()
	{ return table; }
    
};

//---- FihView --------------------------------------------------------------

class FihView: public CollectionView {
    FihClassTable* ft;
public:
    MetaDef(FihView);
    FihView(FihClassTable* f): (0, f->Table(), eCVDontStuckToBorder, f->Rows(), f->Cols())
	{ ft= f; }
    void DoSelect(Rectangle r);
    void ShowClass(class Class *);
};

//---- ClassTreeView ---------------------------------------------------------

class ClassTreeView: public TreeView {
public:
    MetaDef(ClassTreeView);
    ClassTreeView();
    VObject *BuildClassTree(Class *);
    Command *NodeSelected(VObject*, int cl);
    void ShowClass(Class *cl);
};

#endif Browser_First

