#ifndef Inspector_First
#define Inspector_First

#include "Class.h"
#include "CollectionView.h"
#include "Window.h"
#include "Reference.h"

//---- InspectorView ---------------------------------------------------------

class InspectorView: public CollectionView {
    Ref inspected;
    class Menu *menu;
    AccessMembers *accessor;
    class Inspector *inspector;
public:
    MetaDef(InspectorView);
    InspectorView(Inspector *);
    ~InspectorView();
    void DoSelect(Rectangle r);
    void UpdateViews();
    void SetInspected(Ref &i);
    void Init(Object *op);
    void DoUpdate (ObjPtr op, void*);
    void ChiefDied (Object *op);
    void Draw(Rectangle r);
    void SetInfo(char *name= 0, int t= cNONE, short o= 0, int len= 0);
    Menu *GetMenu()
	{  return menu;}
    Command *DoMenuCommand(int cmd);
    void DoCreateMenu(Menu *menu);
    void DoSetupMenu(Menu *menu);
    void Push(Ref &r);
    void Pop();
    class InspectorItem *At(int i)
	{ return (InspectorItem*) GetCollection()->At(i); }
    void SetExtent(Point newExtent);
    bool PrintOnWhenDependent(Object *);
};

//---- ObjectItem --------------------------------------------------------------

class ObjectItem: public TextItem {
    Object *op;
public:
    MetaDef(ObjectItem);    
    ObjectItem(int id, Object *op);
    ObjectItem(int id, char *, Object *op);
    ObjectItem(char *, Object *op);
    Object *GetObject()
	{ return op; }
};

//---- ShowMembers --------------------------------------------------

class ShowMembers: public AccessMembers {
public:
    void ClassName(char *name);
    void Member(char *name, short offset, int type);
    void VectorMember(char *name, short offset, short offsetTolen, int type);
    void ConstVectorMember(char *name, short offset, short len, int type);
};    

//---- FindReferences --------------------------------------------------------------

class FindReferences: public AccessMembers {
    class Inspector *ib;
public:
    FindReferences(Inspector *ib);
    void Member(char *name, short offset, int type);
    void VectorMember(char *name, short offset, short offsetTolen, int type);
    void ConstVectorMember(char *name, short offset, short len, int type);
};    

//---- Inspector ----------------------------------------------------------------

class Inspector: public EvtHandler {
    class Window *win;
    CollectionView *classes, *objects, *references;
    SeqCollection *ClassItems, *ObjectItems, *ReferenceItems;
    TextItem *refTitle, *objTitle;    
    Object *referencesTo, *currentOp;
    class FindReferences *findReferences;
    class SysEvtHandler *refresh;
    bool hideEmptyClasses;
public:
    MetaDef(Inspector);
    Inspector(WindowFlags);
    ~Inspector();
    void Init(Object *op);
    void Layout(WindowFlags);
    void UpdateList();
    void LoadObjectsOfClass(class Class *, bool members);
    void Member(int mode, char *name, int offset, int size= 0);
    void References(Object*);
    void Reset();
    void ResetReferences();
    void ResetObjects();
    void DoInspect(Object *);

    //---- menus ------------
    EvtHandler *GetNextHandler()
	{ return 0; }
    void Control(int id, int, void *v);
    Command *DoMenuCommand(int cmd);
    void DoSetupMenu(Menu *menu);

    //---- commands ---------
    void ShowAllInstances();
};

#endif Inspector_First


