#include "Picture.h"
#include "Storage.h"
#include "String.h"

struct PictItem {
    char type;
    byte pat;
    byte mode;
    char psz;
    byte cap;
    int i;
    Rectangle r;
    Point p1, p2;
    FontPtr fdp;
    void *v;
};

Picture::Picture(int sz)
{
    size= max(sz, cExpandIncr);
    pi= new PictItem[size];
}

Picture::~Picture()
{
    register PictItem *pip= pi;
    register int i;

    for (i= 0; i < len; i++, pip++) {
	switch (pip->type) {
	case 't':
	    if (pip->i > 0)
		delete (byte*) pip->v;
	    break;
	case 'b':
	    delete (Bitmap*) pip->v;
	    break;
	case 'e':
	    delete (Picture*) pip->v;
	    break;
	case '#':
	    if (pip->i > 0)
		delete (byte*) pip->v;
	    break;
	}
    }
    delete pi;
}
	
void Picture::Expand(int sz)
{
    size+= sz <= 0 ? cExpandIncr : sz;
    Realloc(&pi, size*sizeof(PictItem));
}

void Picture::Close()
{
    if (len >= size)
	Expand(1);
    pi[len].type= 'x';
}

void Picture::AddSimple(char t, GrPattern pat, GrMode mode, Rectangle *r,
					 int psz, GrLineCap cap, Point p)
{
    if (len >= size)
	Expand();
    register PictItem *pip= &pi[len++];
    
    pip->type= t;
    pip->pat= pat;
    pip->mode= mode;
    pip->r= *r;
    pip->psz= psz;
    pip->cap= cap;
    pip->p1= p;
    Merge(r);
}

void Picture::AddPoly(char t, GrPattern pat, GrMode mode, Point *pts, int npts,
					    GrPolyType pt, int psz, GrLineCap cap)
{
    if (len >= size)
	Expand();
    register PictItem *pip= &pi[len++];
    
    /*
    pip->type= t;
    pip->pat= pat;
    pip->mode= mode;
    pip->r= *r;
    pip->psz= psz;
    pip->cap= cap;
    pip->v= poly;
    Merge(r);
    */
}

void Picture::AddLine(GrPattern pat, GrMode mode, Rectangle *r, int psz,
					    GrLineCap cap, Point p1, Point p2)
{
    if (len >= size)
	Expand();
    register PictItem *pip= &pi[len++];
    
    pip->type= 'l';
    pip->pat= pat;
    pip->mode= mode;
    pip->r= *r;
    pip->psz= psz;
    pip->cap= cap;
    pip->p1= p1;
    pip->p2= p2;
    Merge(r);
}

void Picture::AddBitmap(GrPattern pat, GrMode mode, Rectangle *r, Bitmap *bp)
{
    if (len >= size)
	Expand();
    register PictItem *pip= &pi[len++];
    
    pip->type= 'i';
    pip->pat= pat;
    pip->mode= mode;
    pip->r= *r;
    pip->v= bp;
    Merge(r);
}

void Picture::AddText(GrPattern pat, GrMode mode, Rectangle *r, Point p,
				    FontPtr fdp, int cnt, byte *list)
{
    if (len >= size)
	Expand();
    register PictItem *pip= &pi[len++];
    
    pip->type= 't';
    pip->pat= pat;
    pip->mode= mode;
    pip->r= *r;
    pip->p1= p;
    pip->fdp= fdp;
    pip->i= cnt;
    pip->v= NewBytes(cnt);
    bcopy(list, (byte*) pip->v, cnt);
    Merge(r);
}

void Picture::AddPicture(Rectangle *r, Picture *pic)
{
    if (len >= size)
	Expand();
    register PictItem *pip= &pi[len++];
    
    pip->type= 'e';
    pip->r= *r;
    pip->v= pic;
}

void Picture::DevGiveHint(int code, int l, void *vp)
{
    if (len >= size)
	Expand();
    pi[len].type= 'h';
    pi[len].pat= code;
    pi[len].i= l;
    pi[len++].v= vp;
}

void Picture::Show(Rectangle *re, Port *port)
{
    register int i;
    register PictItem *pip= pi;
    register float sx, sy;
    GrPattern pat;
    GrMode mode;
    GrLineCap cap;
    int psz;
    Rectangle cliprect, rr, *r;
    Point p1, p2, delta;
    void *v;
    bool inclip, scale= FALSE;

    if (port == 0)
	return;
    inclip= port->inclip;
    cliprect= port->cliprect;
    
    if (re->extent != bbox.extent) {
	scale= TRUE;
	sx= (float) re->extent.x / (float) bbox.extent.x;
	sy= (float) re->extent.y / (float) bbox.extent.y;
    } else
	delta= re->origin-bbox.origin;

    for (i= 0; i < len; i++, pip++) {
    
	if (scale) {
	    rr.origin= Scale(pip->r.origin-bbox.origin, sx, sy) + re->origin;
	    rr.extent= Scale(pip->r.extent, sx, sy);
	} else
	    rr= pip->r+delta;

	if (inclip && !cliprect.Intersects(rr))
	    continue;
	 
	r= &rr;
	pat= (GrPattern) pip->pat;
	mode= (GrMode) pip->mode;
	cap= (GrLineCap) pip->cap;
	psz= (int) pip->psz;
	v= pip->v;
	p1= pip->p1;
	p2= pip->p2;
	
	switch (pip->type) {
	case 'l':
	    if (scale) {
		p1= Scale(p1-bbox.origin, sx, sy) + re->origin;
		p2= Scale(p2-bbox.origin, sx, sy) + re->origin;
	    } else {
		p1= p1+delta;
		p2= p2+delta;
	    }
	    port->DevStrokeLine(pat, mode, psz, r, cap, p1, p2);
	    break;
	case 'B':
	    port->DevFillRect(pat, mode, r);
	    break;
	case 'b':
	    port->DevStrokeRect(pat, mode, psz, r);
	    break;
	case 'o':
	    port->DevStrokeOval(pat, mode, psz, r);
	    break;
	case 'O':
	    port->DevFillOval(pat, mode, r);
	    break;
	case 'r':
	    port->DevStrokeRRect(pat, mode, psz, r, p1);
	    break;
	case 'R':
	    port->DevFillRRect(pat, mode, r, p1);
	    break;
	case 'w':
	    port->DevStrokeWedge(pat, mode, psz, cap, r, p1.x, p1.y);
	    break;
	case 'W':
	    port->DevFillWedge(pat, mode, r, p1.x, p1.y);
	    break;
	case 'i':
	    port->DevShowBitmap(pat, mode, r, (Bitmap*)v);
	    break;
	case 'p':
	    // port->DevStrokePolygon(pat, mode, psz, v, r, cap);
	    break;
	case 'P':
	    // port->DevFillPolygon(pat, mode, (GrPolygon*)v, r);
	    break;
	case 't':
	    /*
	    if (! scale)  // no scaled fonts yet!
		port->DevShowTextBatch(pat, mode, pip->fdp, r, p1+delta, pip->i,
								(byte*)v);
	    */
	    break;
	case 'e':
	    port->DevShowPicture(r, (Picture*)pip->v);
	    break;
	case '#':
	    port->DevGiveHint(pat, pip->i, v);
	    break;
	case 'x':
	    return;
	}
    }
}

ostream& Picture::PrintOn (ostream &s)
{
    return s;
}

ostream& operator<< (ostream &s, PicturePtr &pic)
{
    return pic->PrintOn(s);
}

istream& operator>> (istream &s, PicturePtr&)
{
    return s;
}

