//$Port$
#include "Port.h"
#include "String.h"
#include "Error.h"
#include "Picture.h"

Port *port, *tbport;
bool fullscreen;

//---- Port --------------------------------------------------------------------

Port::Port(int code)
{
    type= code;
    PortInit();
}

Port::~Port()
{
    FlushMyText();
    Destroy();
}

void Port::PortInit()
{
    SetNormal();
    SetPenNormal();
    SetTextNormal();
    pendingclip= TRUE;
}

//---- abstract cursor methods -------------------------------------------------

GrCursor Port::SetCursor(GrCursor c)
{ 
    return c;
}

GrCursor Port::SetWaitCursor(unsigned int, GrCursor c)
{
    return SetCursor(c);
}

GrCursor Port::GetCursor()
{
    return 0;
}

//---- graphics context --------------------------------------------------------

void Port::SetPenNormal()
{
    pensize= 1;
    penpatid= ePatBlack;
    penmode= eRopCopy;
    pencap= eDefaultCap;
}

void Port::SetTextNormal()
{
    textpatid= ePatBlack;
    textmode= eRopCopy;
    textfd= gSysFont;
}

//---- clipping ----------------------------------------------------------------

void Port::Clip(Rectangle r, Point o)
{
    if (fullscreen)
	return;
    if (inclip && cliprect == r && origin == o)
	return;
    if (r.IsEmpty())
	return;
    FlushMyText();
    if (inclip && !pendingclip)
	DevResetClip();
    cliprect= r;
    origin= o;
    inclip= pendingclip= TRUE;
}

void Port::ResetClip()
{
    if (fullscreen)
	return;
    if (inclip && !pendingclip) {
	FlushMyText();
	DevResetClip();
    }
    pendingclip= inclip= FALSE;
}

//---- graphic primitives ------------------------------------------------------

void Port::StrokeLine(GrPattern pat, GrMode mode, int psz, GrLineCap cap,
							    Point p1, Point p2)
{
    FlushMyText();
    p1+= origin;
    p2+= origin;
    Rectangle rr= NormRect(p1,p2).Expand(psz/2);
    if (Visible(pat, rr)) {
	FlushClip(); 
	DevStrokeLine(pat, mode, psz, &rr, cap, p1, p2);
    }
}

void Port::StrokeRect(GrPattern pat, GrMode mode, int psz, Rectangle *r)
{
    FlushMyText();
    Rectangle rr= *r+origin;
    if (Visible(pat, rr)) {
	FlushClip();
	DevStrokeRect(pat, mode, psz, &rr);
    }
}

void Port::FillRect(GrPattern pat, GrMode mode, Rectangle *r)
{
    FlushMyText();
    Rectangle rr= *r+origin;
    if (Visible(pat, rr)) {
	FlushClip();
	DevFillRect(pat, mode, &rr);
    }
}

void Port::StrokeOval(GrPattern pat, GrMode mode, int psz, Rectangle *r)
{
    FlushMyText();
    Rectangle rr= *r+origin;
    if (Visible(pat, rr)) {
	FlushClip();
	DevStrokeOval(pat, mode, psz, &rr);
    }
}

void Port::FillOval(GrPattern pat, GrMode mode, Rectangle *r)
{
    FlushMyText();
    Rectangle rr= *r+origin;
    if (Visible(pat, rr)) {
	FlushClip(); 
	DevFillOval(pat, mode, &rr);
    }
}

void Port::StrokeRRect(GrPattern pat, GrMode mode, int psz, Rectangle *r,
								    Point dia)
{
    FlushMyText();
    Rectangle rr= *r+origin;
    if (Visible(pat, rr)) {
	FlushClip();
	DevStrokeRRect(pat, mode, psz, &rr, dia);
    }
}

void Port::FillRRect(GrPattern pat, GrMode mode, Rectangle *r, Point dia)
{
    FlushMyText();
    Rectangle rr= *r+origin;
    if (Visible(pat, rr)) {
	FlushClip(); 
	DevFillRRect(pat, mode, &rr, dia);
    }
}

void Port::StrokeWedge(GrPattern pat, GrMode mode, int psz, GrLineCap cap,
						Rectangle *r, int s, int e)
{
    FlushMyText();
    Rectangle rr= *r+origin;
    if (Visible(pat, rr)) {
	FlushClip();
	if (s == 0 && e == 360)
	    DevStrokeOval(pat, mode, psz, &rr);
	else
	    DevStrokeWedge(pat, mode, psz, cap, &rr, s, e);
    }
}

void Port::FillWedge(GrPattern pat, GrMode mode, Rectangle *r, int s, int e)
{
    FlushMyText();
    Rectangle rr= *r+origin;
    if (Visible(pat, rr)) {
	FlushClip(); 
	if (s == 0 && e == 360)
	    DevFillOval(pat, mode, &rr);
	else
	    DevFillWedge(pat, mode, &rr, s, e);
    }
}

void Port::StrokePolygon(Point at, GrPattern pat, GrMode mode, Point *pts, int npts,
				    GrPolyType t, int psz, GrLineCap cap)
{
    Point p[1000];
    Rectangle r;
    
    FlushMyText();
    for (int i= 0; i < npts; i++)
	p[i]= pts[i];
    r= BoundingBox(npts, p);
    r.origin+= at+origin;
    if (Visible(pat, r)) {
	FlushClip();
	DevStrokePolygon(&r, pat, mode, p, npts, t, psz, cap);
    }
}

void Port::FillPolygon(Point at, GrPattern pat, GrMode mode, Point *pts, int npts,
					    GrPolyType t)
{
    Point p[1000];
    Rectangle r;
    
    FlushMyText();
    for (int i= 0; i < npts; i++)
	p[i]= pts[i];
    r= BoundingBox(npts, p);
    r.origin+= at+origin;
    if (Visible(pat, r)) {
	FlushClip();
	DevFillPolygon(&r, pat, mode, p, npts, t);
    }
}

void Port::ShowBitmap(GrPattern pat, GrMode mode, Rectangle *r,
							    Bitmap *bm)
{
    FlushMyText();
    Rectangle rr= *r+origin;
    if (Visible(pat, rr)) {
	FlushClip();
	DevShowBitmap(pat, mode, &rr, bm);
    }
}

void Port::ShowPicture(Rectangle *r, Picture *pic)
{
    if (pic) {
	FlushMyText();
	Rectangle rr= *r+origin;
	if (Visible(ePatBlack, rr)) {
	    FlushClip(); 
	    DevShowPicture(&rr, pic);
	}
    }
}

void Port::DevShowPicture(Rectangle *r, Picture *pic)
{
    pic->Show(r, this);
}

void Port::GiveHint(int n, int l, void *vp)
{
    Rectangle r;
    switch (n) {
    case eHintLock:
	FlushClip();
	break;
	
    case eHintUnlock:
	FlushMyText();
	break;

    case eHintTextBatch:
	break;
	
    case eHintTextUnbatch:
	FlushMyText();
	break;
	
    case eHintBatch:
	FlushClip();
	r= *((Rectangle*) vp);
	r.origin+= origin;
	DevGiveHint(n, l, &r);
	break;
    
    case eHintFlush:
	if (tbport)
	    tbport->flushtext();
    
    default:
	DevGiveHint(n, l, vp);
	break;
    }
}

//---- Lines -------------------------------------------------------------------

void Port::Lineto(Point p)
{
    StrokeLine(penpatid, penmode, pensize, pencap, penpos, p);
    penpos= p;
}

//---- Text ---------------------------------------------------------------------

void Port::SetFamily(GrFont fid)
{
    textfd= new Font(fid, textfd->Size(), textfd->Face());
}

void Port::SetSize(int ps)
{
    textfd= new Font(textfd->Fid(), ps, textfd->Face());
}

void Port::SetFace(GrFace face)
{
    textfd= new Font(textfd->Fid(), textfd->Size(), face);
}

//---- text batch --------------------------------------------------------------

static short tbpat;
static short tbmode;
static Point tbpos;
static Rectangle tbbbox;
static Point tblastpos;
static bool tbnew= TRUE;

bool Port::DevShowChar(FontPtr, Point, byte, bool, Point)
{
    return FALSE;
}

void Port::flushtext()
{
    FlushClip();
    DevShowTextBatch(tbpat, tbmode, &tbbbox, tbpos+origin);  
    tbport= 0;
}

void Port::DrawChar(byte c)
{
    Rectangle rr;
    int w;

    rr.origin= textpos + origin;
    rr.origin.y-= textfd->Ascender();
    rr.extent.x= w= textfd->Width(c);
    rr.extent.y= textfd->Spacing();

    if (Visible(textpatid, rr)) {
	if (this != tbport || textpatid != tbpat || textmode != tbmode)
	    FlushAnyText();
	
	if (tbport == 0) {
restart:
	    tbport= this;
	    tbpat= textpatid;
	    tbmode= textmode;
	    tblastpos= tbpos= textpos;
	    tbbbox= rr;
	    tbnew= TRUE;
	} else 
	    tbbbox.Merge(rr);
	if (DevShowChar(textfd, textpos-tblastpos, c, tbnew, textpos+origin)) {
	    FlushAnyText();
	    goto restart;
	}
	tbnew= FALSE;
	tblastpos= textpos;
	tblastpos.x+= w;
    }
    textpos.x+= w;
}

void Port::ShowString(FontPtr fdp, GrPattern pat, GrMode mode, Point pos,
								byte *s, int l)
{
    Rectangle rr;
    register int i, w;
    byte c;

    if (s == NULL)
	return;
	
    if (this != tbport || pat != tbpat || mode != tbmode)
	FlushAnyText();
	
    if (l < 0)
	l= strlen(s);
	
    rr.origin= pos + origin;
    rr.origin.y-= fdp->Ascender();
    rr.extent.y= fdp->Spacing();

    for(i= 0; i < l; i++) {
	c= *s++;
	rr.extent.x= w= fdp->Width(c);
	if (Visible(pat, rr)) {
	    if (tbport == 0) {
    restart:
		tbport= this;
		tbpat= pat;
		tbmode= mode;
		tblastpos= tbpos= pos;
		tbbbox= rr;
		tbnew= TRUE;
	    } else
		tbbbox.Merge(rr);
	    if (DevShowChar(fdp, pos-tblastpos, c, tbnew, pos+origin)) {
		FlushAnyText();
		goto restart;
	    }
	    tbnew= FALSE;
	    tblastpos= pos;
	    tblastpos.x+= w;
	}
	rr.origin.x+= w;
	pos.x+= w;
    }
}

void Port::DrawString(byte *text, int l)
{
    Rectangle rr;
    register int i, w;
    byte c;

    if (text == NULL)
	return;
	
    if (this != tbport || textpatid != tbpat || textmode != tbmode)
	FlushAnyText();
	
    if (l < 0)
	l= strlen(text);
	
    rr.origin= textpos + origin;
    rr.origin.y-= textfd->Ascender();
    rr.extent.y= textfd->Spacing();

    for(i= 0; i < l; i++) {
	c= *text++;
	rr.extent.x= w= textfd->Width(c);
	if (Visible(textpatid, rr)) {
	    if (tbport == 0) {
restart:
		tbport= this;
		tbpat= textpatid;
		tbmode= textmode;
		tblastpos= tbpos= textpos;
		tbbbox= rr;
		tbnew= TRUE;
	    } else
		tbbbox.Merge(rr);
	    if (DevShowChar(textfd, textpos-tblastpos, c, tbnew, textpos+origin)) {
		FlushAnyText();
		goto restart;
	    }
	    tbnew= FALSE;
	    tblastpos= textpos;
	    tblastpos.x+= w;
	}
	rr.origin.x+= w;
	textpos+= w;
    }
}

//---- device dependent methods ------------------------------------------------

void Port::DrawObject(char, GrPattern, GrMode, Rectangle*, Point, int, GrLineCap)
{
}

void Port::DrawPolygon(char, GrPattern, GrMode, Rectangle*, Point*, int, GrPolyType, int, GrLineCap)
{
}

void Port::DevDestroy()
{
}

void Port::DevClip(Rectangle, Point)
{
    AbstractMethod("DevClip");
}

void Port::DevResetClip()
{
    AbstractMethod("DevResetClip");
}

void Port::DevStrokeLine(GrPattern, GrMode, int, Rectangle*, GrLineCap, Point, Point)
{
    AbstractMethod("DevStrokeLine");
}

void Port::DevStrokeRect(GrPattern pat, GrMode mode, int psz, Rectangle *r)
{
    DrawObject('b', pat, mode, r, Point(0), psz, 0);
}

void Port::DevFillRect(GrPattern pat, GrMode mode, Rectangle *r)
{
    DrawObject('B', pat, mode, r, Point(0), -1, 0);
}

void Port::DevStrokeOval(GrPattern pat, GrMode mode, int psz, Rectangle *r)
{
    DrawObject('o', pat, mode, r, Point(0), psz, 0);
}

void Port::DevFillOval(GrPattern pat, GrMode mode, Rectangle *r)
{
    DrawObject('O', pat, mode, r, Point(0), -1, 0);
}

void Port::DevStrokeRRect(GrPattern pat, GrMode mode, int psz, Rectangle *r,
								     Point dia)
{
    DrawObject('r', pat, mode, r, dia, psz, 0);
}

void Port::DevFillRRect(GrPattern pat, GrMode mode, Rectangle *r, Point dia)
{
    DrawObject('R', pat, mode, r, dia, -1, 0);
}

void Port::DevStrokeWedge(GrPattern pat, GrMode mode, int psz, GrLineCap cap,
						    Rectangle *r, int s, int e)
{
    DrawObject('w', pat, mode, r, Point(s,e), psz, cap);
}

void Port::DevFillWedge(GrPattern pat, GrMode mode, Rectangle *r, int s, int e)
{
    DrawObject('W', pat, mode, r, Point(s,e), -1, 0);
}

void Port::DevStrokePolygon(Rectangle *r, GrPattern pat, GrMode mode, Point *pts,
			    int npts, GrPolyType t, int psz, GrLineCap cap)
{
    DrawPolygon('P', pat, mode, r, pts, npts, t, psz, cap);
}

void Port::DevFillPolygon(Rectangle *r, GrPattern pat, GrMode mode, Point *pts,
							int npts, GrPolyType t) 
{
    DrawPolygon('P', pat, mode, r, pts, npts, t, -1, 0);
}

void Port::DevShowBitmap(GrPattern, GrMode, Rectangle*, struct Bitmap*)
{
    AbstractMethod("DevShowBitmap");
}

void Port::DevShowTextBatch(GrPattern, GrMode, Rectangle*, Point)
{
    AbstractMethod("DevShowTextBatch");
}

void Port::DevGiveHint(int, int, void*)
{
}
