//$PrintDialog$
#include "PrintDialog.h"
#include "DialogItems.h"
#include "CheapText.h"
#include "Window.h"
#include "System.h"
#include "PrintPort.h"
#include "Document.h"
#include "FileDialog.h"
#include "Error.h"
#include "ObjList.h"
#include "CollectionView.h"
#include "Scroller.h"
#include "Printer.h"
#include "ObjectTable.h"
#include "Alert.h"

const int cNameMinWidth =  150;
Printer *gPrinters[10];
PrintDialog *gPrintManager= 0;
bool gPrinting= FALSE;

int ShowPrintDialog(VObject *v)
{
    if (gPrintManager == 0) {
	gPrintManager= new PrintDialog;
	ObjectTableAddRoot(gPrintManager);
    }
    return gPrintManager->ShowPrintDialog(v);
}

//---- PrintDialog -------------------------------------------------------------

const int cIdSaveToFile =   cIdFirstUser + 2,
	  cIdOptions    =   cIdFirstUser + 3,
	  cIdFrom       =   cIdFirstUser + 4,
	  cIdTo         =   cIdFirstUser + 5,
	  cIdShowGrid   =   cIdFirstUser + 6,
	  cIdPrint      =   cIdFirstUser + 7,
	  cIdPrinters   =   cIdFirstUser + 100;
	  
MetaImpl(PrintDialog, (I_O(saveDialog), I_O(optionDialog), I_O(scroller),
    I_O(collview), I_O(printers), I_O(current), I_O(lastcurrent), I_O(window),
    I_O(vobject), I_O(from), I_O(to), I_CS(title), I_B(showgrid),
    I_B(lastshowgrid), I_I(lastfrom), I_I(lastto), I_I(lastprinter)));

PrintDialog::PrintDialog(char *t) : (t, eBWinBlock)
{
    title= t;
    showgrid= FALSE;

    printers= new OrdCollection;
    
    for (int i= 0; gPrinters[i]; i++) {
	VObject *vop= new TextItem(i, gPrinters[i]->GetName(), gSysFont, Point(4,0));
	printers->Add(vop);
    }
    collview= new CollectionView(this, printers);
    collview->SetMinExtent(Point(cNameMinWidth+20, 0));
    collview->SetId(cIdPrinters);
    collview->SetContainer(this);
}

PrintDialog::~PrintDialog()
{
    if (printers) {
	printers->FreeAll();
	SafeDelete(printers);
    }
}

void PrintDialog::DoSetDefaults()
{
    from->SetValue(1);
    to->SetValue(999);
    collview->SetSelection(Rectangle(0,0,1,1));
    current= gPrinters[0];
}

void PrintDialog::DoSave()
{
    lastfrom= from->GetValue();
    lastto= to->GetValue();
    lastprinter= collview->GetSelection().origin.y;
    lastcurrent= current;
}

void PrintDialog::DoRestore() 
{
    from->SetValue(lastfrom);
    to->SetValue(lastto);
    collview->SetSelection(Rectangle(0,lastprinter,1,1));    
    current= lastcurrent;
}

void PrintDialog::DoSetup()
{
    bool b= current != 0;
    EnableItem(cIdSaveToFile, b);
    EnableItem(cIdOptions, b && current->GetOptions());
    EnableItem(cIdPrint, b && current->CanPrint());
}

int PrintDialog::ShowPrintDialog(VObject *v)
{
    if (v) {
	window= v->GetWindow();
	vobject= v;
	return ShowOnWindow(window);
    }
    return -1;
}
 
VObject *PrintDialog::DoCreateDialog()
{
    //---- dialog parts ----
    
    scroller= new Scroller(collview, Point(cNameMinWidth, 16*4), cIdPrinters);

    VObject *Options=
	new BorderItem("Options", new LabeledButton(cIdShowGrid, "show pages"));

    VObject *Actions=
	new Cluster(cIdNone, eVObjHLeft|eVObjHExpand, 8,
	    new ActionButton(cIdYes,        "Apply", TRUE),
	    new ActionButton(cIdPrint,      "Print"),
	    new ActionButton(cIdSaveToFile, "Save as ..."),
	    new ActionButton(cIdOptions,    "Options"),
	    new ActionButton(cIdCancel,     "Cancel"),
	    new ActionButton(cIdDefault,    "Default"),
	    0
	);
	
    VObject *Pages=
	new BorderItem("Pages",
	    new Cluster(cIdNone, eVObjVBase|eVObjHExpand, 20,
		new TextItem("From:"),
		from= new NumItem(cIdFrom, 1, 1, 999, 3, 1),
		new TextItem("To:"),
		to= new NumItem(cIdTo, 999, 1, 999, 3, 1),
		0
	    )
	);
	
    //---- overall layout ----
    return
	new BorderItem(
	    new Cluster(cIdNone, eVObjVTop, 20,
		new Cluster(cIdNone, eVObjHLeft, 20,
		    scroller,
		    Options,
		    Pages,
		    0
		),
		Actions,
		0
	    ),
	    20, 0
	);
}

void PrintDialog::Control(int id, int p, void *v)
{
    switch (id) {
    
    case cIdShowGrid:
	showgrid= !showgrid;
	if (vobject)
	    vobject->ForceRedraw();
	break;
    
    case cIdOptions:
	if (current && current->GetOptions()) {
	    if (current->ShowOnWindow(window) == cIdOk) {
		if (vobject)
		    vobject->ForceRedraw();
	    }
	}
	return;
    
    case cIdPrinters:
	if (p == cPartCollSelect) {
	    current= gPrinters[(int) v];
	    DoSetup();
	}
	break;
    
    case cIdSaveToFile:
	if (saveDialog == 0)
	    saveDialog= new FileDialog();
	if (saveDialog->ShowInWindow(eFDWrite, window) == cIdOk) {
	    Print(saveDialog->FileName());
	    Dialog::Control(cIdYes, p, v);
	}
	break;
	
    case cIdPrint:
	Print(0);
	break;
    }
    Dialog::Control(id, p, v);
}

void PrintDialog::ShowPageGrid(Rectangle)
{
    if (showgrid && !gPrinting && current && vobject) {
	int x, y;
	Point e= vobject->GetExtent(), ps= current->GetPageSize();
	GrSetPenSize(3);
	GrSetPenPattern(ePatGrey50);
	for (x= ps.x; x <= e.x; x+= ps.x)
	    GrLine(Point(x,0), Point(x,e.y));
	for (y= ps.y; y <= e.y; y+= ps.y)
	    GrLine(Point(0,y), Point(e.x,y));
	GrSetPenNormal();
    }
}

void PrintDialog::Print(char *name)
{
    PrintPort *newport= current->MakePrintPort(name);
    if (newport) {
	GrCursor oldcursor= GrSetWaitCursor();
	PortDesc currport= GrGetPort();
	PortDesc oldport= window->GetPortDesc();

	gPrinting= TRUE;
	GrSetPort(newport);
	window->SetPortDesc(newport);
	
	Point po, pe= current->GetPageSize();
	Rectangle vr= vobject->contentRect;
	int np= 1;
	
	for (po.y= 0; po.y <= vr.extent.y; po.y+= pe.y) {
	    for (po.x= 0; po.x <= vr.extent.x; po.x+= pe.x) {
		if (np >= from->GetValue() && np <= to->GetValue()) {
		    if (TestInterrupt("printing"))
			goto out;
		    newport->OpenPage(np);
			GrSetClip(pe, -po);
			GrSetPenNormal();
			GrSetMode(eRopCopy);
			GrSetPattern(ePatBlack);
			vobject->DrawAll(Rectangle(po, pe));
			newport->GiveHint(eHintFlush, 0, 0);
		    newport->ClosePage();
		}
		np++;
	    }
	}
out:
	window->SetPortDesc(oldport);
	gPrinting= FALSE;
	
	GrSetPort(currport);
	GrSetCursor(oldcursor);
	SafeDelete(newport);
    }
}
