//$RestrTextView$

#include "RestrTextView.h"
#include "RegularExp.h"
#include "BlankWin.h"

MetaImpl(RestrTextView, I_O(rex));

RestrTextView::RestrTextView(EvtHandler *eh, RegularExp *rx, Rectangle r, Text *t,
			    eTextJust m, eSpacing sp, bool w,
			    TextViewFlags fl, Point b, int id)
					    : (eh,r,t,m,sp,w,fl,b,id) 
{
    rex= rx;
}
   
bool RestrTextView::Match(class Text* t, RegularExp *rex)
{
    int n, size = t->Size();
    if (size == 0) // zero length text matches all patterns
	return TRUE;
    int pos= t->Search(rex, &n, 0, size);
    delete t;
    return (pos == 0 && n == size);
}

void RestrTextView::NotAccepted ()
{
    gWindow->Bell(20);
}

void RestrTextView::SetRegExp(RegularExp* r)
{
    rex= r;
}

void RestrTextView::Cut() 
{
    int from, to;
    
    GetSelection(&from, &to);
    Text *tmp= CopyText();
    tmp->Cut(from,to);
    if (!Match(tmp,rex)) 
	NotAccepted();
    else
	TextView::Cut();
}          

void RestrTextView::Paste(Text *insert)
{
    int from, to;
    
    GetSelection(&from, &to);
    Text *tmp= CopyText();
    tmp->Paste(insert, from, to);
    if (!Match(tmp, rex)) 
	NotAccepted();
    else
	TextView::Paste(insert);
}

Text *RestrTextView::CopyText() 
{
    Text *ct= 0, *t= GetText();
    
    if (t) {
	t->RemoveDependent(this);
	ct= (Text*) t->DeepClone();
	t->AddDependent(this);
    }
    return ct;   
}
