#ifndef RestrTextView_First
#define RestrTextView_First

#include "TextView.h"

//---- RestrTextView --------------------------------------------------------
// restricted textview: the contents of a restricted textview will always match
// a regular expression

class RestrTextView: public TextView {
    class RegularExp *rex;

    bool Match(class Text*, RegularExp *);
    class Text *CopyText();

public:
    MetaDef(RestrTextView);
    
    RestrTextView(EvtHandler *eh, RegularExp *, Rectangle r,  
	     Text *t, eTextJust m= eLeft,
	     eSpacing= eOne, bool wrap= TRUE, TextViewFlags= eVObjDefault, 
	     Point border = gBorder, int id = -1);    
	    
    virtual void NotAccepted ();
	    // text modification refused due to mismatch with
	    // regular expression, default implementation executes a ring bell
    
    RegularExp *GetRegExp()
	{ return rex; }
    void SetRegExp(RegularExp*);
	    
    //---- overriden to check match against regular expression 
    void Cut();            
    void Paste(Text *insert);    
};

#endif RestrTextView_First  
