//$ServerConnection$
#include "ServerConnection.h"
#include "ServerPort.h" 

#include "../Error.h"
#include "../String.h"
#include "../SUNOS/sunsystem.h"
#include "../SUNOS/sunsockets.h"

ServerConnection *gConnection= 0;

ServerConnection::ServerConnection() : (0)
{
    ifp= ofp= 0;
    sequence= 4711;
    
    sock= ConnectService(SERVERNAME, SERVICENAME);
    if (sock >= 0) {
	ifp= fdopen(sock, "r");
	ofp= fdopen(sock, "w");
    }
    SetResourceId(sock);
}

bool ServerConnection::HasInterest()
{
    Flush();
    return ! ShouldRemove();
}

void ServerConnection::Notify(SysEventCodes, int)
{
    Response rp;
    
    while (!SafeRead(&rp, 0, FALSE))
	if (rp.port)
	    rp.port->Send(&rp.t);
}

void ServerConnection::Close()
{
    if (ofp && ifp) {
	if (ofp) {
	    fflush(ofp);
	    fclose(ofp);
	}
	if (ifp)
	    fclose(ifp);
	close(sock);
	Remove();
    }
}

bool ServerConnection::SafeRead(Response *b, int timeout, bool overread)
{
    for (;;) {
	if (ofp)
	    fflush(ofp);
	    
	if (overread) {
	    bool first= TRUE;
	    do {
		if (myread(ifp, timeout, b, sizeof(struct Response)))
		    break;
		first= FALSE;
	    } while (b->t.Code == eEvtLocMove || b->t.Code == eEvtLocMoveBut);
	    if (first)
		return TRUE;
	} else if (myread(ifp, timeout, b, sizeof(struct Response)))
	    return TRUE;
	    
	if (b->port) {
	    if (b->t.Code == eEvtDamage) {
		b->port->Send(&b->t);
		continue;
	    }
	    return FALSE;
	}
	if (b->t.Pos.x > 0) {
	    b->t.At= (int) new byte[b->t.Pos.x];
	    fread((char*)b->t.At, b->t.Pos.x, 1, ifp);
	}
	return FALSE;
    }
}

//-------------------------------------------------------------------------------
#undef va_start
#undef va_end
#undef va_arg

typedef char *va_list1;
# define va_start(list,par) list = (char *) &par
# define va_end(list)
# define va_arg(list,mode) ((mode *)(list += sizeof(mode)))[-1]

/*
 i  integer                    integer
 s  short                      short
 p  Point                      Point
 r  Rectangle                  Rectangle
 b  byte string                int, byte*
*/

void ServerConnection::Send(int tag, int ref, char *fmt, ...)
{
    register char c;
    short s, *sp;
    byte *bs= 0;
    Point p, *pp;
    int i, *ip, bl, intCnt= 0, shortCnt= 0, pointCnt= 0, rectCnt= 0;
    Rectangle r, *rp;
    Message m;
    Response resp;
    
    m.tag= tag;
    m.id= ref;
    m.seq= sequence;
    if (fmt == 0) {
	if (fwrite((char*) &m, sizeof(Message), 1, ofp) == 0) 
	    SysError("ServerConnection::Send (fwrite)", FALSE);
	sequence++;
	return; 
    }
    
    va_list1 ap;
    
    va_start(ap, fmt);
    fmt= va_arg(ap, char*);
    
    while (c= *fmt++) {
	switch (c) {
	case 's':               // short
	    s= va_arg(ap, int);
	    switch (shortCnt) {
	    case 0:
		m.s1= s;
		break;
	    case 1:
		m.s2= s;
		break;
	    case 2:
		m.s3= s;
		break;
	    default:
		Error("ServerConnection::Send", "no more shorts");
		break;
	    }
	    shortCnt++;
	    break;
	case 'i':               // int
	    i= va_arg(ap, int);
	    switch (intCnt) {
	    case 0:
		m.i1= i;
		break;
	    default:
		Error("ServerConnection::Send", "no more ints");
		break;
	    }
	    intCnt++;
	    break;
	case 'p':               // Point
	    p= va_arg(ap, Point);
	    switch (pointCnt) {
	    case 0:
		m.p1= p;
		break;
	    case 1:
		m.p2= p;
		break;
	    default:
		Error("ServerConnection::Send", "no more points");
		break;
	    }
	    pointCnt++;
	    break;
	case 'r':               // Rectangle
	    r= va_arg(ap, Rectangle);
	    switch (rectCnt) {
	    case 0:
		m.r1= r;
		break;
	    default:
		Error("ServerConnection::Send", "no more rectangles");
		break;
	    }
	    rectCnt++;
	    break;
	case 'b':               // byte*
	    bl= va_arg(ap, int);
	    bs= va_arg(ap, byte*);
	    switch (shortCnt) {
	    case 0:
		m.s1= bl;
		break;
	    case 1:
		m.s2= bl;
		break;
	    case 2:
		m.s3= bl;
		break;
	    default:
		Error("ServerConnection::Send", "no more shorts");
		break;
	    }
	    shortCnt++;
	    break;
	case ' ':
	    break;
	default:
	    if (c >= 'A' && c <= 'Z')
		goto out;
	    Error("ServerConnection", "SendFmt");
	    break;
	}
    }
out:
    
    if (fwrite((char*) &m, sizeof(Message), 1, ofp) == 0) 
	SysError("ServerConnection::Send (fwrite)", FALSE);
    if (bs) {
	int res= 0;
	while (bl > 0) {
	    res= fwrite((char*) bs+res, 1, bl, ofp);
	    if (res == 0)
		SysError("ServerConnection::Send (fwrite)", FALSE);
	    bl-= res;
	}
    }
	
    if (c) {

	for (;;) {
	    resp.port= 0;
	    SafeRead(&resp, -1, FALSE); // block
	    if (resp.port) {
		((ServerPort*)resp.port)->Enqueue(&resp);
		continue;
	    }
	    if (resp.t.Flags == sequence)
		break;
	}

	do {
	    switch (c) {
	    case 'S':               // short
		sp= (short*) va_arg(ap, int*);
		*sp= resp.t.Code;
		break;
	    case 'I':               // int
		ip= va_arg(ap, int*);
		*ip= resp.t.Code;
		break;
	    case 'P':               // Point
		pp= va_arg(ap, Point*);
		*pp= resp.t.Pos;
		break;
	    case 'R':               // Rectangle
		rp= va_arg(ap, Rectangle*);
		break;
	    case 'B':               // byte*
		bl= va_arg(ap, int);
		bs= va_arg(ap, byte*);
		if (bl != resp.t.Pos.x)
		    Error("ServerConnection::Send", "diff in bytecnt");
		bl= min(bl, resp.t.Pos.x);
		if (resp.t.At) {
		    if (bl > 0)
			bcopy((byte*)resp.t.At, bs, bl);
		    Free((void*)resp.t.At);
		    resp.t.At= 0;
		}
		break;
	    case 'Z':
	    case 'Y':
	    case ' ':
		break;
	    default:
		Error("ServerConnection", "SendFmt");
		break;
	    }
	} while (c= *fmt++);
    }
	
    sequence++;
    va_end(ap);
}

