//$ServerPort$
#include "ServerPort.h"
#include "../Error.h"
#include "../String.h"
#include "ServerFont.h"
#include "ServerBitmap.h"

#include "ServerConnection.h"

static byte *tblist, *tbcp;
static FontPtr lastfdp= 0;

//------------------------------------------------------------------------------

ServerPort::ServerPort(InpHandlerFun nf, void *priv1, void *priv2, bool ov, bool bl)
{
    Init(nf, priv1, priv2, ov, bl);
    
    gConnection->Send(eMsgMakeWindow, -1, "ssiI", ov, bl, (int)this, &ref);
    out= 1;
    in= MQS;
    
    if (tblist == 0)
	tbcp= tblist= new byte[MaxTextBatchCnt];
}

void ServerPort::DevDestroy2()
{
    gConnection->Send(eMsgDestroy, ref);
    gConnection->Flush();
}

void ServerPort::DevClip(Rectangle r, Point p)
{
    gConnection->Send(eMsgClip, ref, "rp", r, p);
}

void ServerPort::DevResetClip()
{
    gConnection->Send(eMsgResetClip, ref);
}

void ServerPort::DevStrokeLine(GrPattern pat, GrMode mode, int ps, Rectangle *r,
			    GrLineCap cap, Point p1, Point p2)
{
    gConnection->Send(eMsgStrokeLine, ref, "sssppir", pat, mode, cap,
								p1, p2, ps, *r);
}

void ServerPort::DevStrokeRect(GrPattern pat, GrMode mode, int ps, Rectangle *r)
{
    gConnection->Send(eMsgStrokeRect, ref, "ssri", pat, mode, *r, ps);
}

void ServerPort::DevFillRect(GrPattern pat, GrMode mode, Rectangle *r)
{
    gConnection->Send(eMsgFillRect, ref, "ssr", pat, mode, *r);
}

void ServerPort::DevStrokeRRect(GrPattern pat, GrMode mode, int ps, Rectangle *r, Point dia)
{
    gConnection->Send(eMsgStrokeRRect, ref, "ssrip", pat, mode, *r, ps, dia);
}

void ServerPort::DevFillRRect(GrPattern pat, GrMode mode, Rectangle *r, Point dia)
{
    gConnection->Send(eMsgFillRRect, ref, "ssrp", pat, mode, *r, dia);
}

void ServerPort::DevStrokeOval(GrPattern pat, GrMode mode, int ps, Rectangle *r)
{
    gConnection->Send(eMsgStrokeOval, ref, "ssri", pat, mode, *r, ps);
}

void ServerPort::DevFillOval(GrPattern pat, GrMode mode, Rectangle *r)
{
    gConnection->Send(eMsgFillOval, ref, "ssr", pat, mode, *r);
}

void ServerPort::DevStrokeWedge(GrPattern pat, GrMode mode, int ps, GrLineCap cap,
						Rectangle *r, int s, int e)
{
    gConnection->Send(eMsgStrokeWedge, ref, "ssisrp", pat, mode, ps, cap, *r, Point(s,e));
}

void ServerPort::DevFillWedge(GrPattern pat, GrMode mode, Rectangle *r, int s, int e)
{
    gConnection->Send(eMsgFillWedge, ref, "ssrp", pat, mode, *r, Point(s,e));
}

void ServerPort::DevStrokePolygon(Rectangle*, GrPattern, GrMode, Point*, int, GrPolyType, int, GrLineCap)
{
}

void ServerPort::DevFillPolygon(Rectangle*, GrPattern, GrMode, Point*, int, GrPolyType)
{
}

void ServerPort::DevShowBitmap(GrPattern pat, GrMode mode, Rectangle *r,
								   Bitmap *bm)
{
    gConnection->Send(eMsgShowBitmap, ref, "ssri", pat, mode, *r,
						((ServerBitmap*)bm)->GetId());
}

bool ServerPort::DevShowChar(FontPtr fdp, Point delta, byte c, bool isnew, Point)
{
    if (isnew) {
	tbcp= tblist;
	lastfdp= 0;
    }
    
    if (tbcp-tblist >= MaxTextBatchCnt-15)
	return TRUE;
	
    if (fdp != lastfdp) {
	*tbcp++= '#';
	*tbcp++= 'f';
	*tbcp++= (byte) ((ServerFont*)fdp)->GetId();
	lastfdp= fdp;
    }
    if (delta.x) {
	short d= delta.x;
	*tbcp++= '#';
	*tbcp++= 'x';
	*tbcp++= d >> 8;
	*tbcp++= d & 0xff;
    }
    if (delta.y) {
	short d= delta.y;
	*tbcp++= '#';
	*tbcp++= 'y';
	*tbcp++= d >> 8;
	*tbcp++= d & 0xff;
    }
    if (c == '#')
	*tbcp++= '#';
    *tbcp++= c;
    return FALSE;
}

void ServerPort::DevShowTextBatch(GrPattern pat, GrMode mode, Rectangle *r, Point pos)
{
    gConnection->Send(eMsgShowTextBatch, ref, "ssrpb", pat, mode, *r, pos,
						    (int)(tbcp-tblist), tblist);
}

void ServerPort::DevGiveHint(int code, int len, void *vp)
{
    switch (code) {
    case eHintTextBatch:
    case eHintTextUnbatch:
    case eHintLock:
    case eHintUnlock:
	return;
    case eHintFlush:
	break;
    default:
	gConnection->Send(eMsgGiveHint, ref, "sb", code, len, vp);
    }
    gConnection->Flush();
}

void ServerPort::DevFullscreen(bool mode)
{
    gConnection->Send(eMsgFullscreen, ref, "s", mode);
}

void ServerPort::DevScrollRect(Rectangle r, Point p)
{
    gConnection->Send(eMsgScrollRect, ref, "rpZ", r, p);
}

void ServerPort::DevTop(bool top)
{
    gConnection->Send(eMsgTop, ref, "s", top);
};

void ServerPort::DevHide()
{
    gConnection->Send(eMsgHide, ref);
};

void ServerPort::DevShow(WindowPort *father, Rectangle r)
{
    if (father)
	gConnection->Send(eMsgShow, ref, "ir", ((ServerPort*)father)->ref, r);
    else
	gConnection->Send(eMsgShow, ref, "ir", -1, r);
};

void ServerPort::DevSetRect(Rectangle *r)
{
    gConnection->Send(eMsgSetRect, ref, "r", *r);
};

inline int addone(int i)
{
    return (i % MQS) + 1;
}

void ServerPort::Enqueue(Response *rp)
{
    if (addone(addone(in)) != out) {
	in= addone(in);
	rps[in]= *rp;
    }    
}

Response *ServerPort::Dequeue()
{
    Response *r;
    
    if (addone(in) == out)
	return 0;
    r= &rps[out];
    out= addone(out);
    return r;
}
   
void ServerPort::DevGetEvent(Token *t, int timeout, bool overread)
{
    Response *r, rp;
    bool first= TRUE;
    
    do {
	while ((r= Dequeue()) == 0) {
	    if (overread) {
		if (gConnection->SafeRead(&rp, timeout, FALSE)) {
		    if (first) {
			t->Code= eEvtNone;
			t->Pos= lastpos;
			t->Flags= 0;
			t->At= lasttime;
			return;
		    }
		    if (rp.port)
			((ServerPort*)rp.port)->Enqueue(&rp);
		}
		first= FALSE;
	    } else {
		if (gConnection->SafeRead(&rp, timeout, FALSE)) {
		    t->Code= eEvtNone;
		    t->Pos= lastpos;
		    t->Flags= 0;
		    t->At= lasttime;
		    return;
		}
		if (rp.port)
		    ((ServerPort*)rp.port)->Enqueue(&rp);
	    }
	}
    } while (r->port == 0);
    
    *t= r->t;
    if (t->Code != eEvtDamage) {
	lastpos= t->Pos;
	lasttime= t->At;
    }
};

void ServerPort::DevGrab(bool mask)
{
    gConnection->Send(eMsgGetAll, ref, "s", mask);
}
    
void ServerPort::DevSetMousePos(Point p)
{
    gConnection->Send(eMsgSetMousePos, ref, "p", p);
};

void ServerPort::DevMoveMousePos(Point p)
{
    gConnection->Send(eMsgMoveMousePos, ref, "p", p);
};

void ServerPort::DevBell(long d)
{
    gConnection->Send(eMsgBell, ref, "i", (int) d);
}

void ServerPort::DevSetCursor(GrCursor c)
{
    gConnection->Send(eMsgSetCursor, ref, "s", (short) c);
}
