//$ServerWindowSystem$
#include "ServerSystem.h"

#include "ServerPort.h"
#include "ServerFont.h"
#include "ServerBitmap.h"
#include "ServerConnection.h"

//---- ServerWindowSystem ------------------------------------------------------

ServerWindowSystem::ServerWindowSystem() : ("ServerSunWindow")
{
}
	
WindowSystem *NewServerWindowSystem()
{
    WindowSystem *s= new ServerWindowSystem();
    
    if (s->Open())
	return s;
    delete s;
    return 0;
}

bool ServerWindowSystem::Open()
{
    if (! WindowSystem::Open())
	return FALSE;
    gConnection= new ServerConnection();
    if (gConnection->GetResourceId() < 0) {
	SafeDelete(gConnection);
	return FALSE;
    }
    gSystem->AddFileInputHandler(gConnection);
    return TRUE;
}

ServerWindowSystem::~ServerWindowSystem()
{
    SafeDelete(gConnection);
}

void ServerWindowSystem::MakeWindow(WindowPort **wp, InpHandlerFun ihf,
				void *priv1, void *priv2, bool overlay, bool block)
{
    *wp= new ServerPort(ihf, priv1, priv2, overlay, block);
}

FontManager *ServerWindowSystem::MakeFontManager(char *name)
{
    return new ServerFontManager(name);
}

void ServerWindowSystem::MakeBitmap(Bitmap **bp, Point sz, short *data)
{
    *bp= new ServerBitmap(sz, data);
}

void ServerWindowSystem::MakeBitmap(Bitmap **bp, const char *name)
{
}

void ServerWindowSystem::graphicDelay(unsigned int duration)
{
    gConnection->Send(eMsgDelay, -1, "i", duration);
}
