#include <stdio.h>
#include <a.out.h>
#include <sys/file.h>
#include <sys/types.h>
#include <errno.h>
#include <sys/stat.h>
#include <ctype.h>
#include <stab.h>
#include <frame.h>
#include <signal.h>
 
typedef unsigned long ulong;

static struct frame *framep;
static int retaddress;
static struct exec header;
static struct nlist *symbols;
static char *progname;
static int interrupt= 0;

static int lk_get_header(fd, hdrp, disp)
int fd;
struct exec *hdrp;
long disp;
{
    lseek(fd, disp, 0);
    if (read(fd, hdrp, sizeof(struct exec)) != sizeof(struct exec)) {
	hdrp->a_magic = 0;  
	return -1; 
    }
    return 0;
}

static struct nlist *lk_get_symbols(fd, hdrp, disp)
int fd;
struct exec *hdrp;
long disp;
{
    register struct nlist *buffer, *sym, *end;
    ulong size;
    long displ;

    if (N_BADMAG(*hdrp))
	return 0;

    lseek(fd, disp + N_SYMOFF(*hdrp) + hdrp->a_syms, 0);
    if (read(fd, &size, 4) != 4)
	return 0;

    buffer = (struct nlist*) Malloc(hdrp->a_syms + size);
    if (buffer == 0)
	return 0;
  
    lseek(fd, disp + N_SYMOFF(*hdrp), 0);
    if (read(fd, buffer, hdrp->a_syms + size) != hdrp->a_syms + size) {
	Free(buffer);
	return 0;
    }
  
    end= buffer + hdrp->a_syms / sizeof(struct nlist);
    displ= (long)buffer + (long)(hdrp->a_syms);

    for (sym= buffer; sym < end; sym++)
	sym->n_un.n_name= (char*) sym->n_un.n_strx + displ;

    return buffer;
}

static void getpc()
{
    ulong *p;
    
    asm("movl a6, _framep");
    p= (ulong*)framep;
    retaddress= p[1];
}

#define MAXSTACK 100
#define getfp() asm("movl a6, _framep")

void stacktrace(m, level)
int m, level;
{
    static int indebug= 0;
    register struct pframe *fp;
    register struct frame *p;
    register struct nlist *sp, *end;
    register ulong v;
    unsigned short *bb;
    int fd, j, i, f;
    unsigned char t;
    short d;
    char *n;
    struct frame first;
     
    struct pframe {
	struct frame *fp;
	ulong flow, low, lad;
	int parms;
	struct nlist *sym, *fsym, *lsym;
    } fr[MAXSTACK];
    
    if (indebug)
	_exit(1);
    indebug= 1;
    
    getfp();
    
    if (m) {
	first.fr_savfp= framep->fr_savfp->fr_savfp;
	first.fr_savpc= m;
	p= &first;
    } else
	p= framep;
	
    if (level >= MAXSTACK)
	level= MAXSTACK;
    for(f= 0; p && f < level; f++, p= p->fr_savfp) {
	fr[f].fp= p;
	fr[f].lad= fr[f].low= fr[f].flow= (ulong) 0;
	fr[f].lsym= fr[f].sym= fr[f].fsym= 0;
	fr[f].parms= 0;
	
	bb= (unsigned short*) p->fr_savpc;
	switch (bb[0]) {
	case 0x4fef:
	    fr[f].parms= bb[1]/4;
	    break;
	case 0x504f:
	    fr[f].parms= 2;
	    break;
	case 0x584f:
	    fr[f].parms= 1;
	    break;
	default:
	    fr[f].parms= 0;
	    break;
	}
    }
    fr[f-1].parms= 3;
    
    if (f == MAXSTACK) {
	fprintf(stdout, "stack overflow\n");
	abort();
    }
    
    if (symbols == 0) {
	if (progname == 0) {
	    char **argv;
	    argv= (char**) fr[f-1].fp->fr_arg[1];
	    progname= argv[0];
	}
	    
	if ((fd= open(progname, O_RDONLY)) < 0)
	    Fatal("stacktrace", "can't open %s\n", progname);
	
	lk_get_header(fd, &header, 0);
	symbols= lk_get_symbols(fd, &header, 0);
    
	close(fd);
    }
	
    end= symbols + header.a_syms / sizeof(struct nlist);
    for (sp= symbols; sp < end; sp++) {
	v= sp->n_value;
	n= sp->n_un.n_name;
	d= sp->n_desc;
	t= sp->n_type;
	
	if (t & N_STAB) {          /* DBX symbol */
	    switch (t) {
	    case N_SO:
		for (i= 0; i < f; i++) {
		    if (v <= fr[i].fp->fr_savpc  && v >= fr[i].flow) {
			fr[i].flow= v;
			fr[i].fsym= sp;
		    }
		}
		break;
	    case N_SLINE:
		for (i= 0; i < f; i++) {
		    if (v <= fr[i].fp->fr_savpc && v >= fr[i].lad) {
			fr[i].lad= v;
			fr[i].lsym= sp;
		    }
		}
		break;
	    }
	} else {
	    if (t & N_TEXT) {   /* ADB symbol */
		if (n[0] == '_') {
		    for (i= 0; i < f; i++) {
			if (v <= fr[i].fp->fr_savpc && v >= fr[i].low) {
			    fr[i].low= v;
			    fr[i].sym= sp;
			}
		    }
		} else {
		    for (i= 0; i < f; i++) {
			if (v <= fr[i].fp->fr_savpc  && v >= fr[i].flow) {
			    fr[i].flow= v;
			    fr[i].fsym= sp;
			}
		    }
		}
	    }
	}
    }

    if (! interrupt)
	fprintf(stdout, "-------------\n");
    for(fp= fr, i= 0; i < f; i++, fp++) {
	if (i > 0) {
	    fprintf(stdout, "%s(", fr[i-1].sym->n_un.n_name);
	    if (fp->parms > 0) {
		for (j= 0; j<fp->parms-1; j++)
		    fprintf(stdout, "0x%x, ", fp->fp->fr_arg[j]);
		fprintf(stdout, "0x%x", fp->fp->fr_arg[j]);
	    }
	    fprintf(stdout, ")");
	}
	if (interrupt || i > 0) {
	    if (fp->lsym)
		fprintf(stdout, ", line %d in \"%s\"",
			    fp->lsym->n_desc, fp->fsym->n_un.n_name);
	    else if (i > 0)
		fprintf(stdout, " + %x", fr[i-1].fp->fr_savpc - fr[i-1].low);
	    fprintf(stdout, "\n");
	    fflush(stdout);
	}
    }
    indebug= 0;
}

static void sigHandler(sig, code, scp)
int sig, code;
struct sigcontext *scp;
{
    extern char *sys_siglist[];
    char *msg;
    
    signal(sig, SIG_DFL);
    
    if (interrupt > 0) {
	write(2, "oops\n", 5);
	_exit(1);
    }
    interrupt++;
    
    if (sig >= 0 && sig < NSIG)
	msg= sys_siglist[sig];
    else
	msg= "signal number out of range";
    fprintf(stdout, "SIGNAL(%d): %s", sig, msg);
    stacktrace(scp->sc_pc, MAXSTACK);
    
    interrupt--;
}

int TraceInit(name)
char *name;
{
    progname= name;

    signal(SIGBUS,  sigHandler);
    signal(SIGSEGV, sigHandler); 
    signal(SIGSYS,  sigHandler); 
    signal(SIGPIPE, sigHandler); 
    signal(SIGILL,  sigHandler); 
}

int TraceCleanup()
{
    if (symbols) {
	Free(symbols);
	symbols= 0;
    }
}
