#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <setjmp.h>
#include <signal.h>
#include <stdio.h>
#include <sys/param.h>
#include <pwd.h>
#include <errno.h>
#include <sys/wait.h>
#include <ctype.h>
#include <sys/time.h>

extern char *sys_errlist[];

char *workingdirectory()
{
    static char path[MAXPATHLEN];

    if (getwd(path) == 0)
	path[0]= '\0';
    return path;
}

char *getdirentry(dirp)
DIR *dirp;
{
    struct dirent *dp;
     
    if (dirp && (dp= readdir(dirp)))
	return dp->d_name;
    return 0;
}

char *getstatbuf(path)
char *path;
{
    struct stat *statbuf;
    
    if (path != 0) {
	statbuf= (struct stat*) Malloc(sizeof (struct stat));
	if (statbuf == NULL)
	    return NULL;
	if (stat(path, statbuf) < 0)
	    return NULL;
	return (char*)statbuf;
    }
    return NULL;
}

int uniquefileid(statbuf)
struct stat *statbuf;
{    
    return statbuf->st_dev + statbuf->st_ino;
}

int isexecutable(statbuf)
struct stat *statbuf;
{
    if (statbuf->st_mode & ((S_IEXEC)|(S_IEXEC>>3)|(S_IEXEC>>6)))
	return 1;
    return 0;
}

int isdirectory(statbuf)
struct stat *statbuf;
{
    if ((statbuf->st_mode & S_IFMT) == S_IFDIR ) 
	return 1;
    return 0;
}

int isspecial(statbuf)
struct stat *statbuf;
{
    if ((statbuf->st_mode & S_IFMT) != S_IFREG && !isdirectory(statbuf))
	return 1;
    return 0;
}

long filesize(statbuf)
struct stat *statbuf;
{
    return (long) statbuf->st_size;   
}

static jmp_buf buf;

static void ValidAddressHandler()
{
    longjmp(buf, 1);
}

int ValidAddress(vp)
void **vp;
{
    void (*oldhandler)();
    int retcode= 0;
    void *dummy;
    
    oldhandler= signal(SIGSEGV, ValidAddressHandler);
    
    if (setjmp(buf))
	retcode= 0;
    else {
	retcode= 1;
	dummy= *vp;
    }
    
    signal(SIGSEGV, oldhandler);
    return retcode;
}

/* expand the metacharacters as in the shell */

static char *shellMeta   = "~*[]{}?$",
	    *shellStuff  = "(){}<>\"'",
	    shellEscape = '\\';

char *expandpathname(patbuf, buflen)
char *patbuf;
int buflen;
{
    char cmd[170], StuffedPat[200], name[70];
    register char *p, *q;
    FILE *pf;
    struct passwd *pw;
    int ch, i;

    /* skip leading blanks */
    while (*patbuf == ' ')
	patbuf++;

    /* any shell meta characters ? */
    for (p= patbuf; *p; p++)
	if (index(shellMeta, *p))
	    goto needshell;

    return 0;

needshell:    
    /* escape shell quote characters */
    StuffChar(patbuf, StuffedPat, sizeof StuffedPat, shellStuff, shellEscape);

    strcpy(cmd, "echo -n ") ;
    strcat(cmd, " ");

    /* emulate csh -> popen executes sh */
    if (StuffedPat[0] == '~') {
	if (StuffedPat[1] != '\0' && StuffedPat[1] != '/') {
	    /* extract user name */
	    for (p= &StuffedPat[1], q= name; *p && *p !='/';)
		*q++= *p++;
	    *q = '\0';
	    if ((pw= getpwnam(name)) == NULL) 
		strcat(cmd, StuffedPat); 
	    else {
		strcat(cmd, pw->pw_dir);            
		strcat(cmd, p);
	    }           
	} else {
	    if ((pw= getpwuid(getuid())) == NULL)
		return sys_errlist[errno];
	    strcat(cmd, pw->pw_dir);            
	    strcat(cmd, &StuffedPat[1]);
	}
    } else
	strcat(cmd, StuffedPat);

    if ((pf= popen(&cmd[0], "r")) == NULL)
	return sys_errlist[errno];

    /* read first argument */
    for (i= 0, ch= getc(pf); ch != EOF && ch != ' '; ch= getc(pf)) {
	if (i == buflen-1)
	    break;
	patbuf[i++]= ch;
    }
    patbuf[i]= '\0';

    /* overread rest of pipe */
    while (ch != EOF) {
	ch= getc(pf);
	if (isspace(ch))
	    return "expression ambigous";
    }

    pclose(pf);

    return 0;
}

int waitchild()
{
    union wait status;
    
    return wait3(&status, WNOHANG, 0);
}

int myread(ifp, millisec, b, size)
FILE *ifp;
int millisec, size;
void *b;
{
    int rval, fd;
    fd_set readready;
    struct timeval t, *tv= &t;
    
    fd= fileno(ifp);
		   
    if (millisec < 0) /* block */
	tv= 0;
    else if (millisec == 0)
	t.tv_sec= t.tv_usec= 0L;
    else {
	t.tv_sec= (long) (millisec / 1000);
	t.tv_usec= (long) (millisec % 1000);
    }
    for (;;) {
	FD_ZERO(&readready);
	FD_SET(fd, &readready);
	if ((rval= select(fd+1, &readready, 0, 0, tv)) < 0) {
	    if (errno != EINTR)
		perror("select");
	    continue;
	}
	if (rval == 0) /* timeout */
	    return 1;
	if (FD_ISSET(fd, &readready)) {
	    rval= fread(b, size, 1, ifp);
	    if (rval == 0) {
		if (millisec < 0)
		    Error("SafeRead", "server died");
		return 1;
	    }
	    return 0;
	}
    }
}
