#ifndef GrSunWindow_First
#define GrSunWindow_First

#include "../WindowPort.h"
#include "SunWindowSystem.h"

class SunWindowPort: public WindowPort {
public:
    SunWindowPort *next;
    SysEvtHandler *handler;
    int fd;
    Point lastpos, inpOffset, fsorigin;
    void *pw, *opw, *rpw, *pr, *opr, *rpr;
    SunWindowPort *fatherport;
    void *savepr;
    bool inbatch;
    Rectangle myrect;
    
    void SunWindowPortInit(int);
    void FreeResources();
    
public:

    SunWindowPort(InpHandlerFun, void*, void*, bool, bool);

    void DevDestroy2();
    void DevClip(Rectangle, Point);
    void DevResetClip();
    void DevStrokeLine2(GrPattern, GrMode, int, Rectangle*, GrLineCap, Point, Point);
    void DevStrokeRect2(GrPattern, GrMode, int, Rectangle*);
    void DevFillRect(GrPattern, GrMode, Rectangle*);
    void DevStrokeRRect2(GrPattern, GrMode, int, Rectangle*, Point);
    void DevFillRRect2(GrPattern, GrMode, Rectangle*, Point);
    void DevStrokeWedge2(GrPattern, GrMode, int, GrLineCap, Rectangle*, int, int);
    void DevFillWedge2(GrPattern, GrMode, Rectangle*, int, int);
    void DevStrokePolygon2(Rectangle*, GrPattern, GrMode, Point*, int, GrPolyType, int, GrLineCap);
    void DevFillPolygon2(Rectangle*, GrPattern, GrMode, Point*, int, GrPolyType);
    void DevShowBitmap(GrPattern, GrMode, Rectangle*, struct Bitmap*);
    bool DevShowChar(FontPtr, Point, byte, bool, Point);
    void DevShowTextBatch(GrPattern, GrMode, Rectangle*, Point);
    void DevGiveHint(int, int, void*);
    
    void DevSetCursor(GrCursor);

    void DevGrab(bool);
    
    void DevFullscreen(bool);
    void DevScrollRect(Rectangle, Point);

    void DevTop(bool);
    void DevHide();
    void DevShow(WindowPort *father, Rectangle);

    void DevSetRect(Rectangle*);
    
    void DevGetEvent(Token *t, int timeout, bool);    
    void DevSetMousePos(Point);
    void DevMoveMousePos(Point);

    void DevBell(long);   
};

#endif GrSunWindow_First
