//$SunWindowSystem,DamageHandler,UrgHandler$
#include "SunWindowSystem.h"
#include "../Error.h"
#include "../String.h"

#include "SunWindowPort.h"
#include "SunFont.h"
#include "SunBitmap.h"
#include "SunClipboard.h"

#include <signal.h>

//---- DamageHandler -----------------------------------------------------------

extern void TestDamage();
extern SunWindowPort *overlayport;

class DamageHandler : public SysEvtHandler {
public:
    DamageHandler() : (SIGWINCH)
	{ }
    void Notify(SysEventCodes, int);
    bool HasInterest()
	{ return overlayport == 0; }
};

void DamageHandler::Notify(SysEventCodes, int)
{
    TestDamage();
}

//---- UrgHandler --------------------------------------------------------------

static int sigurgcnt;

class UrgHandler : public SysEvtHandler {
public:
    UrgHandler() : (SIGURG)
	{ }
    void Notify(SysEventCodes, int);
};

void UrgHandler::Notify(SysEventCodes, int)
{
    sigurgcnt++;
    if (sigurgcnt > 2)
	_exit(1);
}

//---- SunWindowSystem ---------------------------------------------------------

WindowSystem *NewSunWindowSystem()
{
    WindowSystem *s= new SunWindowSystem();
    
    if (s->Open())
	return s;
    delete s;
    return 0;
}

SunWindowSystem::SunWindowSystem() : ("SunWindow")
{
}
	
bool SunWindowSystem::Open()
{
    bool ok= FALSE;
    extern bool sunwindowinit(char*);

    if (! WindowSystem::Open())
	return FALSE;
    if (sunwindowinit(LibName))
	return FALSE;
    gSystem->AddSignalHandler(damagehandler= new DamageHandler);
    gSystem->AddSignalHandler(new UrgHandler, FALSE);
    return TRUE;
}

bool SunWindowSystem::interrupted()
{
    int sc= sigurgcnt;
    sigurgcnt= 0;
    return (sc > 0);
}

void SunWindowSystem::MakeWindow(WindowPort **wp, InpHandlerFun ihf,
				void *priv1, void *priv2, bool overlay, bool block)
{
    *wp= new SunWindowPort(ihf, priv1, priv2, overlay, block);
}

FontManager *SunWindowSystem::MakeFontManager(char *name)
{
    return new SunFontManager(name);
}

void SunWindowSystem::MakeBitmap(Bitmap **bp, Point sz, short *data)
{
    *bp= new SunBitmap(sz, data);
}

void SunWindowSystem::MakeBitmap(Bitmap **bp, const char *name)
{
    *bp= new SunBitmap(name);
}

ClipBoard *SunWindowSystem::MakeClipboard()
{
    return new SunClipBoard;
}
