#ifndef sunfont_first
#define sunfont_first

#include <pixrect/pixrect.h>
#include <pixrect/pixfont.h>

#define MAXCHAR 256

typedef enum GrFace {
    eFacePlain      = 0,
    eFaceBold       = BIT(0),
    eFaceItalic     = BIT(1),
    eFaceUnderline  = BIT(2),
    eFaceOutline    = BIT(3),
    eFaceShadow     = BIT(4)
} GrFace;

typedef struct fd {
    void *vptr;
    byte fd_cw[256];            /* character widths */
    byte fd_family;             /* family id */
    byte fd_size;               /* point size */
    byte fd_face;               /* style */
    byte fd_ils;                /* interline spacing */
    byte fd_ht;                 /* maximum ascender */
    byte fd_bs;                 /* maximum descender */
    byte fd_wd;                 /* maximum descender */
    BOOL fd_fixed;
    
    struct pixrect *fd_notdef;  /* pixrect of missing character symbol */
    struct pixfont *fd_pf;      /* the pixfont */
    char *fd_name;              /* name of v-font file */
    BOOL fd_loaded;             /* all pixrects are in memory */
} Font, *FontPtr;

#endif sunfont_first

