//$ScrollBarButton,ScrollBar$
#include "ScrollBar.h"
#include "Slider.h"
#include "DialogItems.h"

const int eScrollBarUpLeft      = cPartLast + 0,
	  eScrollBarDownRight   = cPartLast + 1,
	  eScrollBarSlider      = cPartLast + 2;

static short UpArrowBits[]= {
#   include "images/UpArrow.image"
};
static short InvUpArrowBits[]= {
#   include "images/UpArrowInv.image"
};
static short DownArrowBits[]= {
#   include "images/DownArrow.image"
};
static short InvDownArrowBits[]= {
#   include "images/DownArrowInv.image"
};
static short LeftArrowBits[]= {
#   include "images/LeftArrow.image"
};
static short InvLeftArrowBits[]= {
#   include "images/LeftArrowInv.image"
};
static short RightArrowBits[]= {
#   include "images/RightArrow.image"
};
static short InvRightArrowBits[]= {
#   include "images/RightArrowInv.image"
};

static StaticBitmap
    ArrowUp(16, UpArrowBits),       InvArrowUp(16, InvUpArrowBits),
    ArrowDown(16, DownArrowBits),   InvArrowDown(16, InvDownArrowBits),
    ArrowLeft(16, LeftArrowBits),   InvArrowLeft(16, InvLeftArrowBits),
    ArrowRight(16, RightArrowBits), InvArrowRight(16, InvRightArrowBits);

//---- ScrollBarButton ---------------------------------------------------------

class ScrollBarButton: public ImageButton {
public:
    ScrollBarButton(int id, Bitmap *b1, Bitmap *b2) : (id, b1, b2, TRUE)
	{ SetFlag(eVObjHFixed|eVObjVFixed); }
    void Draw(Rectangle)
	{ GrPaintBitMap(contentRect.Inset(2), bm1, Enabled() ? ePatBlack : ePatGrey50); }
    Metric GetMinSize()
	{ return ImageButton::GetMinSize().Expand(2); }
    void Highlight(HighlightState)
	{ GrInvertBitMap(contentRect.Inset(2), bm2); }
};

//---- ScrollBar ---------------------------------------------------------------

MetaImpl(ScrollBar, I_O(slider));

ScrollBar::ScrollBar(int id, Direction v) : (id, v)
{
    Add(new ScrollBarButton(eScrollBarUpLeft, v ? &ArrowUp : &ArrowLeft,
					      v ? &InvArrowUp : &InvArrowLeft));
    Add(slider= new Slider(eScrollBarSlider, v));
    Add(new ScrollBarButton(eScrollBarDownRight, v ? &ArrowDown : &ArrowRight,
						 v ? &InvArrowDown : &InvArrowRight));
}

void ScrollBar::DrawBackground(Rectangle)
{
    GrSetPenNormal();
    GrStrokeRect(contentRect);
}

void ScrollBar::ViewSizeChanged(Point vsz)
{
    slider->SetMax(vsz);
    slider->Update();
}

void ScrollBar::BubbleUpdate(Point relOrig)
{
    slider->SetVal(relOrig);
    slider->Update();
}

void ScrollBar::SetBubbleSize(Point sz)
{
    slider->SetBubbleSize(sz);
    slider->Update();
}

void ScrollBar::Init(Point e, Point sz, Point vsz)
{
    slider->SetBubbleSize(sz);
    slider->SetMax(vsz);
    SetExtent(e);
}

void ScrollBar::Control(int id, int part, void *val)
{
    Point scroll;
    
    switch (id) {
    case eScrollBarUpLeft:
	part= cPartScrollStep;
	scroll[dir]= -1;
	break;
    case eScrollBarDownRight:
	part= cPartScrollStep;
	scroll[dir]= 1;
	break;
    case eScrollBarSlider:
	switch (part) {
	case eSliderPageUpLeft:
	    part= cPartScrollPage;
	    scroll[dir]= -1;
	    break;
	case eSliderPageDownRight:
	    part= cPartScrollPage;
	    scroll[dir]= 1;
	    break;
	case eSliderThumb:
	    if (dir) {
		part= cPartScrollVAbs;
		scroll.y= ((Point*) val)->y;
	    } else {
		part= cPartScrollHAbs;
		scroll.x= ((Point*) val)->x;
	    }
	    break;
	}
	break;
    default:
	VObject::Control(id, part, val);
	return;
    }
    VObject::Control(GetId(), part, &scroll);
}
