//$SeqCollection$
#include "SeqCollection.h"

MetaImpl0(SeqCollection);

AbstractClass(SeqCollection);

SeqCollection::SeqCollection()
{
}

void SeqCollection::InsertBefore(ObjPtr, ObjPtr)
{
    AbstractMethod("InsertBefore");
}

void SeqCollection::InsertAfter(ObjPtr, ObjPtr)
{
    AbstractMethod("InsertAfter");
}

ObjPtr SeqCollection::AtBefore(ObjPtr)
{
    AbstractMethod("AtBefore");
    return 0;
}

ObjPtr SeqCollection::AtAfter(ObjPtr)
{
    AbstractMethod("AtAfter");
    return 0;
}

ObjPtr SeqCollection::At(int n)
{
    Iter next(this);
    register ObjPtr op;
    register int i;
    
    for (i = 0; (op = next()) && i < n; i++)
	;
    return op;
}

ObjPtr SeqCollection::First()
{
    AbstractMethod("First");
    return 0;
}

ObjPtr SeqCollection::Last()
{
    AbstractMethod("Last");
    return 0;
}

void SeqCollection::AddFirst(ObjPtr op)
{
    ObjPtr first = First();
    if (first)
	InsertBefore(first,op);
    else
	Add(op);
}
    
void SeqCollection::AddLast(ObjPtr op)
{
    ObjPtr last = Last();
    if (last)
	InsertAfter(last,op);
    else
	Add(op);
}

ObjPtr SeqCollection::RemoveFirst()
{
    ObjPtr first = First();
    return first ? Remove(first) : 0;
}
    
ObjPtr SeqCollection::RemoveLast()
{
    ObjPtr last = Last();
    return last ? Remove(last) : 0;
}

int SeqCollection::IndexOf(ObjPtr anOp)
{
    Iter next(this);
    register ObjPtr op;
    register int s;
    
    for (s = 0; op = next(); ) {
	if (!op->IsDeleted()) {
	    if (op->IsEqual(anOp))
		break;
	    s++;
	}
    }
    return op == 0 ? -1 : s;
}    

int SeqCollection::IndexOfPtr(ObjPtr anOp)
{
    Iter next(this);
    register ObjPtr op;
    register int s;
    
    for (s = 0; op = next(); s) {
	if (!op->IsDeleted()) {
	    if (op == anOp)
		break;
	    s++;
	}
    }
    return op == 0 ? -1 : s;
} 

Iterator *SeqCollection::ReversedIterator()
{
    AbstractMethod("ReversedIterator");
    return 0;
}

