#include "String.h"
#include "Types.h"

int StuffChar(char *src, char *dst, int dstlen, char* specchars, char stuffchar)
{
    register char *p, *q, *end;

    end= dst+dstlen-1;

    for (p= src, q= dst; *p && q < end; ) {
	if (index(specchars, *p)) {
	    *q++= stuffchar;
	    if (q < end)
		*q++ = *p++;
	} else 
	    *q++ = *p++;
    }
    *q= '\0';

    if (*p != 0)
	return -1;
    return q-dst;
}


static int readchar(istream &i, byte end)
{
    byte c;
    int d, k, j;

    for (;;) {
	i.get(c);
	if (i.rdstate() != _good || c == end)
	    return -1;
	switch (c) {
	case '\\':
	    i.get(c);
	    switch (c) {
	    case 'n':
		return '\n';
	    case 'r':
		return '\r';
	    case 'b':
		return '\b';
	    case 'f':
		return '\f';
	    case 't':
		return '\t';
	    case 'v':
		return '\v';
	    case 'x':
		for (k= j= 0; j < 2 && k < 256; j++) {
		    i.get(c);
		    if (! isxdigit(c)) {
			i.putback(c);
			break;
		    }
		    if (isdigit(c))
			d= c - '0';
		    else if (islower(c))
			d= c - 'a' + 10;
		    else
			d= c - 'A' + 10;
		    k= k*16 + d;
		}
		return k;

	    case '0': case '1': case '2': case '3': case '4':
	    case '5': case '6': case '7':
		for (k= j= 0; j < 3 && k < 256; j++) {
		    k= k*8 + c - '0';
		    i.get(c);
		    if (c < '0' || c > '7')
			break;
		}
		i.putback(c);
		return k;

	    default:
		return c;
	    }
	    break;

	default:
	    if (isprint(c))
		return c;
	    break;
	}
    }
}

istream &ReadString(istream &i, byte **s, int *lp)
{
    int l, c;    
    byte cc, *p, *pp;

    i >> l >> cc;
    pp= p= NewChars(l);
    if (cc == '"')
	while ((c= readchar(i, '\"')) != -1)
	   *p++= (byte) c;
    *p= '\0';
    if (s)
	*s= pp;
    if (lp)
	*lp= l;
    return i;
}

char ReadChar(istream &i)
{
    int c;    
    char cc;

    i >> cc;
    if (cc == '\'')
	while ((c= readchar(i, '\'')) != -1)
	   cc= (unsigned char) c;
    return cc;
}

static int col;

void printchar(ostream &o, byte c)
{
    switch(c) {
    case '{':
    case '}':
	o.put('\\'); o.put('x'); PutHex(o, c); col+= 4;
	break;
    case '\n':
	o.put('\\'); o.put('n'); col+= 2;
	break;
    case '\r':
	o.put('\\'); o.put('r'); col+= 2;
	break;
    case '\t':
	o.put('\\'); o.put('t'); col+= 2;
	break;
    case '\v':
	o.put('\\'); o.put('v'); col+= 2;
	break;
    case '\f':
	o.put('\\'); o.put('f'); col+= 2;
	break;
    case '\b':
	o.put('\\'); o.put('b'); col+= 2;
	break;
    case '\"':
	o.put('\\'); o.put('\"'); col+= 2;
	break;
    case '\'':
	o.put('\\'); o.put('\''); col+= 2;
	break;
    case '\\':
	o.put('\\'); o.put('\\'); col+= 2;
	break;
    default:
	if (isascii(c) && isprint(c)) {
	    o.put(c); col++;
	} else {
	    o.put('\\'); o.put('x'); PutHex(o, c); col+= 4;
	}
    }
}

ostream &PrintString(ostream &o, byte *s, int l)
{
    if (l < 0)
	l= strlen(s)+1;
    o << l SP;
    o.put('\"');
    for (col= 0; l > 0; l--) {
	printchar(o, *s++);
	if (col >= 72) {
	    o.put('\n');
	    col= 0;
	}
    }
    o.put('\"');
    return o;
}

ostream &PrintChar(ostream &o, char c)
{
    o.put('\"');
    printchar(o, c);
    o.put('\"');
    return o;
}

byte GetHex(istream &s)
{
    char c;
    unsigned short val= 0;

    for (int i= 0; i<2;) {
	s.get(c);
	if (isxdigit(c)) {
	    if (isdigit(c))
		val= val*16 + c-'0';
	    else if (isupper(c))
		val= val*16 + c-'A'+10;
	    else 
		val= val*16 + c-'a'+10;
	    i++;
	}
    }
    return val;
}

static char *hexChars= "0123456789abcdef";

void PutHex(ostream &ofp, byte b, int *col)
{    
    ofp.put(hexChars[b/16]);
    ofp.put(hexChars[b%16]);
    if (col) {
	(*col)++;
	if (*col >= 40) {
	    ofp.put('\n');
	    *col= 0;
	}
    }
}

char *strsave(char *s, int l)
{
    if (s == 0 || l == 0)
	return 0;
    if (l < 0)
	l= strlen(s)+1;
    char *str= NewBytes(l);
    return strncpy(str, s, l);
}

char *strreplace(char **s, char *r, int l)
{
    if (s == 0)
	abort();
    if (r == 0 || l == 0)
	return *s;
    if (l < 0)
	l= strlen(r)+1;
    Expand(s, l);
    return strncpy(*s, r, l);
}

char *strfreplace(char **s, char *fmt, va_list ap)
{
    char buf[1000];

    if (s == 0)
	abort();
    if (fmt == 0)
	return *s;

    vsprintf(buf, fmt, ap);

    Expand(s, strlen(buf));
    return strcpy(*s, buf);
}

char *strprintf(char *fmt, ...)
{
    va_list ap;
    char buf[2000];

    va_start(ap, fmt);
    vsprintf(buf, fmt, ap);
    va_end(ap);
    return strsave(buf);
}

char* strvprintf(char* fmt, va_list ap)
{       
    char buf[2000];

    vsprintf(buf, fmt, ap);
    return strsave(buf);
}

bool strismember(char *item, ...)
{
    char *s;   
    va_list ap;
    bool found= FALSE;
    va_start(ap, item);
    for (int i= 0; s= va_arg(ap, char*); i++)  
	if (strcmp(item, s) == 0) {
	    found= TRUE;
	    break;
	}
    va_end(ap);
    return found;
}

char* strn0cpy(char *dst, const char *src, int l)
{
    strncpy(dst, src, l-1);
    dst[l-1]= '\0';
    return dst;
}

char *strquotechar(byte ch, char *q)
{
    switch(ch) {
    case '\n':
	*q++='\\'; *q++='n'; 
	break;
    case '\r':
	*q++='\\'; *q++='r'; 
	break;
    case '\0':
	*q++='\\'; *q++='0'; 
	break;
    case '\t':
	*q++='\\'; *q++='t'; 
	break;
    case '\v':
	*q++='\\'; *q++='v'; 
	break;
    case '\f':
	*q++='\\'; *q++='f'; 
	break;
    case '\b':
	*q++='\\'; *q++='b'; 
	break;
    default:
	if (isascii(ch) && isprint(ch)) {
	    *q++= ch;
	} else {
	    *q++= '\\'; *q++= 'x'; *q++= hexChars[ch/16]; *q++= hexChars[ch%16]; 
	}
    }
    return q;
}
