#ifndef String_First
#define String_First

#include <stream.h>
#include <ctype.h>
#include <stdarg.h>

#include "Storage.h"

// standard string operations
extern char* strcat(char*, const char*);
extern char* strncat(char*, const char*, int);
extern int strcmp(const char*, const char*);
extern int strncmp(const char*, const char*, int);
extern char* strcpy(char*, const char*);
extern char* strncpy(char*, const char*, int);
extern int strlen(const char*);
extern char* index(char*, int);
extern char* rindex(char*, int);

extern void bcopy(byte*, byte*, int);
extern void bzero(byte*, int);
extern int bcmp(byte*, byte*, int);

// string utilites
extern char* strsave(char *s, int l= -1); 
    // allocate a buffer and copy 's'
extern char* strprintf(char *fmt, ...);   
    // allocate a buffer and copy the string specified in fmt a la printf
								    
extern char* strvprintf(char*, va_list);
extern char* strreplace(char**dst, char*src, int l= -1);
    // replace dst with src, expanding dst if necessary  
extern char* strfreplace(char**, char *fmt, va_list);
extern bool  strismember(char *s, ...);
    // return TRUE when s equals one of the following arguments
extern char *strquotechar(byte ch, char *bufp);
extern char* strn0cpy(char*, const char*, int);
    // strncpy which establises always a terminating 0 byte

// bsd byte string operations
extern void bcopy(byte*, byte*, int);
extern void bzero(byte*, int);
extern int bcmp(byte*, byte*, int);

// utilites to store strings in ET++ format
extern istream &ReadString(istream &i, byte **s, int *lp= 0);
extern ostream &PrintString(ostream &o, byte *s, int l= -1);
extern void PutHex(ostream &ofp, byte b, int *col= 0);
extern byte GetHex(istream &ofp);
extern int StuffChar(char *src, char *dst, int dstlen, char* specchars, char stuffchar);

// extened ctype macros working with 8 bit characters

inline Isalpha(byte c) 
    { return isascii(c) && isalpha(c); }
inline Isupper(byte c)
    {  return isascii(c) && isupper(c); }
inline Islower(byte c)
    {  return isascii(c) && islower(c); }
inline Isdigit(byte c)
    {  return isascii(c) && isdigit(c); }
inline Isxdigit(byte c)
    {  return isascii(c) && isxdigit(c); }
inline Isspace(byte c)
    {  return isascii(c) && isspace(c); }
inline Ispunct(byte c)
    {  return isascii(c) && ispunct(c); }
inline Isalnum(byte c)
    {  return isascii(c) && isalnum(c); }
inline Isprint(byte c)
    {  return isascii(c) && isprint(c); }
inline Isgraph(byte c)
    {  return isascii(c) && isgraph(c); }
inline Iscntrl(byte c)
    {  return isascii(c) && iscntrl(c); }
inline Isinword(byte c)
    {  return isdigit(c) || islower(c) || isupper(c) || (c == '_'); }

#endif String_First

