#ifndef TreeView_First
#define TreeView_First

#include "Dialog.h"
#include "DialogItems.h"

enum TreeLayout {
    eTLIndented,
    eTLTopDown,
    eTLLeftRight
};

enum TreeConnection {
    eTCNone,
    eTCDiagonal,
    eTCPerpendicular,
    eTCDiagonal2
};

//---- TreeView ----------------------------------------------------------------

class TreeView: public DialogView {
public:
    Point gap;
    TreeLayout layout;
    TreeConnection connType;
    class TreeNode *tree, *oldtree;
public:
    MetaDef(TreeView);

    TreeView(EvtHandler*, TreeLayout lt= eTLLeftRight, 
				    TreeConnection ct= eTCPerpendicular);

    VObject *DoCreateDialog();
    void SetTree(TreeNode*, bool freeold= TRUE);
    void Promote(TreeNode*);

    VObject *FindNode(VObject *);
    TreeNode *GetTree()
	{ return tree; }

    //---- layout
    void SetLayout(TreeLayout);
    void SetConnType(TreeConnection);

    //---- event handling
    virtual Command *NodeSelected(VObject*, int cl);

    //---- input/output
    ostream &PrintOn(ostream&);
    istream &ReadFrom(istream&);
    void Export(ostream&);
};

//---- TreeNode ------------------------------------------------------------------

enum TreeNodeFlags {
    eTreeNodeCollapsed  =   BIT(eDiaNodeLast+1),
    eTreeNodeDefault    =   eVObjEnabled,
    eTreeNodeLast       =   eDiaNodeLast+1
};

class TreeNode: public CompositeVObject {
    TreeView *treeview;
public:
    MetaDef(TreeNode);

    TreeNode(int id= -1, Collection *cp= 0);
    TreeNode(int id, VObject*, ...);
    TreeNode(int id, va_list ap);

    void SetView(View *vp);
    TreeView *GetTreeView()
	{ return treeview; }
    bool Collapsed()
	{ return TestFlag(eTreeNodeCollapsed); }
    TreeConnection ConnType()
	{ return treeview->connType; }
    TreeLayout Layout()
	{ return treeview->layout; }
    Point Gap()
	{ return treeview->gap; }
    VObject *Detect(BoolFun f, void *arg);
    VObject *FindExpandedItem(VObject*);

    //---- layout
    void SetOrigin(Point at);
    Metric GetMinSize();
    int Base();

    //---- drawing
    void Draw(Rectangle);
    void DrawConnections();
    void Outline2(Point, Point);
    void Highlight(HighlightState hst);
    GrCursor GetCursor(Point lp);

    //---- event handling
    Command *DispatchEvents(Point, Token, Clipper*);
    Command *DoMiddleButtonDownCommand(Point lp, Token t, int cl);
    Command *DoLeftButtonDownCommand(Point lp, Token t, int cl);

    //---- input/output
    void Export(ostream &s, int level);
};

//---- TreeNodeSelector -------------------------------------------------------------

class TreeNodeSelector: public Command {
    TreeNode *item;
    bool inside, lastinside;
    int clicks;
public:
    TreeNodeSelector(TreeNode *s, int cl);
    void TrackFeedback(Point, Point, bool);
    Command *TrackMouse(TrackPhase, Point, Point, Point);
};

#endif TreeView_First

