#ifndef Types_First
#define Types_First

#include <stream.h>
#include <stdarg.h>

#define _NAME1_(name) name
#define _NAME2_(name1,name2) _NAME1_(name1)name2
#define _NAME3_(name1,name2,name3) _NAME2_(name1,name2)name3

#define SP << " "
#define NL << "\n"

typedef unsigned char byte;
typedef unsigned char bool;
#define FALSE 0
#define TRUE 1

// standard CC drivers do not define __COMPILEDIR__

#ifndef __COMPILEDIR__              
#   define __COMPILEDIR__ ""
#endif 

#define BIT(n) (1 << (n))

inline int SETBIT(int &n, int i)
{
    return n|= BIT(i);
}

inline int CLRBIT(int &n, int i)
{
    return n&= ~BIT(i);
}

inline bool TESTBIT(int n, int i)
{
    return (n & BIT(i)) != 0;
}

const int cMaxInt      =   2147483647;
const int cMaxShort    =   32767;

enum HighlightState { Off= FALSE, On= TRUE };
enum Direction { eHor= FALSE, eVert= TRUE };

struct booldummy {
    friend istream& operator>>(istream &s, struct booldummy *b);
};

#define Bool(x) ((struct booldummy*)(&x))

#define Enum(v) (*((int*)&v))
#define EVEN(i) (((i) & 1) == 0)
#define ODD(i)  ((i) & 1)

#define ONCE(uniquename, stmts) \
class uniquename {  \
public: \
    uniquename()   \
    { stmts } \
}; \
static uniquename uniquename; 

#define _ONENTRY(uniquename) \
class uniquename {  \
public: \
    uniquename();  \
}; \
static uniquename on_exit; \
uniquename::uniquename()

#define ONENTRY(name) _ONENTRY(_NAME2_(_OnEntry_,name))

#define _ONEXIT(uniquename) \
class uniquename {  \
public: \
    uniquename() {}  \
    ~uniquename();  \
}; \
static uniquename _on_exit; \
uniquename::~uniquename()

#define ONEXIT(name) _ONEXIT(_NAME2_(_OnExit_,name))

typedef void (*VoidFunc)(...);
typedef int (*IntFunc)(...);
typedef void* (*VoidPtrFunc)(...);

inline int abs(int a)
{
    return a < 0 ? -a : a;
}

inline int sign(int x)
{
    return x ? ((x < 0) ? -1 : 1) : 0;
}

inline int min(int a, int b)
{
    return a <= b ? a : b;
}

inline int max(int a, int b)
{
    return a >= b ? a : b;
}

overload swap;
    
inline void swap(int &a, int &b)
{
    int tmp;
    tmp= a; a= b; b= tmp;
}

inline void swap(class Object **a, class Object **b)
{
    class Object *tmp;
    tmp= *a; *a= *b; *b= tmp;
}

overload range;

inline int range(int lb, int ub, int x)
{
    return x < lb ? lb : (x > ub ? ub : x);
}

inline float range(float lb, float ub, float x)
{
    return x < lb ? lb : (x > ub ? ub : x);
}

#define SafeDelete(p) { if (p) delete p; p= 0; }


#endif Types_First
