#ifndef VObject_First
#define VObject_First

#include "EvtHandler.h"
#include "Command.h"
#include "Collection.h"
#include "CmdNo.h"

enum VObjFlags {
    eVObjEnabled    =   BIT(eEvtLast+1),
    eVObjOpen       =   BIT(eEvtLast+2),
    eVObjHFixed     =   BIT(eEvtLast+3),
    eVObjVFixed     =   BIT(eEvtLast+4),
    eVObjLayoutCntl =   BIT(eEvtLast+5),
    eVObjInpFocus   =   BIT(eEvtLast+6),
    eVObjDefault    =   eVObjEnabled,
    eVObjLast       =   eEvtLast + 7
};

enum VObjAlign {
    eVObjHLeft  = BIT(0),
    eVObjHCenter= BIT(1),
    eVObjHRight = BIT(2),
    eVObjHExpand= BIT(3),
    eVObjH      = eVObjHLeft|eVObjHCenter|eVObjHRight|eVObjHExpand, 
    eVObjVTop   = BIT(8),
    eVObjVBase  = BIT(9),
    eVObjVCenter= BIT(10),
    eVObjVBottom= BIT(11), 
    eVObjVExpand= BIT(12), 
    eVObjV      = eVObjVTop|eVObjVBase|eVObjVCenter|eVObjVBottom|eVObjVExpand 
};

extern bool gBatch;

class VObject : public EvtHandler {
    short frameId;
protected:
    VObject *container;
    class View *inView;

public:
    Rectangle contentRect;

protected:
    void Init(int, Rectangle, View*);

public:
    MetaDef(VObject);

    VObject(class EvtHandler *next, Rectangle r, int id= cIdNone);
    VObject(Rectangle r, int id= cIdNone);
    VObject(int id= cIdNone);

    //---- view --------------------------------
    virtual void SetView(View *vp);
    virtual View *GetView();
    class BlankWin *GetWindow();
    Point GetPortPoint(Point p);
    virtual Rectangle GetViewedRect();
    virtual void SetContainer(VObject*);
    EvtHandler *GetNextHandler();
    virtual VObject *GetContainer();
    virtual void AddToClipper(class Clipper*);
    virtual void RemoveFromClipper(class Clipper*);

    //---- acessing ----------------------------
    int GetId()
	{ return frameId; }
    void SetId(int id)
	{ frameId= id; }
    bool Enabled()
	{ return TestFlag(eVObjEnabled); }
    virtual void Enable(bool b= TRUE, bool redraw= TRUE);
    void Disable(bool redraw= TRUE)
	{ Enable(FALSE, redraw); }
    bool IsOpen()
	{ return TestFlag(eVObjOpen); }

    //---- sizes -------------------------------
    virtual Metric GetMinSize();
    int Width()
	{ return contentRect.extent.x; }
    int Height()
	{ return contentRect.extent.y; }
    virtual int Base();
    Point GetExtent()
	{ return contentRect.extent; }
    Point GetOrigin()
	{ return contentRect.origin; };
    Rectangle ContentRect()
	{ return contentRect; }

    void SetContentRect(Rectangle, bool);
    virtual void SetExtent(Point);
    virtual void SetOrigin(Point);
    void SetWidth(int w)
	{ SetExtent(Point(w,Height())); }
    void SetHeight(int h)
	{ SetExtent(Point(Width(),h)); }
    void Move(Point delta, bool redraw= TRUE);

    void CalcExtent();
    virtual void Open(bool mode= TRUE);
    void Close()
	{ Open(FALSE); }

    void Align(Point at, Metric m, VObjAlign a);
    virtual bool ContainsPoint(Point p);

    //---- drawing ----------------------------
    virtual void SetFocus(Rectangle, Point);
    void Focus(Rectangle r)
	{ SetFocus(r, gPoint0); }
    void Focus()
	{ SetFocus(GetViewedRect(), gPoint0); }

    void Print();
    virtual void DrawAll(Rectangle);
    virtual void DrawBackground(Rectangle);
    virtual void Draw(Rectangle);
    virtual void DrawForeground(Rectangle);
    virtual void Outline2(Point, Point);
    void Outline(Point delta);
	// alternative interface to Outline2
    void OutlineRect(Rectangle r);
	// alternative interface to Outline2
    void Feedback(Rectangle r, bool on, bool b);
    virtual void Highlight(HighlightState);
    virtual void InvalidateRect(Rectangle r);
    void ForceRedraw();
    virtual void UpdateEvent(bool batch= gBatch);
    virtual GrCursor GetCursor(Point p);

    virtual Command *Input(Point lp, Token t, Clipper *vf);
    Command *DispatchEvents(Point, Token, Clipper*);

    virtual VObject *Detect(BoolFun f, void *arg);
	// find first entry where f returns true
    VObject *FindItem(int);
    VObject *FindItem(Point);
    VObject *FindItem(VObject*);

    //---- input focus
    bool WantsInputFocus()
	{ return TestFlag(eVObjInpFocus); }
    virtual void StartInputFocus(bool b= TRUE);
    void EndInputFocus()
	{ StartInputFocus(FALSE); }
	
    virtual Command *GetMover();
    virtual Command *GetStretcher();
    Command *DoRightButtonDownCommand(Point, Token, int, class Clipper*);

    //---- generic methods --------------------
    char *AsString();
    int Compare (Object*);
    ostream& PrintOn (ostream&);
    istream& ReadFrom(istream&);
};

typedef VObject* VObjPtr;

//---- VObjectCommand ----------------------------------------------------------

class VObjectCommand: public Command {
protected:
    VObject *vop;
    Rectangle oldRect, lastRect, constrainRect, newRect;
    Point delta, grid;
    GrCursor newcursor, oldcursor;
    bool firstmove;
    int hysterese;

protected:
    VObjectCommand(VObject *g);
    void Init(VObject *g, Rectangle cr, Point gr, GrCursor cd, int hy);
    Command *TrackMouse(TrackPhase, Point, Point, Point);
    void TrackConstrain(Point, Point, Point*);    
    void TrackFeedback(Point, Point, bool);
    void DoIt();
    void UndoIt();
};

//---- VObjectMover ------------------------------------------------------------

class VObjectMover: public VObjectCommand {
protected:
    Point origin;

    void Init(VObject *g, Rectangle cr, Point gr, GrCursor, int hy);

public:
    VObjectMover(VObject*);
    VObjectMover(VObject*, Rectangle);
    VObjectMover(VObject*, Rectangle, Point, GrCursor cr= eCrsMoveHand, int hy= 2);

    Command *TrackMouse(TrackPhase, Point, Point, Point);
};

//---- VObjectStretcher --------------------------------------------------------

class VObjectStretcher: public VObjectCommand {
protected:
    Point minSize, p1, p2;
    int corner;

    void Init(VObject *g, Rectangle cr, Point gr, GrCursor, int hy, Point ms);

public:
    VObjectStretcher(VObject*);
    VObjectStretcher(VObject*, Rectangle);
    VObjectStretcher(VObject*, Rectangle, Point ms);
    VObjectStretcher(VObject*, Rectangle, Point ms, Point,
				      GrCursor cr= eCrsMoveStretch, int hy= 2);

    Command *TrackMouse(TrackPhase, Point, Point, Point);
    void TrackConstrain(Point, Point, Point*);
};

//---- TextItem ----------------------------------------------------------------

extern Point gBorder;

class TextItem : public VObject {
protected:
    char *text;
    FontPtr font;
    Point border;

public:
    MetaDef(TextItem);

    TextItem(char *t, FontPtr f= gSysFont, Point b= gBorder);
    TextItem(int id, char *t, FontPtr f= gSysFont, Point b= gBorder);
    ~TextItem();

    void SetString(char*, bool redraw= FALSE);
    void SetFString(bool redraw, char *fmt, ...);
    void SetBorder(Point b)
	{ border= b; }
    int Base();
    Metric GetMinSize();
    FontPtr GetFont()
	{ return font; }
    void Draw(Rectangle);
    char *AsString();
    ostream& PrintOn (ostream&);
    istream& ReadFrom(istream&);
    void InspectorId(char *buf, int bufSize);
};

//---- ImageItem ---------------------------------------------------------------

class ImageItem : public VObject {
protected:
    bool deleteBitmap;
    Bitmap *bmp;
public:
    MetaDef(ImageItem);

    ImageItem(Bitmap *b);
    ImageItem(short*, Point);
    ImageItem(int id, Bitmap *b);
    ~ImageItem();

    Metric GetMinSize();
    void Draw(Rectangle);
    ostream& PrintOn (ostream&);
    istream& ReadFrom(istream&);
};

//---- CompositeVObject --------------------------------------------------------------

enum CompositeVObjectFlags {
    eDiaNodeDefault  = eVObjDefault,
    eDiaNodeLast     = eVObjLast+0
};

class CompositeVObject: public VObject {
protected:
    bool modified;
    Collection *list;
public:
    MetaDef(CompositeVObject);

    CompositeVObject(int id= cIdNone, Collection *cp= 0);
    CompositeVObject(int id, VObject*, ...);
    CompositeVObject(int id, va_list ap);
    ~CompositeVObject();

    void FreeAll();
    void Open(bool mode= TRUE);
    void DoUpdate(Object*, void*);
    void SetModified()
	{ modified= TRUE; }
    Collection *GetList();
    Iterator *GetIterator();
    int Size();
    virtual void Add(VObject*);

    void Draw(Rectangle);
    void Outline2(Point, Point);
    Command *DispatchEvents(Point, Token, Clipper*);
    void Enable(bool b= TRUE, bool redraw= TRUE);
    void SetView(View *);
    void SetContainer(VObject*);
    void SetItems(VObject **);
    void SetItems(va_list ap);
    void SetOrigin(Point);
    void SetExtent(Point e);
    Metric GetMinSize();
    VObject *Detect(BoolFun, void *arg);
    VObject *At(int n)
	{ return (VObject*)list->At(n); }
    void DownControl(int, int, void*);
    ostream& PrintOn (ostream&s);
    istream& ReadFrom(istream &);
    void InspectorId(char *buf, int sz);
};

#include "Cluster.h"

#endif VObject_First
