#ifndef VObjectTextView_First
#define VObjectTextView_First

#include "TextView.h"

//---- VObjectTextView --------------------------------------------------------

class VObjectTextView: public TextView {
    VObject *inpFocus;
    void InvalidateVObjects(int from, int to);
public:
    MetaDef(VObjectTextView);

    VObjectTextView(class EvtHandler*, Rectangle r, class VObjectText *t,
	    eTextJust m= eLeft, eSpacing= eOne, bool wrap= TRUE,
	    TextViewFlags= eVObjDefault, Point border = gBorder, int id = -1);    
	    // contentRect.width/height can be set to cFit

    //---- overriden to update VObjects 
    void InvalidateRange(int from, int to);
    void SetOrigin(Point);
    void Control(int id, int part, void *val);
    Text *SetText(Text *newText);

    //---- distribute input events to VObjects
    Command *DispatchEvents(Point lp, Token, Clipper*);

    GrCursor GetCursor(Point);    
    istream& ReadFrom(istream &s);
};

//---- StretchWrapper ---------------------------------------------------------
//     a VObject installed in a StretchWrapper and inserted in a 
//     VObjectText can be resized interactively

class StretchWrapper: public CompositeVObject {
protected:
    Point interiorOffset, extentDiff, border;
    VObject *interior;
    bool inpFocus;
public:
    MetaDef(StretchWrapper);
    
    StretchWrapper(VObject *inner, Point border, int= cIdNone);
    VObject *GetInterior()
	{ return interior; }
    Point GetInteriorOffset()
	{ return interiorOffset; }
    void SetOrigin(Point at);
    void SetExtent(Point e);
    Metric GetMinSize();
    int Base();
    Command *DoLeftButtonDownCommand(Point, Token, int);
    Command *DoKeyCommand(int ch, Point lp, Token t);
    void Control(int id, int part, void *val);
    void DownControl(int id, int part, void *val);
    void StartInputFocus(bool s);
    GrCursor GetCursor(Point);
    ostream& PrintOn (ostream&s);
    istream& ReadFrom(istream &);
    void DrawForeground(Rectangle);
};

#endif VObjectTextView_First
