#ifndef WindowPort_First
#define WindowPort_First

#include "Port.h"

enum WinState {
    eWsHidden,    // window allocated but not in hierarchy
    eWsShown,     // window is inserted in window hierarchy
    eWsClosed     // window will be removed
};

class WindowPort: public Port {
protected:
public:
    /* cursor stuff */
    Token pushbacktoken;
    bool havepushbacktoken;
    bool done;
    bool block;
    bool overlay;
    GrCursor cursor;
    void *privdata, *privdata2;
    InpHandlerFun ihf;
    Rectangle windowRect;
    WinState state;
    Rectangle *invalRects;          // array of inval rects
    Rectangle invalBounds;
    int inval;                      // current number of invalidated rects
    
    //---- overridden ----------------------------------------------------
    void DevDestroy();
    void DevStrokeRect(GrPattern, GrMode, int, Rectangle*);
    void DevStrokeRRect(GrPattern, GrMode, int, Rectangle*, Point);
    void DevFillRRect(GrPattern, GrMode, Rectangle*, Point);
    void DevStrokeOval(GrPattern, GrMode, int, Rectangle*);
    void DevFillOval(GrPattern, GrMode, Rectangle*);
    void DevStrokeLine(GrPattern, GrMode, int, Rectangle*, GrLineCap, Point, Point);
    void DevStrokeWedge(GrPattern, GrMode, int, GrLineCap, Rectangle*, int, int);
    void DevFillWedge(GrPattern, GrMode, Rectangle*, int, int);
    void DevStrokePolygon(Rectangle *r, GrPattern, GrMode, Point*, int, GrPolyType t,
								int, GrLineCap);
    void DevFillPolygon(Rectangle *r, GrPattern, GrMode, Point*, int, GrPolyType t);
    //--------------------------------------------------------------------
    
    //---- device dependent stuff ----------------------------------------
    virtual void DevDestroy2();
    virtual void DevStrokeRect2(GrPattern, GrMode, int, Rectangle*);
    virtual void DevStrokeRRect2(GrPattern, GrMode, int, Rectangle*, Point);
    virtual void DevFillRRect2(GrPattern, GrMode, Rectangle*, Point);
    virtual void DevStrokeOval2(GrPattern, GrMode, int, Rectangle*);
    virtual void DevFillOval2(GrPattern, GrMode, Rectangle*);
    virtual void DevStrokeLine2(GrPattern, GrMode, int, Rectangle*, GrLineCap, Point, Point);
    virtual void DevStrokeWedge2(GrPattern, GrMode, int, GrLineCap, Rectangle*, int, int);
    virtual void DevFillWedge2(GrPattern, GrMode, Rectangle*, int, int);
    virtual void DevStrokePolygon2(Rectangle*, GrPattern, GrMode, Point*, int, GrPolyType, int, GrLineCap);
    virtual void DevFillPolygon2(Rectangle*, GrPattern, GrMode, Point*, int, GrPolyType);
    //--------------------------------------------------------------------

    //---- device dependent stuff ----------------------------------------
    virtual void DevFullscreen(bool);
    virtual void DevScrollRect(Rectangle, Point);
    virtual void DevHide();
    virtual void DevShow(WindowPort *father, Rectangle);
    virtual void DevHide1();
    virtual void DevShow1(WindowPort *father, Rectangle);
    virtual void DevGrab(bool);
    virtual void DevGetEvent(Token *t, int timeout, bool overread);    
    virtual void DevSetMousePos(Point);
    virtual void DevMoveMousePos(Point delta);
    virtual void DevBell(long d);
    virtual void DevTop(bool);
    virtual void DevSetCursor(GrCursor);
    virtual void DevSetRect(Rectangle*);
    //---- end of device dependent stuff ---------------------------------

    void Damage(EventFlags f, Rectangle *r);
    Point DrawArrow(GrPattern, GrMode, int, Point, Point);

    WindowPort();
    void Init(InpHandlerFun ih, void *p1, void *p2, bool ov, bool bl);

public:
    WindowPort(InpHandlerFun ihf, void *priv1, void *priv2, bool overlay, bool block);

    void Send(Token *t);
	
    //---- window management ---------------------------------------------
    void Top()
	// bring window to top of window stack
	{ DevTop(TRUE); }
    void Bottom()
	// bring window to bottom of window stack
	{ DevTop(FALSE); }
    void Hide();
	// remove a window temporary from the screen
    void Show(WindowPort *father, Rectangle);
	// reinsert a previously hidden window
    
    //---- size management -----------------------------------------------
    Rectangle GetRect();
    void SetRect(Rectangle *r);

    //---- scrolling -------------------------------------------------------
    void ScrollRect(Rectangle,  Point);
    void InvalidateRect(Rectangle r);

    //---- input handling ------------------------------------------------
    void GetEvent(Token *t, int timeout= -1, bool overread= TRUE);    
				    // read next event
	
    void PushEvent(Token t); 
	
    void Fullscreen(bool);
    void Grab(bool m)               // get all input events
	 { DevGrab(m); }

    void SetMousePos(Point p)       // set the mouse position in window
	{ DevSetMousePos(p); }      // relative coordinates
	
    void MoveMousePos(Point delta)  // move the mouse position
	{ DevMoveMousePos(delta); }
	
    void Bell(long d)               // ring the bell
	{ DevBell(d); }
       

    //---- cursor stuff --------------------------------------------------
    GrCursor GetCursor();
    GrCursor SetWaitCursor(unsigned int d= 400, GrCursor c= eCrsHourglass);
    GrCursor SetCursor(GrCursor);
};

#endif WindowPort_First
