#ifndef WindowSystem_First
#define WindowSystem_First

#include "System.h"

//---- WindowSystem ------------------------------------------------------------

class WindowSystem : public Root {
    char *wsName;
public:
    WindowSystem(char *name= "GENERIC");

    virtual ~WindowSystem();
    
    char *GetWsName()
	{ return wsName; }

    virtual bool Open();
    virtual void Init();
    virtual void MakeWindow(class WindowPort **wp, InpHandlerFun ihf, void *priv1,
					void *priv2, bool overlay, bool block);
    virtual FontManager *MakeFontManager(char*);
    virtual void MakeBitmap(Bitmap **bp, Point sz, short *data);
    virtual void MakeBitmap(Bitmap **bp, const char *name);
    virtual Rectangle GetScreenRect();
    virtual void graphicDelay(unsigned int);
    virtual class ClipBoard *MakeClipboard();
    virtual bool interrupted();
};

extern WindowSystem *gWindowSystem;
extern Rectangle     gScreenRect;
extern bool          gWinInit;

inline bool Interrupted()
    { return gWindowSystem->interrupted(); }

inline void GraphicDelay(unsigned int duration)
    { gWindowSystem->graphicDelay(duration); }

#endif WindowSystem_First
