//$XClipBoard$
#include "XClipBoard.h"
#include "XWindowSystem.h"
#include "X11.h"
#include "../membuf.h"
#include "../String.h"
#include "../Error.h"
#include "../View.h"

//---- XClipBoard ------------------------------------------------------------

XClipBoard::XClipBoard()
{
    incutbuffer0= FALSE;
}

XClipBoard::~XClipBoard()
{
}

void XClipBoard::ScratchChanged()
{
    XEvent ev;
	  
    // selection to cut buffer 0
    if (view) {
	membuf *mmb= new membuf;
	ostream oos(mmb);
	view->SelectionToClipboard(cClipAscii, oos);
	oos.flush();
	if (mmb->Buf() && mmb->size() > 0)
	    XStoreBytes(display, mmb->Buf(), mmb->size());
	// delete mmb;
    }
    
    type= cClipEt;
    incutbuffer0= FALSE;
    XChangeProperty(display, awin, XA_WM_NAME, XA_STRING, 8, PropModeAppend, "", 0);
    XWindowEvent(display, awin, PropertyChangeMask, ev);
    XSetSelectionOwner(display, XA_PRIMARY, awin, ((XPropertyEvent*)&ev)->time);
    if (XGetSelectionOwner(display, XA_PRIMARY) != awin)
	cerr << "can't get selection\n";
}

static XBool IsSelectionNotify(XDisplay*, XEvent &xe, char*)
{
    return (xe.type == SelectionNotify);
}

membuf *XClipBoard::MakeBuf()
{
    membuf *mb= 0;
    int nbytes;
    char *cut0;
    
    if (incutbuffer0) {
	cut0= XFetchBytes(display, nbytes);
	if (cut0) {
	    mb= new membuf(0);
	    mb->setbuf((char*)strsave((byte*)cut0, nbytes), nbytes);
	    mb->Setsize(nbytes);
	    mb->Reset();
	    XFree(cut0);
	}
	return mb;
    }
    XEvent ev;
    XSelectionEvent *se;
    XAtom actual_type_return;
    int actual_format_return;
    unsigned char *prop_return;
    unsigned long nitems_return, bytes_after_return;
    
    XConvertSelection(display, XA_PRIMARY, XA_STRING, XNone, awin, XCurrentTime);

    XIfEvent(display, ev, IsSelectionNotify, 0);
    se= (XSelectionEvent*) &ev;
    
    if (se->property == XNone) {
	cerr << "can't convert selection\n";
	return mb;
    }
    unsigned long len;
    mb= new membuf(0);
    
    XGetWindowProperty(display, awin, se->property, 0L, 0L, XFalse,
	    XAnyPropertyType, actual_type_return, actual_format_return,
		nitems_return, bytes_after_return, prop_return);
	    
    len= bytes_after_return;
    
    XGetWindowProperty(display, awin, se->property, 0L, (len-1)/4+1, XTrue,
	    XAnyPropertyType, actual_type_return, actual_format_return,
		nitems_return, bytes_after_return, prop_return);
    
    mb->setbuf((char*)strsave((byte*)prop_return, len+1), len+1);
    XFree(prop_return);
    mb->Setsize(len);
    mb->Reset();
    return mb;
}

static XBool IsPropertyDeleted(XDisplay*, XEvent &xe, char *vp)
{
    if (xe.type == PropertyNotify) {
	XPropertyEvent *pe= (XPropertyEvent*) &xe;
	if (pe->window == *((XWindow*)vp) && pe->atom == XA_PRIMARY
						&& pe->state == PropertyDelete)
	    return TRUE;
    }
    return FALSE;
}

void XClipBoard::SendClipBoard(void *se)
{
    XSelectionRequestEvent *sre= (XSelectionRequestEvent*)se;
    XSelectionEvent sev;
    XEvent ev;
    char *nm;
    
    sev.type= SelectionNotify;
    sev.display= sre->display;
    sev.selection= sre->selection;
    sev.target= sre->target;
    sev.time= sre->time;
    sev.property= sre->property;
    sev.requestor= sre->requestor;
      
    if (sev.target != XA_STRING) {
	nm= XGetAtomName(display, sev.target);
	Error("XClipBoard::SendClipBoard", "can't convert to %s", nm);
	XFree(nm);
    }
       
    if (sev.property == XNone) {
	sev.property= XA_PRIMARY;
	sev.target= XA_STRING;
    }
	
    XChangeProperty(display, sev.requestor, sev.property, sev.target, 8,
					PropModeReplace, mb->Buf(), mb->size());
      
    XSelectInput(display, sev.requestor, PropertyChangeMask);
    XSendEvent(display, sev.requestor, XFalse, 0, *((XEvent*)&sev));
    XIfEvent(display, ev, IsPropertyDeleted, (char*) &sev.requestor);
}

void XClipBoard::PropertyChanged(void *xe)
{
    XPropertyEvent *pe= (XPropertyEvent*) xe;
    
    if (pe->atom == XA_CUT_BUFFER0) {
	incutbuffer0= TRUE;
	type= cClipAscii;
	NotOwner();
    }
}

void XClipBoard::GiveUpSelection()
{
    incutbuffer0= FALSE;
    type= cClipEt;
    NotOwner();
}
