#ifndef XWindowSystem_First
#define XWindowSystem_First

#include "../WindowSystem.h"
#include "X11.h"

extern XDisplay *display;
extern XWindow rootwin, awin;
extern int screen;
extern XContext context;
extern int colors[];
extern class XClipBoard *xclip;

class XWindowSystem: public WindowSystem {
public:
    XWindowSystem();
    bool Open();
    void Close();
    void MakeWindow(WindowPort **wp, InpHandlerFun ihf, void *priv1, void *priv2,
				bool overlay, bool block);
    FontManager *MakeFontManager(char *name);
    void MakeBitmap(Bitmap **bp, Point sz, short *data);
    void MakeBitmap(Bitmap **bp, const char *name);
    Rectangle GetScreenRect();
    void graphicDelay(unsigned int);
    bool interrupted();
    ClipBoard *MakeClipboard();
};

extern WindowSystem *NewXWindowSystem();

#endif XWindowSystem_First
