//$membuf$

#include "membuf.h"
#include "Storage.h"

membuf::membuf(int size)
{
    size= min(size, BUFSIZE);
    setbuf((char*) Malloc(size), size);
    alloc = 1;
}

int membuf::overflow(int c)
{
    int newsize= Size()+cSizeInc;
    int oldpos= pptr-base;
    Realloc(&base, newsize);
    gptr= base;
    eptr= base+newsize;
    pptr= base+oldpos;
    
    if (c != EOF) 
	*pptr++ = c;

    return c & 0377;
}

void membuf::Reset()
{
    gptr= base;
}

char *membuf::Buf()
{
    return base;
}

int membuf::Size()
{
    return eptr-base;
}

int membuf::size()
{
    return pptr-base;
}

void membuf::Setsize(int s)
{
    pptr= base+s;
}
