(*
   ComplexServer.m3
   Example Sun RPC program.
   Marvin Theimer, Xerox PARC
   March, 1992

   $Id: ComplexServer.m3,v 1.3 1992/04/02 02:42:23 nichols Exp $
*)

(* Copyright (c) 1992 Xerox Corporation.  All rights reserved.

   Use and copying of this software and preparation of derivative works
   based upon this software are permitted.  Any distribution of this
   software or derivative works must comply with all applicable United
   States export control laws.  This software is made available AS IS, and
   Xerox Corporation makes no warranty about the software, its performance
   or its conformity to any specification. *)

MODULE Main;

IMPORT RPC, RPCSun, fortytwo, fourtwo, Ctypes, Thread, Time;
IMPORT Wr, Fmt;
FROM Stdio IMPORT stdout, stderr;

<* FATAL Wr.Failure, Thread.Alerted, RPCSun.Erred *>

TYPE
  FORTY_TWO_VERS_1 = fortytwo.FORTY_TWO_VERS_1 OBJECT
                     OVERRIDES
                       GET_ANSWER       := get_answer;
                       GET_TRUE_ANSWER  := get_true_answer;
                       GET_BOGUS_ANSWER := get_bogus_answer;
                       DONT_ANSWER      := dont_answer;
                     END;

  FORTY_TWO_VERS_2 = fortytwo.FORTY_TWO_VERS_2 OBJECT
                     OVERRIDES
                       GET_THE_ANSWER := get_the_answer;
                     END;

  TEST_TYPES_3 =
    fortytwo.TEST_TYPES_3 OBJECT OVERRIDES DO_TEST := do_test; END;


PROCEDURE get_answer (<*UNUSED*> o            : fortytwo.FORTY_TWO_VERS_1;
                                 theQuestion  : TEXT;
                                 aRandomNumber: Ctypes.unsigned_short;
                      anotherQuestion: REF ARRAY OF CHAR):
  fourtwo.answerRec RAISES {RPC.Failed} =
  VAR ar: fourtwo.answerRec;
  BEGIN
    Wr.PutText(stdout, "***get_answer***\n");

    Wr.PutText(stdout, Fmt.F("theQuestion: %s\n", theQuestion));
    Wr.PutText(
      stdout, Fmt.F("aRandomNumber: %s\n", Fmt.Int(aRandomNumber)));
    Wr.PutText(stdout, Fmt.F("anotherQuestion: (%s) ",
                             Fmt.Int(NUMBER(anotherQuestion^))));
    FOR i := 0 TO 3 DO
      Wr.PutText(stdout, Fmt.F("%s", Fmt.Char(anotherQuestion^[i])));
    END;
    Wr.PutText(stdout, "\n");
    Wr.Flush(stdout);

    ar.theAnswer := 42;
    ar.aDifferentAnswer := "43";
    ar.anotherAnswer := NEW(REF ARRAY OF CHAR, 4);
    ar.anotherAnswer^[0] := '4';
    ar.anotherAnswer^[1] := '4';
    ar.anotherAnswer^[2] := '4';
    ar.anotherAnswer^[3] := '\000';
    ar.anotherDifferentAnswer := NEW(REF INTEGER);
    ar.anotherDifferentAnswer^ := 44;
    RETURN ar;
  END get_answer;

PROCEDURE get_true_answer (<*UNUSED*> o: fortytwo.FORTY_TWO_VERS_1;
                           questionType : fortytwo.QuestionType;
                           randomNumbers: REF ARRAY OF INTEGER;  ):
  fortytwo.trueAnswerRec RAISES {RPC.Failed} =
  VAR
    tar: fortytwo.trueAnswerRec;
    t  : fortytwo.TheANSWER_cosmic := NEW(fortytwo.TheANSWER_cosmic);
  BEGIN
    Wr.PutText(stdout, "***get_true_answer***\n");

    Wr.PutText(stdout, Fmt.F("questionType: %s\n", Fmt.Int(questionType)));
    Wr.PutText(stdout, Fmt.F("randomNumbers: (%s) {%s}\n",
                             Fmt.Int(NUMBER(randomNumbers^)),
                             Fmt.Int(randomNumbers^[0])));
    Wr.Flush(stdout);

    tar.tellingTheTruth := TRUE;
    tar.theTruth[0] := 13;
    tar.theTruth[1] := 42;
    tar.theTruth[2] := 137;
    tar.theTRUTH := t;
    t.truthType := fortytwo.QuestionType_cosmic;
    t.c := 1024;
    RETURN tar;
  END get_true_answer;

PROCEDURE get_bogus_answer (<*UNUSED*> o: fortytwo.FORTY_TWO_VERS_1):
  INTEGER RAISES {RPC.Failed} =
  BEGIN
    Wr.PutText(stdout, "***get_bogus_answer***\n");
    Wr.Flush(stdout);
    RETURN 10;
  END get_bogus_answer;

PROCEDURE dont_answer (<*UNUSED*> o     : fortytwo.FORTY_TWO_VERS_1;
                                  inParm: INTEGER                    )
  RAISES {RPC.Failed} =
  BEGIN
    Wr.PutText(stdout, "***dont_answer***\n");

    Wr.PutText(stdout, Fmt.F("inParm: %s\n", Fmt.Int(inParm)));
    Wr.Flush(stdout);
  END dont_answer;

PROCEDURE get_the_answer (<*UNUSED*> o: fortytwo.FORTY_TWO_VERS_2;
                          questionType : fortytwo.QuestionType;
                          randomNumbers: REF ARRAY OF INTEGER;  ):
  fortytwo.AnswerRec RAISES {RPC.Failed} =
  VAR
    Ar: fortytwo.AnswerRec;
    t : fortytwo.TheANSWER_Default := NEW(fortytwo.TheANSWER_Default);
  BEGIN
    Wr.PutText(stdout, "***get_the_answer***\n");

    Wr.PutText(stdout, Fmt.F("questionType: %s\n", Fmt.Int(questionType)));
    Wr.PutText(stdout, Fmt.F("randomNumbers: (%s) {%s, %s}\n",
                             Fmt.Int(NUMBER(randomNumbers^)),
                             Fmt.Int(randomNumbers^[0]),
                             Fmt.Int(randomNumbers^[1])));
    Wr.Flush(stdout);

    Ar.tellingTheTruth := FALSE;
    Ar.theTruth[0] := -1;
    Ar.theTruth[1] := -2;
    Ar.theTruth[2] := -42;
    Ar.theTRUTH := t;
    t.truthType := fortytwo.QuestionType_silly;
    t.d := NEW(REF fourtwo.answerRec);
    t.d.theAnswer := 137;
    t.d.aDifferentAnswer := "1/137";
    t.d.anotherAnswer := NEW(REF ARRAY OF CHAR, 4);
    t.d.anotherAnswer^[0] := '6';
    t.d.anotherAnswer^[1] := '6';
    t.d.anotherAnswer^[2] := '6';
    t.d.anotherAnswer^[3] := '\000';
    t.d.anotherDifferentAnswer := NEW(REF INTEGER);
    t.d.anotherDifferentAnswer^ := 99;
    RETURN Ar;
  END get_the_answer;

PROCEDURE do_test (<*UNUSED*> o: fortytwo.TEST_TYPES_3;
                              a: REAL;
                              b: LONGREAL;
                              c: CHAR;
                              d: Ctypes.short;
                              e: INTEGER;
                              f: INTEGER;
                              g: Ctypes.unsigned_char;
                              h: Ctypes.unsigned_short;
                              i: Ctypes.unsigned_int;
                              j: Ctypes.unsigned_int;
                              k: REF ARRAY OF fortytwo.tuple;
                              l: ARRAY [0 .. 2] OF CHAR;
                              m: REF ARRAY OF Ctypes.unsigned_char; ):
  fortytwo.randomTypes RAISES {RPC.Failed} =
  VAR rta: fortytwo.randomTypes;
  BEGIN
    Wr.PutText(stdout, "***do_test***\n");

    Wr.PutText(stdout, Fmt.F("a: %s\n", Fmt.Real(a)));
    Wr.PutText(stdout, Fmt.F("b: %s\n", Fmt.LongReal(b)));
    Wr.PutText(stdout, Fmt.F("c: %s\n", Fmt.Char(c)));
    Wr.PutText(stdout, Fmt.F("d: %s\n", Fmt.Int(d)));
    Wr.PutText(stdout, Fmt.F("e: %s\n", Fmt.Int(e)));
    Wr.PutText(stdout, Fmt.F("f: %s\n", Fmt.Int(f)));
    Wr.PutText(stdout, Fmt.F("g: %s\n", Fmt.Int(g)));
    Wr.PutText(stdout, Fmt.F("h: %s\n", Fmt.Int(h)));
    Wr.PutText(stdout, Fmt.F("i: %s\n", Fmt.Int(i)));
    Wr.PutText(stdout, Fmt.F("j: %s\n", Fmt.Int(j)));
    Wr.PutText(
      stdout, Fmt.F("k: (%s) {(%s, %s), (%s, %s)}\n", Fmt.Int(NUMBER(k^)),
                    Fmt.Int(k^[0].x), Fmt.Int(k^[0].y), Fmt.Int(k^[1].x),
                    Fmt.Int(k^[1].y)));
    Wr.PutText(stdout, Fmt.F("l: {%s%s%s}\n", Fmt.Char(l[0]),
                             Fmt.Char(l[1]), Fmt.Char(l[2])));
    Wr.PutText(stdout, Fmt.F("m: (%s) {%s, %s}\n", Fmt.Int(NUMBER(m^)),
                             Fmt.Int(m^[0]), Fmt.Int(m^[1])));
    Wr.Flush(stdout);

    rta.a := 6.2832;
    rta.b := 8.535390D0;
    rta.c := 'd';
    rta.d := 14;
    rta.e := 43;
    rta.f := 138;
    rta.g := 130;
    rta.h := 15;
    rta.i := 44;
    rta.j := 139;
    rta.k := NEW(REF ARRAY OF fortytwo.tuple, 2);
    rta.k^[0].x := -2;
    rta.k^[0].y := -2;
    rta.k^[1].x := 2;
    rta.k^[1].y := 2;
    rta.l[0] := 'd';
    rta.l[1] := 'o';
    rta.l[2] := 'g';
    rta.m := NEW(REF ARRAY OF Ctypes.unsigned_char, 2);
    rta.m^[0] := 83;
    rta.m^[1] := 84;

    RETURN rta;

  END do_test;

BEGIN
  TRY
    Wr.PutText(stdout, "Start of fortytwoServer\n");
    Wr.Flush(stdout);

    EVAL RPCSun.Export(
           fortytwo.GetFORTY_TWO_VERS_1ServerProc(NEW(FORTY_TWO_VERS_1)),
           fortytwo.FORTY_TWO_PROG_prognum,
           fortytwo.FORTY_TWO_VERS_1_versnum, RPCSun.Protocol.UDP);
    Wr.PutText(stdout, "Exported fortytwo, version 1 via UDP.\n");
    EVAL RPCSun.Export(
           fortytwo.GetFORTY_TWO_VERS_1ServerProc(NEW(FORTY_TWO_VERS_1)),
           fortytwo.FORTY_TWO_PROG_prognum,
           fortytwo.FORTY_TWO_VERS_1_versnum, RPCSun.Protocol.TCP);
    Wr.PutText(stdout, "Exported fortytwo, version 1 via TCP.\n");
    EVAL RPCSun.Export(
           fortytwo.GetFORTY_TWO_VERS_2ServerProc(NEW(FORTY_TWO_VERS_2)),
           fortytwo.FORTY_TWO_PROG_prognum,
           fortytwo.FORTY_TWO_VERS_2_versnum, RPCSun.Protocol.UDP);
    Wr.PutText(stdout, "Exported fortytwo, version 2 via UDP.\n");
    EVAL RPCSun.Export(
           fortytwo.GetFORTY_TWO_VERS_2ServerProc(NEW(FORTY_TWO_VERS_2)),
           fortytwo.FORTY_TWO_PROG_prognum,
           fortytwo.FORTY_TWO_VERS_2_versnum, RPCSun.Protocol.TCP);
    Wr.PutText(stdout, "Exported fortytwo, version 2 via TCP.\n");
    EVAL
      RPCSun.Export(fortytwo.GetTEST_TYPES_3ServerProc(NEW(TEST_TYPES_3)),
                    fortytwo.TEST_TYPES_PROG_prognum,
                    fortytwo.TEST_TYPES_3_versnum, RPCSun.Protocol.UDP);
    Wr.PutText(stdout, "Exported fortytwo, version 3 via UDP.\n");
    EVAL
      RPCSun.Export(fortytwo.GetTEST_TYPES_3ServerProc(NEW(TEST_TYPES_3)),
                    fortytwo.TEST_TYPES_PROG_prognum,
                    fortytwo.TEST_TYPES_3_versnum, RPCSun.Protocol.TCP);
    Wr.PutText(stdout, "Exported fortytwo, version 3 via TCP.\n");
    Wr.Flush(stdout);

    LOOP Time.LongPause(1000); END;
  EXCEPT
    RPC.Failed (e) => Wr.PutText(stderr, "RPC failure: " & e.info & "\n");
  END;

END Main.
