(*
   SimpleClient.m3
   Example Sun RPC program.
   Marvin Theimer, Xerox PARC
   March, 1992

   $Id: SimpleClient.m3,v 1.3 1992/05/20 22:36:49 nichols Exp $
*)

(* Copyright (c) 1992 Xerox Corporation.  All rights reserved.

   Use and copying of this software and preparation of derivative works
   based upon this software are permitted.  Any distribution of this
   software or derivative works must comply with all applicable United
   States export control laws.  This software is made available AS IS, and
   Xerox Corporation makes no warranty about the software, its performance
   or its conformity to any specification. *)

MODULE Main;

(*
 * SimpleClient:
 *   Used with stub files generated from
 *       m3rpcgen [-f] simple.x
 *)

IMPORT RPC, RPCSun, simple, Thread;

IMPORT ParseParams, Scan, Wr, Fmt;
FROM Stdio IMPORT stdout, stderr;

<* FATAL Wr.Failure, Thread.Alerted *>

VAR
  b : RPCSun.BindingInfo;
  cl: simple.Vers_1;

  HostName: TEXT := "localhost";

  m: INTEGER := 42;
  n: INTEGER;

VAR progNum := simple.Simple_prognum;
BEGIN
  TRY
    Wr.PutText(stdout, "Start of SimpleClient\n");

    ParseParams.BeginParsing(stderr);
    IF ParseParams.KeywordPresent("-h") THEN
      HostName := ParseParams.GetNext();
    END;
    IF ParseParams.KeywordPresent("-t") THEN
      progNum := ParseParams.GetNextInt();
    END;
    ParseParams.EndParsing();

    b := RPCSun.CreateBindingInfo(
           RPCSun.LookupHost(HostName), progNum, simple.Vers_1_versnum, 0,
           RPCSun.Protocol.UDP);
    cl := simple.ImportVers_1(b);

    n := cl.Incr(m);
    Wr.PutText(stdout, Fmt.F("Incr(%s) -> %s\n", Fmt.Int(m), Fmt.Int(n)));

    Wr.PutText(stdout, "End of SimpleClient\n");

  EXCEPT
    Scan.BadFormat => Wr.PutText(stderr, "Usage: SimpleClient -h host\n");
  | RPC.Failed (e) => Wr.PutText(stderr, "RPC failure: " & e.info & "\n");
  END;
END Main.
