/*
   fortytwo.x
   Example Sun RPC interface.
   Marvin Theimer, Xerox PARC
   March, 1992

   $Id: fortytwo.x,v 1.2 1992/04/01 02:15:53 nichols Exp $
*/

/* Copyright (c) 1992 Xerox Corporation.  All rights reserved.

   Use and copying of this software and preparation of derivative works
   based upon this software are permitted.  Any distribution of this
   software or derivative works must comply with all applicable United
   States export control laws.  This software is made available AS IS, and
   Xerox Corporation makes no warranty about the software, its performance
   or its conformity to any specification. */

/*
 * fortytwo RPC server.
 */

#if RPC_HDR
%#ifndef fourtwo_h
%#define fourtwo_h
%#include "fourtwo.h"
%#endif fourtwo_h
%#ifndef fortyone_h
%#define fortyone_h
%#include "fortyone.h"
%#endif fortyone_h
#endif RPC_HDR

#if RPC_HDR
%#define ServiceName "fortytwo"
#endif rpc_HDR

enum QuestionType {
    boring = 123,
    cosmic = 456,
    universal,
    stupid = 789,
    silly
};

enum Question1Type {
    boooring,
    cooosmic,
    univeeersal,
    stuuupid,
    sillly
};

typedef struct answerRec answerRecType;

union TheANSWER switch (QuestionType truthType) {
  case boring:
    opaque b[13];
  case cosmic:
    int c;
  case stupid:
    void;
  default:
    struct answerRec *d;
};

union YetAnotherAnswer switch (int responseType) {
  case 0:
    enum QuestionType answer;
  case 1:
    int a;
  default:
    void;
};


struct trueAnswerRec {
    bool tellingTheTruth;
    int theTruth[TRUTH_SIZE];
    TheANSWER theTRUTH;
};

struct trueQuestionRec {
    QuestionType questionType;
    int randomNumbers<>;
};

typedef trueQuestionRec QuestionRec;
typedef trueAnswerRec AnswerRec;

typedef QuestionRec *QuestionRecPtr;
typedef QuestionRec QuestionRecArray<>;
typedef QuestionRec QuestionRecArray1[13];

struct tuple {
    int x;
    int y;
};

struct randomTypes {
    float a;
    double b;
    char c;
    short d;
    int e;
    long f;
    unsigned char g;
    unsigned short h;
    unsigned int i;
    unsigned long j;
    tuple k<>;
    opaque l[3];
    unsigned char m<13>;
};

typedef int FooBar;

program FORTY_TWO_PROG {
    version FORTY_TWO_VERS_1 {
	answerRec GET_ANSWER(questionRec) = 1;
	trueAnswerRec GET_TRUE_ANSWER(trueQuestionRec) = 2;
	int GET_BOGUS_ANSWER(void) = 3;
	void DONT_ANSWER(int) = 4;
    } = 1;
    version FORTY_TWO_VERS_2 {
	AnswerRec GET_THE_ANSWER(QuestionRec) = 1;
    } = 2;
} = 0x20000000;

program TEST_TYPES_PROG {
    version TEST_TYPES_3 {
        randomTypes DO_TEST(randomTypes) = 13;
    } = 3;
} = 40400001;
