        PROGRAM MAIN
C       PROBLEM 16 OF PURDUE PROBLEMS
C       PAGE 152 OF NUMERICAL METHODS, SOFTWARE AND ANALYSIS
C       TEST SOLVONG HILBERT MATRIX PROBLEM: 5 SIZES ANY 4 RIGHT SIDES
        PARAMETER (NDIM=50,KASES=1)
	DOUBLE PRECISION HILBERT,HILB,X,B,RESID,WORK,HDPROD,DOTPROD,XTEMP
	INTEGER I,J,IPVT

	DIMENSION HILBERT(NDIM,NDIM),HILB(NDIM,NDIM),X(NDIM)
	DIMENSION B(NDIM),WORK(NDIM),RESID(KASES),IPVT(NDIM)
	DIMENSION XTEMP(NDIM)

	DO 10 I=1,NDIM
	   DO 10 J=1,NDIM
	      HILBERT(I,J)=1.0/(I+J-1.0)
10      CONTINUE
	
	DO 30 I=1,NDIM
	      B(I)=1.0+.01*DSIN(DFLOAT(100*I))
30         CONTINUE

           call time1

	   DO 50 I=1,NDIM
	       X(I)=B(I)
	       DO 40 J =1,NDIM
		 HILB(I,J)=HILBERT(I,J)
40         CONTINUE
50         CONTINUE

C  USE LINPACK AS FORTRAN 66 ROUTINES
	   CALL SGECO(HILB,NDIM,NDIM,IPVT,RCOND,WORK)
           IF (RCOND .EQ. 0) THEN
               PRINT*,'*** THE CONDITION NUMBER IS TOO HIGH'
	       STOP
           ENDIF

	      DO 70 I=1,NDIM
		 XTEMP(I)=X(I)
70            CONTINUE
	      CALL SGESL(HILB,NDIM,NDIM,IPVT,XTEMP,0)
C  COMPUTE DOTPRODUCT FOR RESIDUE
	      DOTPROD=0.0
	      DO 80 I=1,NDIM
		 HPROD=0.0
		 DO 90 J=1,NDIM
		   HPROD=HPROD+HILBERT(I,J)*XTEMP(J)
90               CONTINUE
		 HDPROD=HPROD-B(I)
		 DOTPROD=DOTPROD+HDPROD*HDPROD
80            CONTINUE
	      RESID(1)=SQRT(DOTPROD)

	   call time2

              PRINT*,'PROBLEM 16 WITH N=', NDIM, '  RESIDUE=',RESID(1)

	  STOP
	  END
