#
# This is the configuration script for tknews.  It contains
# definitions for the default values of the configuration 
# paramters.  Environment variables and Resource options will
# override these values.
#

# This is the default organization to use if the user has not set
# the ORGANIZATION environment variable.

set Resources(ORGANIZATION) "The Ohio State University, CIS Department"

# This is the location of the news active file.  Only necessary if you
# are using the spool directory.

set Resources(NEWSACTIVEFILE) /usr/lib/news/active

# This is the location of the spool directory.  This is only necessary
# if you are not using an nntp server.

set Resources(SPOOLDIR) /usr/spool/news

# This is the name of a program to use for posting news.   It should
# be set to "nntp" if you wish to use the NNTPPOST server for
# posting news.

set Resources(POSTINGPROG) "/usr/lib/news/inews -h"

# This is the name of the NNTP server.  Defining this means you are
# reading news through the server, although you may still be posting
# news using the POSTINGPROG variable (if set)

###set Resources(NNTPSERVER) "localhost"

# This indicates an alternate port to use for connecting to the
# nntp server.  If this is not defined, then the standard nntp
# port is used.

###set Resources(NNTPPORT) 2222

# Define this variable if you want to use the nntp server for posting.
# It should normally be defined as the same nntp server you are using
# for reading news.  Note that the POSTINGPROG should be set to
# "nntp" if you use this resource.

###set Resources(NNTPPOST) "apatosaur.cis.ohio-state.edu"

# This variable indicates the default location of the user's newsrc
# file.  Under most circumstances, leave this set to ~/.newsrc.

set Resources(NEWSRCFILE) "~/.newsrc"

# This is the default editor command to use.
	
set Resources(EDITOR_COMMAND) "emacs"

# This is the default location for the user's tknewsrc file.

set Resources(TKNEWSRC) "~/.tknewsrc"

# This is the number of articles to prefetch when searching...

set Resources(PREFETCH) 10
