# urlsave.tcl --

#
# Snarf up all the html documents referenced by a page, as long as they
# are on the same server
proc Url_Save {win} {
    upvar #0 HM$win var

    set base $var(S_url)

    Log $win Url_Save
    # Get the html and look for URLs in it.
    if [catch {Output_string $win sel.first sel.last} html] {
	DialogInfo $win "Make a selection that includes links to the documents you want to download"
	return
    }
    set state(urls) {}
    HMparse_html $html [list UrlScan $win state] {}

    foreach href $state(urls) {
	set protocol [UrlResolve $base href]	;# Side-effects href
    
	switch -regexp -- $protocol {
	    (http|ftp) {
		# Should use the cache
		Status $win "fetching image $href"
		Http_get $href [list UrlSave $win $href] \
				[list Url_Progress $win $href]
	    }
	    file {
		UrlSave $win $href
	    }
	}
    }
    return
}

proc UrlScan {win stateVar htag not param text} {
    upvar #0 HM$win var
    upvar 2 $stateVar state	;# Image_Save -> HMparse_html -> ImageScan
    if {[regexp -nocase ^a $htag] && [HMextract_param $param href] &&
	    [info exists href]} {
	regsub {#.+$} $href {} href
	UrlResolve $var(S_url) href
	if {[lsearch $state(urls) $href] < 0} {
	    lappend state(urls) $href
	}
    }
}

proc UrlSave {win href} {
    upvar #0 $href data
    global links
    if {![info exists links(dir)] ||
	![file isdirectory $links(dir)]} {
	Url_SaveDir $win
    }
    set path [glob -nocomplain $links(dir)]/[file tail $href]
    if {[regexp file:(.+)$ $href x file]} {
	if [catch {File_CopyBin $file $path} err] {
	    Status $win err
	} else {
	    Status $win "Saved $path"
	}
    } elseif {[info exists data(html)]} {
	if [catch {open $path w} out] {
	    Status $win out
	} else {
	    puts $out $data(html)
	    close $out
	    Status $win "Saved $path"
	}
    } elseif {[catch {exec mv -f $data(file) $path} err]} {
	Log $win UrlSave $href $err
	Status $win $err
    } else {
	Log $win UrlSave $href $path
	Status $win "Saved $path"
    }
}
proc Url_SaveDir {win} {
    upvar #0 HM$win var
    global links
    if ![info exists links(dir)] {
	set links(dir) ~/saved_html
    }
    DialogEntry $win .imagesave "Directory for saved documents" \
	    [list UrlSaveDir $win] \
	    [list [list "Save Dir:" $links(dir)]]
}
proc UrlSaveDir {win newdir} {
    global links
    set links(dir) $newdir
    if {[string length $links(dir)] && ![file exists $links(dir)]} {
	if [catch {
	    exec mkdir [glob [file dirname $links(dir)]]/[file tail $links(dir)]
	} err] {
	    Status $win $err
	}
    }
    Log $win "Url_SaveDir $links(dir)"
    Status $win "Url dir $links(dir)"
}


