# winhist.tcl --
# The URL history module
# Copyright (c) 1996 by Sun Microsystems
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

proc WinHistorySetup {win menu} {
    upvar #0 WinHist$win hist
    $menu add separator
    set hist(menu) $menu
    set hist(origin) [expr [$menu index last] + 1]
}
proc WinHistoryAdd {win title} {
    upvar #0 WinHist$win hist
    upvar #0 HM$win var
    global History
    if {![catch {set index [$hist(menu) index $title]}]} {
	 return;	# Don't reorder
    }
    if ![info exists hist(origin)] {
	# Not a full fledged browser window
	return;
    }
    set hist(back) $hist(origin)
    if {[$hist(menu) index last] < $hist(origin)} {
	$hist(menu) add command -label $title -command \
	    [list Url_Display $win $var(S_url)]
    } else {
	$hist(menu) insert $hist(origin) command -label $title -command \
	    [list Url_Display $win $var(S_url)]
    }
    set end [expr $hist(origin)+15]
    if {[set count [$hist(menu) index last]] >= $end} {
	    set cmd [$hist(menu) entryconfigure $count -command]
	    set url [lindex $cmd 2]
	    Http_kill $url	;# uncache the page
	    $hist(menu) delete $count
    }
    set History($var(S_url)) $title
}
proc WinHistoryBack {win} {
    upvar #0 WinHist$win hist
    set end [expr $hist(origin)+15]
    if ![info exists hist(back)] {
	set hist(back) $hist(origin)
    }
    incr hist(back)
    if {$hist(back) > $end} {
	Status $win "At end of history (15 deep)"
	set hist(back) $end
	return
    }
    $hist(menu) invoke $hist(back)
}
proc WinHistory_CheckPoint {out} {
    global History
    puts $out "array set History {"

    foreach url [lsort [array names History]] {
	puts $out "\t[list $url]\n\t[list $History($url)]\n"
    }

    puts $out "}"
}
proc WinHistoryView {win} {
    global History HistoryMap
    if ![winfo exists .history] {
	toplevel .history
	wm title .history "URL history"
	set f [frame .history.buttons -bd 4]
	button $f.quit -text Dismiss -command {wm withdraw .history}
	set v [button $f.view -text Open]

	entry .history.url -textvariable HistoryUrl
	pack $f .history.url -side top -fill x
	pack $f.quit -side right
	pack $f.view -side left
	set l [listbox .history.list -width 40 -height 20 \
		-yscrollcommand {.history.scroll set}]
	scrollbar .history.scroll -command {.history.list yview}
	pack .history.scroll -side right -fill y
	pack .history.list -side left -fill both -expand true
	bind $l <Button-1> [list WinHistoryFeedback .history.list @%x,%y]
    } else {
	wm deiconify .history
	raise .history
	set l .history.list
	set v .history.buttons.view
    }
    bind $l <Double-Button-1> [list WinHistoryOpen .history.list $win]
    $v config -command [list WinHistoryOpen .history.list $win]
    # Fill up a listbox and maintain a parallel map from listbox entry
    # back to the URL.  This is needed because a map from Title to URL
    # may be ambiguous

    $l delete 0 end
    catch {unset HistoryMap}
    set i 0
    foreach url [lsort [array names History]] {
	$l insert end $History($url)
	set HistoryMap($i) $url
	incr i
    }
}
proc WinHistoryOpen {list win} {
    global HistoryUrl HistoryMap
    set i [$list curselection]
    if {$i == ""} {
	return
    }
    set HistoryUrl $HistoryMap($i)
    wm withdraw .history
    Url_Display $win $HistoryUrl
}
proc WinHistoryFeedback {list index} {
    global HistoryUrl HistoryMap
    set i [$list index $index]
    set HistoryUrl $HistoryMap($i)
    .history.url xview moveto 1
}

