/*
 * tkDecls.h --
 *
 *	Declarations of functions in the platform independent public Tcl API.
 *
 * Copyright (c) 1998-1999 by Scriptics Corporation.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: @(#) $Id: tkDecls.h,v 1.2.2.1 1999/03/10 07:13:39 stanton Exp $
 */

#ifndef _TKDECLS
#define _TKDECLS

#ifdef BUILD_tk
#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLEXPORT
#endif

/*
 * WARNING: This file is automatically generated by the tools/genStubs.tcl
 * script.  Any modifications to the function declarations below should be made
 * in the generic/tk.decls script.
 */

/* !BEGIN!: Do not edit below this line. */

/*
 * Exported function declarations:
 */

/* 0 */
EXTERN void		Tk_MainLoop _ANSI_ARGS_((void));
/* 1 */
EXTERN XColor *		Tk_3DBorderColor _ANSI_ARGS_((Tk_3DBorder border));
/* 2 */
EXTERN GC		Tk_3DBorderGC _ANSI_ARGS_((Tk_Window tkwin, 
				Tk_3DBorder border, int which));
/* 3 */
EXTERN void		Tk_3DHorizontalBevel _ANSI_ARGS_((Tk_Window tkwin, 
				Drawable drawable, Tk_3DBorder border, int x, 
				int y, int width, int height, int leftIn, 
				int rightIn, int topBevel, int relief));
/* 4 */
EXTERN void		Tk_3DVerticalBevel _ANSI_ARGS_((Tk_Window tkwin, 
				Drawable drawable, Tk_3DBorder border, int x, 
				int y, int width, int height, int leftBevel, 
				int relief));
/* 5 */
EXTERN void		Tk_AddOption _ANSI_ARGS_((Tk_Window tkwin, 
				char * name, char * value, int priority));
/* 6 */
EXTERN void		Tk_BindEvent _ANSI_ARGS_((
				Tk_BindingTable bindingTable, 
				XEvent * eventPtr, Tk_Window tkwin, 
				int numObjects, ClientData * objectPtr));
/* 7 */
EXTERN void		Tk_CanvasDrawableCoords _ANSI_ARGS_((
				Tk_Canvas canvas, double x, double y, 
				short * drawableXPtr, short * drawableYPtr));
/* 8 */
EXTERN void		Tk_CanvasEventuallyRedraw _ANSI_ARGS_((
				Tk_Canvas canvas, int x1, int y1, int x2, 
				int y2));
/* 9 */
EXTERN int		Tk_CanvasGetCoord _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Canvas canvas, char * string, 
				double * doublePtr));
/* 10 */
EXTERN Tk_CanvasTextInfo * Tk_CanvasGetTextInfo _ANSI_ARGS_((
				Tk_Canvas canvas));
/* 11 */
EXTERN int		Tk_CanvasPsBitmap _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Canvas canvas, Pixmap bitmap, int x, 
				int y, int width, int height));
/* 12 */
EXTERN int		Tk_CanvasPsColor _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Canvas canvas, XColor * colorPtr));
/* 13 */
EXTERN int		Tk_CanvasPsFont _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Canvas canvas, Tk_Font font));
/* 14 */
EXTERN void		Tk_CanvasPsPath _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Canvas canvas, double * coordPtr, 
				int numPoints));
/* 15 */
EXTERN int		Tk_CanvasPsStipple _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Canvas canvas, Pixmap bitmap));
/* 16 */
EXTERN double		Tk_CanvasPsY _ANSI_ARGS_((Tk_Canvas canvas, double y));
/* 17 */
EXTERN void		Tk_CanvasSetStippleOrigin _ANSI_ARGS_((
				Tk_Canvas canvas, GC gc));
/* 18 */
EXTERN int		Tk_CanvasTagsParseProc _ANSI_ARGS_((
				ClientData clientData, Tcl_Interp * interp, 
				Tk_Window tkwin, char * value, 
				char * widgRec, int offset));
/* 19 */
EXTERN char *		Tk_CanvasTagsPrintProc _ANSI_ARGS_((
				ClientData clientData, Tk_Window tkwin, 
				char * widgRec, int offset, 
				Tcl_FreeProc ** freeProcPtr));
/* 20 */
EXTERN Tk_Window	Tk_CanvasTkwin _ANSI_ARGS_((Tk_Canvas canvas));
/* 21 */
EXTERN void		Tk_CanvasWindowCoords _ANSI_ARGS_((Tk_Canvas canvas, 
				double x, double y, short * screenXPtr, 
				short * screenYPtr));
/* 22 */
EXTERN void		Tk_ChangeWindowAttributes _ANSI_ARGS_((
				Tk_Window tkwin, unsigned long valueMask, 
				XSetWindowAttributes * attsPtr));
/* 23 */
EXTERN int		Tk_CharBbox _ANSI_ARGS_((Tk_TextLayout layout, 
				int index, int * xPtr, int * yPtr, 
				int * widthPtr, int * heightPtr));
/* 24 */
EXTERN void		Tk_ClearSelection _ANSI_ARGS_((Tk_Window tkwin, 
				Atom selection));
/* 25 */
EXTERN int		Tk_ClipboardAppend _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window tkwin, Atom target, Atom format, 
				char* buffer));
/* 26 */
EXTERN int		Tk_ClipboardClear _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window tkwin));
/* 27 */
EXTERN int		Tk_ConfigureInfo _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window tkwin, Tk_ConfigSpec * specs, 
				char * widgRec, char * argvName, int flags));
/* 28 */
EXTERN int		Tk_ConfigureValue _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window tkwin, Tk_ConfigSpec * specs, 
				char * widgRec, char * argvName, int flags));
/* 29 */
EXTERN int		Tk_ConfigureWidget _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window tkwin, Tk_ConfigSpec * specs, 
				int argc, char ** argv, char * widgRec, 
				int flags));
/* 30 */
EXTERN void		Tk_ConfigureWindow _ANSI_ARGS_((Tk_Window tkwin, 
				unsigned int valueMask, 
				XWindowChanges * valuePtr));
/* 31 */
EXTERN Tk_TextLayout	Tk_ComputeTextLayout _ANSI_ARGS_((Tk_Font font, 
				CONST char * string, int numChars, 
				int wrapLength, Tk_Justify justify, 
				int flags, int * widthPtr, int * heightPtr));
/* 32 */
EXTERN Tk_Window	Tk_CoordsToWindow _ANSI_ARGS_((int rootX, int rootY, 
				Tk_Window tkwin));
/* 33 */
EXTERN unsigned long	Tk_CreateBinding _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_BindingTable bindingTable, 
				ClientData object, char * eventString, 
				char * command, int append));
/* 34 */
EXTERN Tk_BindingTable	Tk_CreateBindingTable _ANSI_ARGS_((
				Tcl_Interp * interp));
/* 35 */
EXTERN Tk_ErrorHandler	Tk_CreateErrorHandler _ANSI_ARGS_((Display * display, 
				int errNum, int request, int minorCode, 
				Tk_ErrorProc * errorProc, 
				ClientData clientData));
/* 36 */
EXTERN void		Tk_CreateEventHandler _ANSI_ARGS_((Tk_Window token, 
				unsigned long mask, Tk_EventProc * proc, 
				ClientData clientData));
/* 37 */
EXTERN void		Tk_CreateGenericHandler _ANSI_ARGS_((
				Tk_GenericProc * proc, ClientData clientData));
/* 38 */
EXTERN void		Tk_CreateImageType _ANSI_ARGS_((
				Tk_ImageType * typePtr));
/* 39 */
EXTERN void		Tk_CreateItemType _ANSI_ARGS_((Tk_ItemType * typePtr));
/* 40 */
EXTERN void		Tk_CreatePhotoImageFormat _ANSI_ARGS_((
				Tk_PhotoImageFormat * formatPtr));
/* 41 */
EXTERN void		Tk_CreateSelHandler _ANSI_ARGS_((Tk_Window tkwin, 
				Atom selection, Atom target, 
				Tk_SelectionProc * proc, 
				ClientData clientData, Atom format));
/* 42 */
EXTERN Tk_Window	Tk_CreateWindow _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window parent, char * name, 
				char * screenName));
/* 43 */
EXTERN Tk_Window	Tk_CreateWindowFromPath _ANSI_ARGS_((
				Tcl_Interp * interp, Tk_Window tkwin, 
				char * pathName, char * screenName));
/* 44 */
EXTERN int		Tk_DefineBitmap _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Uid name, char * source, int width, 
				int height));
/* 45 */
EXTERN void		Tk_DefineCursor _ANSI_ARGS_((Tk_Window window, 
				Tk_Cursor cursor));
/* 46 */
EXTERN void		Tk_DeleteAllBindings _ANSI_ARGS_((
				Tk_BindingTable bindingTable, 
				ClientData object));
/* 47 */
EXTERN int		Tk_DeleteBinding _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_BindingTable bindingTable, 
				ClientData object, char * eventString));
/* 48 */
EXTERN void		Tk_DeleteBindingTable _ANSI_ARGS_((
				Tk_BindingTable bindingTable));
/* 49 */
EXTERN void		Tk_DeleteErrorHandler _ANSI_ARGS_((
				Tk_ErrorHandler handler));
/* 50 */
EXTERN void		Tk_DeleteEventHandler _ANSI_ARGS_((Tk_Window token, 
				unsigned long mask, Tk_EventProc * proc, 
				ClientData clientData));
/* 51 */
EXTERN void		Tk_DeleteGenericHandler _ANSI_ARGS_((
				Tk_GenericProc * proc, ClientData clientData));
/* 52 */
EXTERN void		Tk_DeleteImage _ANSI_ARGS_((Tcl_Interp * interp, 
				char * name));
/* 53 */
EXTERN void		Tk_DeleteSelHandler _ANSI_ARGS_((Tk_Window tkwin, 
				Atom selection, Atom target));
/* 54 */
EXTERN void		Tk_DestroyWindow _ANSI_ARGS_((Tk_Window tkwin));
/* 55 */
EXTERN char *		Tk_DisplayName _ANSI_ARGS_((Tk_Window tkwin));
/* 56 */
EXTERN int		Tk_DistanceToTextLayout _ANSI_ARGS_((
				Tk_TextLayout layout, int x, int y));
/* 57 */
EXTERN void		Tk_Draw3DPolygon _ANSI_ARGS_((Tk_Window tkwin, 
				Drawable drawable, Tk_3DBorder border, 
				XPoint * pointPtr, int numPoints, 
				int borderWidth, int leftRelief));
/* 58 */
EXTERN void		Tk_Draw3DRectangle _ANSI_ARGS_((Tk_Window tkwin, 
				Drawable drawable, Tk_3DBorder border, int x, 
				int y, int width, int height, 
				int borderWidth, int relief));
/* 59 */
EXTERN void		Tk_DrawChars _ANSI_ARGS_((Display * display, 
				Drawable drawable, GC gc, Tk_Font tkfont, 
				CONST char * source, int numChars, int x, 
				int y));
/* 60 */
EXTERN void		Tk_DrawFocusHighlight _ANSI_ARGS_((Tk_Window tkwin, 
				GC gc, int width, Drawable drawable));
/* 61 */
EXTERN void		Tk_DrawTextLayout _ANSI_ARGS_((Display * display, 
				Drawable drawable, GC gc, 
				Tk_TextLayout layout, int x, int y, 
				int firstChar, int lastChar));
/* 62 */
EXTERN void		Tk_Fill3DPolygon _ANSI_ARGS_((Tk_Window tkwin, 
				Drawable drawable, Tk_3DBorder border, 
				XPoint * pointPtr, int numPoints, 
				int borderWidth, int leftRelief));
/* 63 */
EXTERN void		Tk_Fill3DRectangle _ANSI_ARGS_((Tk_Window tkwin, 
				Drawable drawable, Tk_3DBorder border, int x, 
				int y, int width, int height, 
				int borderWidth, int relief));
/* 64 */
EXTERN Tk_PhotoHandle	Tk_FindPhoto _ANSI_ARGS_((Tcl_Interp * interp, 
				char * imageName));
/* 65 */
EXTERN Font		Tk_FontId _ANSI_ARGS_((Tk_Font font));
/* 66 */
EXTERN void		Tk_Free3DBorder _ANSI_ARGS_((Tk_3DBorder border));
/* 67 */
EXTERN void		Tk_FreeBitmap _ANSI_ARGS_((Display * display, 
				Pixmap bitmap));
/* 68 */
EXTERN void		Tk_FreeColor _ANSI_ARGS_((XColor * colorPtr));
/* 69 */
EXTERN void		Tk_FreeColormap _ANSI_ARGS_((Display * display, 
				Colormap colormap));
/* 70 */
EXTERN void		Tk_FreeCursor _ANSI_ARGS_((Display * display, 
				Tk_Cursor cursor));
/* 71 */
EXTERN void		Tk_FreeFont _ANSI_ARGS_((Tk_Font f));
/* 72 */
EXTERN void		Tk_FreeGC _ANSI_ARGS_((Display * display, GC gc));
/* 73 */
EXTERN void		Tk_FreeImage _ANSI_ARGS_((Tk_Image image));
/* 74 */
EXTERN void		Tk_FreeOptions _ANSI_ARGS_((Tk_ConfigSpec * specs, 
				char * widgRec, Display * display, 
				int needFlags));
/* 75 */
EXTERN void		Tk_FreePixmap _ANSI_ARGS_((Display * display, 
				Pixmap pixmap));
/* 76 */
EXTERN void		Tk_FreeTextLayout _ANSI_ARGS_((
				Tk_TextLayout textLayout));
/* 77 */
EXTERN void		Tk_FreeXId _ANSI_ARGS_((Display * display, XID xid));
/* 78 */
EXTERN GC		Tk_GCForColor _ANSI_ARGS_((XColor * colorPtr, 
				Drawable drawable));
/* 79 */
EXTERN void		Tk_GeometryRequest _ANSI_ARGS_((Tk_Window tkwin, 
				int reqWidth, int reqHeight));
/* 80 */
EXTERN Tk_3DBorder	Tk_Get3DBorder _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window tkwin, Tk_Uid colorName));
/* 81 */
EXTERN void		Tk_GetAllBindings _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_BindingTable bindingTable, 
				ClientData object));
/* 82 */
EXTERN int		Tk_GetAnchor _ANSI_ARGS_((Tcl_Interp * interp, 
				char * string, Tk_Anchor * anchorPtr));
/* 83 */
EXTERN char *		Tk_GetAtomName _ANSI_ARGS_((Tk_Window tkwin, 
				Atom atom));
/* 84 */
EXTERN char *		Tk_GetBinding _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_BindingTable bindingTable, 
				ClientData object, char * eventString));
/* 85 */
EXTERN Pixmap		Tk_GetBitmap _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window tkwin, Tk_Uid string));
/* 86 */
EXTERN Pixmap		Tk_GetBitmapFromData _ANSI_ARGS_((
				Tcl_Interp * interp, Tk_Window tkwin, 
				char * source, int width, int height));
/* 87 */
EXTERN int		Tk_GetCapStyle _ANSI_ARGS_((Tcl_Interp * interp, 
				char * string, int * capPtr));
/* 88 */
EXTERN XColor *		Tk_GetColor _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window tkwin, Tk_Uid name));
/* 89 */
EXTERN XColor *		Tk_GetColorByValue _ANSI_ARGS_((Tk_Window tkwin, 
				XColor * colorPtr));
/* 90 */
EXTERN Colormap		Tk_GetColormap _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window tkwin, char * string));
/* 91 */
EXTERN Tk_Cursor	Tk_GetCursor _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window tkwin, Tk_Uid string));
/* 92 */
EXTERN Tk_Cursor	Tk_GetCursorFromData _ANSI_ARGS_((
				Tcl_Interp * interp, Tk_Window tkwin, 
				char * source, char * mask, int width, 
				int height, int xHot, int yHot, Tk_Uid fg, 
				Tk_Uid bg));
/* 93 */
EXTERN Tk_Font		Tk_GetFont _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window tkwin, CONST char * string));
/* 94 */
EXTERN Tk_Font		Tk_GetFontFromObj _ANSI_ARGS_((Tk_Window tkwin, 
				Tcl_Obj * objPtr));
/* 95 */
EXTERN void		Tk_GetFontMetrics _ANSI_ARGS_((Tk_Font font, 
				Tk_FontMetrics * fmPtr));
/* 96 */
EXTERN GC		Tk_GetGC _ANSI_ARGS_((Tk_Window tkwin, 
				unsigned long valueMask, 
				XGCValues * valuePtr));
/* 97 */
EXTERN Tk_Image		Tk_GetImage _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window tkwin, char * name, 
				Tk_ImageChangedProc * changeProc, 
				ClientData clientData));
/* 98 */
EXTERN ClientData	Tk_GetImageMasterData _ANSI_ARGS_((
				Tcl_Interp * interp, char * name, 
				Tk_ImageType ** typePtrPtr));
/* 99 */
EXTERN Tk_ItemType *	Tk_GetItemTypes _ANSI_ARGS_((void));
/* 100 */
EXTERN int		Tk_GetJoinStyle _ANSI_ARGS_((Tcl_Interp * interp, 
				char * string, int * joinPtr));
/* 101 */
EXTERN int		Tk_GetJustify _ANSI_ARGS_((Tcl_Interp * interp, 
				char * string, Tk_Justify * justifyPtr));
/* 102 */
EXTERN int		Tk_GetNumMainWindows _ANSI_ARGS_((void));
/* 103 */
EXTERN Tk_Uid		Tk_GetOption _ANSI_ARGS_((Tk_Window tkwin, 
				char * name, char * className));
/* 104 */
EXTERN int		Tk_GetPixels _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window tkwin, char * string, int * intPtr));
/* 105 */
EXTERN Pixmap		Tk_GetPixmap _ANSI_ARGS_((Display * display, 
				Drawable d, int width, int height, int depth));
/* 106 */
EXTERN int		Tk_GetRelief _ANSI_ARGS_((Tcl_Interp * interp, 
				char * name, int * reliefPtr));
/* 107 */
EXTERN void		Tk_GetRootCoords _ANSI_ARGS_((Tk_Window tkwin, 
				int * xPtr, int * yPtr));
/* 108 */
EXTERN int		Tk_GetScrollInfo _ANSI_ARGS_((Tcl_Interp * interp, 
				int argc, char ** argv, double * dblPtr, 
				int * intPtr));
/* 109 */
EXTERN int		Tk_GetScreenMM _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window tkwin, char * string, 
				double * doublePtr));
/* 110 */
EXTERN int		Tk_GetSelection _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window tkwin, Atom selection, Atom target, 
				Tk_GetSelProc * proc, ClientData clientData));
/* 111 */
EXTERN Tk_Uid		Tk_GetUid _ANSI_ARGS_((CONST char * string));
/* 112 */
EXTERN Visual *		Tk_GetVisual _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window tkwin, char * string, 
				int * depthPtr, Colormap * colormapPtr));
/* 113 */
EXTERN void		Tk_GetVRootGeometry _ANSI_ARGS_((Tk_Window tkwin, 
				int * xPtr, int * yPtr, int * widthPtr, 
				int * heightPtr));
/* 114 */
EXTERN int		Tk_Grab _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window tkwin, int grabGlobal));
/* 115 */
EXTERN void		Tk_HandleEvent _ANSI_ARGS_((XEvent * eventPtr));
/* 116 */
EXTERN Tk_Window	Tk_IdToWindow _ANSI_ARGS_((Display * display, 
				Window window));
/* 117 */
EXTERN void		Tk_ImageChanged _ANSI_ARGS_((Tk_ImageMaster master, 
				int x, int y, int width, int height, 
				int imageWidth, int imageHeight));
/* 118 */
EXTERN int		Tk_Init _ANSI_ARGS_((Tcl_Interp * interp));
/* 119 */
EXTERN Atom		Tk_InternAtom _ANSI_ARGS_((Tk_Window tkwin, 
				char * name));
/* 120 */
EXTERN int		Tk_IntersectTextLayout _ANSI_ARGS_((
				Tk_TextLayout layout, int x, int y, 
				int width, int height));
/* 121 */
EXTERN void		Tk_MaintainGeometry _ANSI_ARGS_((Tk_Window slave, 
				Tk_Window master, int x, int y, int width, 
				int height));
/* 122 */
EXTERN Tk_Window	Tk_MainWindow _ANSI_ARGS_((Tcl_Interp * interp));
/* 123 */
EXTERN void		Tk_MakeWindowExist _ANSI_ARGS_((Tk_Window tkwin));
/* 124 */
EXTERN void		Tk_ManageGeometry _ANSI_ARGS_((Tk_Window tkwin, 
				Tk_GeomMgr * mgrPtr, ClientData clientData));
/* 125 */
EXTERN void		Tk_MapWindow _ANSI_ARGS_((Tk_Window tkwin));
/* 126 */
EXTERN int		Tk_MeasureChars _ANSI_ARGS_((Tk_Font tkfont, 
				CONST char * source, int maxChars, 
				int maxPixels, int flags, int * lengthPtr));
/* 127 */
EXTERN void		Tk_MoveResizeWindow _ANSI_ARGS_((Tk_Window tkwin, 
				int x, int y, int width, int height));
/* 128 */
EXTERN void		Tk_MoveWindow _ANSI_ARGS_((Tk_Window tkwin, int x, 
				int y));
/* 129 */
EXTERN void		Tk_MoveToplevelWindow _ANSI_ARGS_((Tk_Window tkwin, 
				int x, int y));
/* 130 */
EXTERN char *		Tk_NameOf3DBorder _ANSI_ARGS_((Tk_3DBorder border));
/* 131 */
EXTERN char *		Tk_NameOfAnchor _ANSI_ARGS_((Tk_Anchor anchor));
/* 132 */
EXTERN char *		Tk_NameOfBitmap _ANSI_ARGS_((Display * display, 
				Pixmap bitmap));
/* 133 */
EXTERN char *		Tk_NameOfCapStyle _ANSI_ARGS_((int cap));
/* 134 */
EXTERN char *		Tk_NameOfColor _ANSI_ARGS_((XColor * colorPtr));
/* 135 */
EXTERN char *		Tk_NameOfCursor _ANSI_ARGS_((Display * display, 
				Tk_Cursor cursor));
/* 136 */
EXTERN char *		Tk_NameOfFont _ANSI_ARGS_((Tk_Font font));
/* 137 */
EXTERN char *		Tk_NameOfImage _ANSI_ARGS_((
				Tk_ImageMaster imageMaster));
/* 138 */
EXTERN char *		Tk_NameOfJoinStyle _ANSI_ARGS_((int join));
/* 139 */
EXTERN char *		Tk_NameOfJustify _ANSI_ARGS_((Tk_Justify justify));
/* 140 */
EXTERN char *		Tk_NameOfRelief _ANSI_ARGS_((int relief));
/* 141 */
EXTERN Tk_Window	Tk_NameToWindow _ANSI_ARGS_((Tcl_Interp * interp, 
				char * pathName, Tk_Window tkwin));
/* 142 */
EXTERN void		Tk_OwnSelection _ANSI_ARGS_((Tk_Window tkwin, 
				Atom selection, Tk_LostSelProc * proc, 
				ClientData clientData));
/* 143 */
EXTERN int		Tk_ParseArgv _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window tkwin, int * argcPtr, char ** argv, 
				Tk_ArgvInfo * argTable, int flags));
/* 144 */
EXTERN void		Tk_PhotoPutBlock _ANSI_ARGS_((Tk_PhotoHandle handle, 
				Tk_PhotoImageBlock * blockPtr, int x, int y, 
				int width, int height));
/* 145 */
EXTERN void		Tk_PhotoPutZoomedBlock _ANSI_ARGS_((
				Tk_PhotoHandle handle, 
				Tk_PhotoImageBlock * blockPtr, int x, int y, 
				int width, int height, int zoomX, int zoomY, 
				int subsampleX, int subsampleY));
/* 146 */
EXTERN int		Tk_PhotoGetImage _ANSI_ARGS_((Tk_PhotoHandle handle, 
				Tk_PhotoImageBlock * blockPtr));
/* 147 */
EXTERN void		Tk_PhotoBlank _ANSI_ARGS_((Tk_PhotoHandle handle));
/* 148 */
EXTERN void		Tk_PhotoExpand _ANSI_ARGS_((Tk_PhotoHandle handle, 
				int width, int height));
/* 149 */
EXTERN void		Tk_PhotoGetSize _ANSI_ARGS_((Tk_PhotoHandle handle, 
				int * widthPtr, int * heightPtr));
/* 150 */
EXTERN void		Tk_PhotoSetSize _ANSI_ARGS_((Tk_PhotoHandle handle, 
				int width, int height));
/* 151 */
EXTERN int		Tk_PointToChar _ANSI_ARGS_((Tk_TextLayout layout, 
				int x, int y));
/* 152 */
EXTERN int		Tk_PostscriptFontName _ANSI_ARGS_((Tk_Font tkfont, 
				Tcl_DString * dsPtr));
/* 153 */
EXTERN void		Tk_PreserveColormap _ANSI_ARGS_((Display * display, 
				Colormap colormap));
/* 154 */
EXTERN void		Tk_QueueWindowEvent _ANSI_ARGS_((XEvent * eventPtr, 
				Tcl_QueuePosition position));
/* 155 */
EXTERN void		Tk_RedrawImage _ANSI_ARGS_((Tk_Image image, 
				int imageX, int imageY, int width, 
				int height, Drawable drawable, int drawableX, 
				int drawableY));
/* 156 */
EXTERN void		Tk_ResizeWindow _ANSI_ARGS_((Tk_Window tkwin, 
				int width, int height));
/* 157 */
EXTERN int		Tk_RestackWindow _ANSI_ARGS_((Tk_Window tkwin, 
				int aboveBelow, Tk_Window other));
/* 158 */
EXTERN Tk_RestrictProc * Tk_RestrictEvents _ANSI_ARGS_((
				Tk_RestrictProc * proc, ClientData arg, 
				ClientData * prevArgPtr));
/* 159 */
EXTERN int		Tk_SafeInit _ANSI_ARGS_((Tcl_Interp * interp));
/* 160 */
EXTERN char *		Tk_SetAppName _ANSI_ARGS_((Tk_Window tkwin, 
				char * name));
/* 161 */
EXTERN void		Tk_SetBackgroundFromBorder _ANSI_ARGS_((
				Tk_Window tkwin, Tk_3DBorder border));
/* 162 */
EXTERN void		Tk_SetClass _ANSI_ARGS_((Tk_Window tkwin, 
				char * className));
/* 163 */
EXTERN void		Tk_SetGrid _ANSI_ARGS_((Tk_Window tkwin, 
				int reqWidth, int reqHeight, int gridWidth, 
				int gridHeight));
/* 164 */
EXTERN void		Tk_SetInternalBorder _ANSI_ARGS_((Tk_Window tkwin, 
				int width));
/* 165 */
EXTERN void		Tk_SetWindowBackground _ANSI_ARGS_((Tk_Window tkwin, 
				unsigned long pixel));
/* 166 */
EXTERN void		Tk_SetWindowBackgroundPixmap _ANSI_ARGS_((
				Tk_Window tkwin, Pixmap pixmap));
/* 167 */
EXTERN void		Tk_SetWindowBorder _ANSI_ARGS_((Tk_Window tkwin, 
				unsigned long pixel));
/* 168 */
EXTERN void		Tk_SetWindowBorderWidth _ANSI_ARGS_((Tk_Window tkwin, 
				int width));
/* 169 */
EXTERN void		Tk_SetWindowBorderPixmap _ANSI_ARGS_((
				Tk_Window tkwin, Pixmap pixmap));
/* 170 */
EXTERN void		Tk_SetWindowColormap _ANSI_ARGS_((Tk_Window tkwin, 
				Colormap colormap));
/* 171 */
EXTERN int		Tk_SetWindowVisual _ANSI_ARGS_((Tk_Window tkwin, 
				Visual * visual, int depth, 
				Colormap colormap));
/* 172 */
EXTERN void		Tk_SizeOfBitmap _ANSI_ARGS_((Display * display, 
				Pixmap bitmap, int * widthPtr, 
				int * heightPtr));
/* 173 */
EXTERN void		Tk_SizeOfImage _ANSI_ARGS_((Tk_Image image, 
				int * widthPtr, int * heightPtr));
/* 174 */
EXTERN int		Tk_StrictMotif _ANSI_ARGS_((Tk_Window tkwin));
/* 175 */
EXTERN void		Tk_TextLayoutToPostscript _ANSI_ARGS_((
				Tcl_Interp * interp, Tk_TextLayout layout));
/* 176 */
EXTERN int		Tk_TextWidth _ANSI_ARGS_((Tk_Font font, 
				CONST char * string, int numChars));
/* 177 */
EXTERN void		Tk_UndefineCursor _ANSI_ARGS_((Tk_Window window));
/* 178 */
EXTERN void		Tk_UnderlineChars _ANSI_ARGS_((Display * display, 
				Drawable drawable, GC gc, Tk_Font tkfont, 
				CONST char * source, int x, int y, 
				int firstChar, int lastChar));
/* 179 */
EXTERN void		Tk_UnderlineTextLayout _ANSI_ARGS_((
				Display * display, Drawable drawable, GC gc, 
				Tk_TextLayout layout, int x, int y, 
				int underline));
/* 180 */
EXTERN void		Tk_Ungrab _ANSI_ARGS_((Tk_Window tkwin));
/* 181 */
EXTERN void		Tk_UnmaintainGeometry _ANSI_ARGS_((Tk_Window slave, 
				Tk_Window master));
/* 182 */
EXTERN void		Tk_UnmapWindow _ANSI_ARGS_((Tk_Window tkwin));
/* 183 */
EXTERN void		Tk_UnsetGrid _ANSI_ARGS_((Tk_Window tkwin));
/* 184 */
EXTERN void		Tk_UpdatePointer _ANSI_ARGS_((Tk_Window tkwin, int x, 
				int y, int state));
/* 185 */
EXTERN Pixmap		Tk_AllocBitmapFromObj _ANSI_ARGS_((
				Tcl_Interp * interp, Tk_Window tkwin, 
				Tcl_Obj * objPtr));
/* 186 */
EXTERN Tk_3DBorder	Tk_Alloc3DBorderFromObj _ANSI_ARGS_((
				Tcl_Interp * interp, Tk_Window tkwin, 
				Tcl_Obj * objPtr));
/* 187 */
EXTERN XColor *		Tk_AllocColorFromObj _ANSI_ARGS_((
				Tcl_Interp * interp, Tk_Window tkwin, 
				Tcl_Obj * objPtr));
/* 188 */
EXTERN Tk_Cursor	Tk_AllocCursorFromObj _ANSI_ARGS_((
				Tcl_Interp * interp, Tk_Window tkwin, 
				Tcl_Obj * objPtr));
/* 189 */
EXTERN Tk_Font		Tk_AllocFontFromObj _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window tkwin, Tcl_Obj * objPtr));
/* 190 */
EXTERN Tk_OptionTable	Tk_CreateOptionTable _ANSI_ARGS_((
				Tcl_Interp * interp, 
				CONST Tk_OptionSpec * templatePtr));
/* 191 */
EXTERN void		Tk_DeleteOptionTable _ANSI_ARGS_((
				Tk_OptionTable optionTable));
/* 192 */
EXTERN void		Tk_Free3DBorderFromObj _ANSI_ARGS_((Tk_Window tkwin, 
				Tcl_Obj * objPtr));
/* 193 */
EXTERN void		Tk_FreeBitmapFromObj _ANSI_ARGS_((Tk_Window tkwin, 
				Tcl_Obj * objPtr));
/* 194 */
EXTERN void		Tk_FreeColorFromObj _ANSI_ARGS_((Tk_Window tkwin, 
				Tcl_Obj * objPtr));
/* 195 */
EXTERN void		Tk_FreeConfigOptions _ANSI_ARGS_((char * recordPtr, 
				Tk_OptionTable optionToken, Tk_Window tkwin));
/* 196 */
EXTERN void		Tk_FreeSavedOptions _ANSI_ARGS_((
				Tk_SavedOptions * savePtr));
/* 197 */
EXTERN void		Tk_FreeCursorFromObj _ANSI_ARGS_((Tk_Window tkwin, 
				Tcl_Obj * objPtr));
/* 198 */
EXTERN void		Tk_FreeFontFromObj _ANSI_ARGS_((Tk_Window tkwin, 
				Tcl_Obj * objPtr));
/* 199 */
EXTERN Tk_3DBorder	Tk_Get3DBorderFromObj _ANSI_ARGS_((Tk_Window tkwin, 
				Tcl_Obj * objPtr));
/* 200 */
EXTERN int		Tk_GetAnchorFromObj _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * objPtr, Tk_Anchor * anchorPtr));
/* 201 */
EXTERN Pixmap		Tk_GetBitmapFromObj _ANSI_ARGS_((Tk_Window tkwin, 
				Tcl_Obj * objPtr));
/* 202 */
EXTERN XColor *		Tk_GetColorFromObj _ANSI_ARGS_((Tk_Window tkwin, 
				Tcl_Obj * objPtr));
/* 203 */
EXTERN Tk_Cursor	Tk_GetCursorFromObj _ANSI_ARGS_((Tk_Window tkwin, 
				Tcl_Obj * objPtr));
/* 204 */
EXTERN Tcl_Obj *	Tk_GetOptionInfo _ANSI_ARGS_((Tcl_Interp * interp, 
				char * recordPtr, Tk_OptionTable optionTable, 
				Tcl_Obj * namePtr, Tk_Window tkwin));
/* 205 */
EXTERN Tcl_Obj *	Tk_GetOptionValue _ANSI_ARGS_((Tcl_Interp * interp, 
				char * recordPtr, Tk_OptionTable optionTable, 
				Tcl_Obj * namePtr, Tk_Window tkwin));
/* 206 */
EXTERN int		Tk_GetJustifyFromObj _ANSI_ARGS_((
				Tcl_Interp * interp, Tcl_Obj * objPtr, 
				Tk_Justify * justifyPtr));
/* 207 */
EXTERN int		Tk_GetMMFromObj _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window tkwin, Tcl_Obj * objPtr, 
				double * doublePtr));
/* 208 */
EXTERN int		Tk_GetPixelsFromObj _ANSI_ARGS_((Tcl_Interp * interp, 
				Tk_Window tkwin, Tcl_Obj * objPtr, 
				int * intPtr));
/* 209 */
EXTERN int		Tk_GetReliefFromObj _ANSI_ARGS_((Tcl_Interp * interp, 
				Tcl_Obj * objPtr, int * resultPtr));
/* 210 */
EXTERN int		Tk_GetScrollInfoObj _ANSI_ARGS_((Tcl_Interp * interp, 
				int objc, Tcl_Obj *CONST objv[], 
				double * dblPtr, int * intPtr));
/* 211 */
EXTERN int		Tk_InitOptions _ANSI_ARGS_((Tcl_Interp * interp, 
				char * recordPtr, Tk_OptionTable optionToken, 
				Tk_Window tkwin));
/* 212 */
EXTERN void		Tk_MainEx _ANSI_ARGS_((int argc, char ** argv, 
				Tcl_AppInitProc * appInitProc, 
				Tcl_Interp * interp));
/* 213 */
EXTERN void		Tk_RestoreSavedOptions _ANSI_ARGS_((
				Tk_SavedOptions * savePtr));
/* 214 */
EXTERN int		Tk_SetOptions _ANSI_ARGS_((Tcl_Interp * interp, 
				char * recordPtr, Tk_OptionTable optionTable, 
				int objc, Tcl_Obj *CONST objv[], 
				Tk_Window tkwin, Tk_SavedOptions * savePtr, 
				int * maskPtr));

typedef struct TkStubHooks {
    struct TkPlatStubs *tkPlatStubs;
    struct TkIntStubs *tkIntStubs;
    struct TkIntPlatStubs *tkIntPlatStubs;
    struct TkIntXlibStubs *tkIntXlibStubs;
} TkStubHooks;

typedef struct TkStubs {
    int magic;
    struct TkStubHooks *hooks;

    void (*tk_MainLoop) _ANSI_ARGS_((void)); /* 0 */
    XColor * (*tk_3DBorderColor) _ANSI_ARGS_((Tk_3DBorder border)); /* 1 */
    GC (*tk_3DBorderGC) _ANSI_ARGS_((Tk_Window tkwin, Tk_3DBorder border, int which)); /* 2 */
    void (*tk_3DHorizontalBevel) _ANSI_ARGS_((Tk_Window tkwin, Drawable drawable, Tk_3DBorder border, int x, int y, int width, int height, int leftIn, int rightIn, int topBevel, int relief)); /* 3 */
    void (*tk_3DVerticalBevel) _ANSI_ARGS_((Tk_Window tkwin, Drawable drawable, Tk_3DBorder border, int x, int y, int width, int height, int leftBevel, int relief)); /* 4 */
    void (*tk_AddOption) _ANSI_ARGS_((Tk_Window tkwin, char * name, char * value, int priority)); /* 5 */
    void (*tk_BindEvent) _ANSI_ARGS_((Tk_BindingTable bindingTable, XEvent * eventPtr, Tk_Window tkwin, int numObjects, ClientData * objectPtr)); /* 6 */
    void (*tk_CanvasDrawableCoords) _ANSI_ARGS_((Tk_Canvas canvas, double x, double y, short * drawableXPtr, short * drawableYPtr)); /* 7 */
    void (*tk_CanvasEventuallyRedraw) _ANSI_ARGS_((Tk_Canvas canvas, int x1, int y1, int x2, int y2)); /* 8 */
    int (*tk_CanvasGetCoord) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Canvas canvas, char * string, double * doublePtr)); /* 9 */
    Tk_CanvasTextInfo * (*tk_CanvasGetTextInfo) _ANSI_ARGS_((Tk_Canvas canvas)); /* 10 */
    int (*tk_CanvasPsBitmap) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Canvas canvas, Pixmap bitmap, int x, int y, int width, int height)); /* 11 */
    int (*tk_CanvasPsColor) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Canvas canvas, XColor * colorPtr)); /* 12 */
    int (*tk_CanvasPsFont) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Canvas canvas, Tk_Font font)); /* 13 */
    void (*tk_CanvasPsPath) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Canvas canvas, double * coordPtr, int numPoints)); /* 14 */
    int (*tk_CanvasPsStipple) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Canvas canvas, Pixmap bitmap)); /* 15 */
    double (*tk_CanvasPsY) _ANSI_ARGS_((Tk_Canvas canvas, double y)); /* 16 */
    void (*tk_CanvasSetStippleOrigin) _ANSI_ARGS_((Tk_Canvas canvas, GC gc)); /* 17 */
    int (*tk_CanvasTagsParseProc) _ANSI_ARGS_((ClientData clientData, Tcl_Interp * interp, Tk_Window tkwin, char * value, char * widgRec, int offset)); /* 18 */
    char * (*tk_CanvasTagsPrintProc) _ANSI_ARGS_((ClientData clientData, Tk_Window tkwin, char * widgRec, int offset, Tcl_FreeProc ** freeProcPtr)); /* 19 */
    Tk_Window (*tk_CanvasTkwin) _ANSI_ARGS_((Tk_Canvas canvas)); /* 20 */
    void (*tk_CanvasWindowCoords) _ANSI_ARGS_((Tk_Canvas canvas, double x, double y, short * screenXPtr, short * screenYPtr)); /* 21 */
    void (*tk_ChangeWindowAttributes) _ANSI_ARGS_((Tk_Window tkwin, unsigned long valueMask, XSetWindowAttributes * attsPtr)); /* 22 */
    int (*tk_CharBbox) _ANSI_ARGS_((Tk_TextLayout layout, int index, int * xPtr, int * yPtr, int * widthPtr, int * heightPtr)); /* 23 */
    void (*tk_ClearSelection) _ANSI_ARGS_((Tk_Window tkwin, Atom selection)); /* 24 */
    int (*tk_ClipboardAppend) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, Atom target, Atom format, char* buffer)); /* 25 */
    int (*tk_ClipboardClear) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin)); /* 26 */
    int (*tk_ConfigureInfo) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, Tk_ConfigSpec * specs, char * widgRec, char * argvName, int flags)); /* 27 */
    int (*tk_ConfigureValue) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, Tk_ConfigSpec * specs, char * widgRec, char * argvName, int flags)); /* 28 */
    int (*tk_ConfigureWidget) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, Tk_ConfigSpec * specs, int argc, char ** argv, char * widgRec, int flags)); /* 29 */
    void (*tk_ConfigureWindow) _ANSI_ARGS_((Tk_Window tkwin, unsigned int valueMask, XWindowChanges * valuePtr)); /* 30 */
    Tk_TextLayout (*tk_ComputeTextLayout) _ANSI_ARGS_((Tk_Font font, CONST char * string, int numChars, int wrapLength, Tk_Justify justify, int flags, int * widthPtr, int * heightPtr)); /* 31 */
    Tk_Window (*tk_CoordsToWindow) _ANSI_ARGS_((int rootX, int rootY, Tk_Window tkwin)); /* 32 */
    unsigned long (*tk_CreateBinding) _ANSI_ARGS_((Tcl_Interp * interp, Tk_BindingTable bindingTable, ClientData object, char * eventString, char * command, int append)); /* 33 */
    Tk_BindingTable (*tk_CreateBindingTable) _ANSI_ARGS_((Tcl_Interp * interp)); /* 34 */
    Tk_ErrorHandler (*tk_CreateErrorHandler) _ANSI_ARGS_((Display * display, int errNum, int request, int minorCode, Tk_ErrorProc * errorProc, ClientData clientData)); /* 35 */
    void (*tk_CreateEventHandler) _ANSI_ARGS_((Tk_Window token, unsigned long mask, Tk_EventProc * proc, ClientData clientData)); /* 36 */
    void (*tk_CreateGenericHandler) _ANSI_ARGS_((Tk_GenericProc * proc, ClientData clientData)); /* 37 */
    void (*tk_CreateImageType) _ANSI_ARGS_((Tk_ImageType * typePtr)); /* 38 */
    void (*tk_CreateItemType) _ANSI_ARGS_((Tk_ItemType * typePtr)); /* 39 */
    void (*tk_CreatePhotoImageFormat) _ANSI_ARGS_((Tk_PhotoImageFormat * formatPtr)); /* 40 */
    void (*tk_CreateSelHandler) _ANSI_ARGS_((Tk_Window tkwin, Atom selection, Atom target, Tk_SelectionProc * proc, ClientData clientData, Atom format)); /* 41 */
    Tk_Window (*tk_CreateWindow) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window parent, char * name, char * screenName)); /* 42 */
    Tk_Window (*tk_CreateWindowFromPath) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, char * pathName, char * screenName)); /* 43 */
    int (*tk_DefineBitmap) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Uid name, char * source, int width, int height)); /* 44 */
    void (*tk_DefineCursor) _ANSI_ARGS_((Tk_Window window, Tk_Cursor cursor)); /* 45 */
    void (*tk_DeleteAllBindings) _ANSI_ARGS_((Tk_BindingTable bindingTable, ClientData object)); /* 46 */
    int (*tk_DeleteBinding) _ANSI_ARGS_((Tcl_Interp * interp, Tk_BindingTable bindingTable, ClientData object, char * eventString)); /* 47 */
    void (*tk_DeleteBindingTable) _ANSI_ARGS_((Tk_BindingTable bindingTable)); /* 48 */
    void (*tk_DeleteErrorHandler) _ANSI_ARGS_((Tk_ErrorHandler handler)); /* 49 */
    void (*tk_DeleteEventHandler) _ANSI_ARGS_((Tk_Window token, unsigned long mask, Tk_EventProc * proc, ClientData clientData)); /* 50 */
    void (*tk_DeleteGenericHandler) _ANSI_ARGS_((Tk_GenericProc * proc, ClientData clientData)); /* 51 */
    void (*tk_DeleteImage) _ANSI_ARGS_((Tcl_Interp * interp, char * name)); /* 52 */
    void (*tk_DeleteSelHandler) _ANSI_ARGS_((Tk_Window tkwin, Atom selection, Atom target)); /* 53 */
    void (*tk_DestroyWindow) _ANSI_ARGS_((Tk_Window tkwin)); /* 54 */
    char * (*tk_DisplayName) _ANSI_ARGS_((Tk_Window tkwin)); /* 55 */
    int (*tk_DistanceToTextLayout) _ANSI_ARGS_((Tk_TextLayout layout, int x, int y)); /* 56 */
    void (*tk_Draw3DPolygon) _ANSI_ARGS_((Tk_Window tkwin, Drawable drawable, Tk_3DBorder border, XPoint * pointPtr, int numPoints, int borderWidth, int leftRelief)); /* 57 */
    void (*tk_Draw3DRectangle) _ANSI_ARGS_((Tk_Window tkwin, Drawable drawable, Tk_3DBorder border, int x, int y, int width, int height, int borderWidth, int relief)); /* 58 */
    void (*tk_DrawChars) _ANSI_ARGS_((Display * display, Drawable drawable, GC gc, Tk_Font tkfont, CONST char * source, int numChars, int x, int y)); /* 59 */
    void (*tk_DrawFocusHighlight) _ANSI_ARGS_((Tk_Window tkwin, GC gc, int width, Drawable drawable)); /* 60 */
    void (*tk_DrawTextLayout) _ANSI_ARGS_((Display * display, Drawable drawable, GC gc, Tk_TextLayout layout, int x, int y, int firstChar, int lastChar)); /* 61 */
    void (*tk_Fill3DPolygon) _ANSI_ARGS_((Tk_Window tkwin, Drawable drawable, Tk_3DBorder border, XPoint * pointPtr, int numPoints, int borderWidth, int leftRelief)); /* 62 */
    void (*tk_Fill3DRectangle) _ANSI_ARGS_((Tk_Window tkwin, Drawable drawable, Tk_3DBorder border, int x, int y, int width, int height, int borderWidth, int relief)); /* 63 */
    Tk_PhotoHandle (*tk_FindPhoto) _ANSI_ARGS_((Tcl_Interp * interp, char * imageName)); /* 64 */
    Font (*tk_FontId) _ANSI_ARGS_((Tk_Font font)); /* 65 */
    void (*tk_Free3DBorder) _ANSI_ARGS_((Tk_3DBorder border)); /* 66 */
    void (*tk_FreeBitmap) _ANSI_ARGS_((Display * display, Pixmap bitmap)); /* 67 */
    void (*tk_FreeColor) _ANSI_ARGS_((XColor * colorPtr)); /* 68 */
    void (*tk_FreeColormap) _ANSI_ARGS_((Display * display, Colormap colormap)); /* 69 */
    void (*tk_FreeCursor) _ANSI_ARGS_((Display * display, Tk_Cursor cursor)); /* 70 */
    void (*tk_FreeFont) _ANSI_ARGS_((Tk_Font f)); /* 71 */
    void (*tk_FreeGC) _ANSI_ARGS_((Display * display, GC gc)); /* 72 */
    void (*tk_FreeImage) _ANSI_ARGS_((Tk_Image image)); /* 73 */
    void (*tk_FreeOptions) _ANSI_ARGS_((Tk_ConfigSpec * specs, char * widgRec, Display * display, int needFlags)); /* 74 */
    void (*tk_FreePixmap) _ANSI_ARGS_((Display * display, Pixmap pixmap)); /* 75 */
    void (*tk_FreeTextLayout) _ANSI_ARGS_((Tk_TextLayout textLayout)); /* 76 */
    void (*tk_FreeXId) _ANSI_ARGS_((Display * display, XID xid)); /* 77 */
    GC (*tk_GCForColor) _ANSI_ARGS_((XColor * colorPtr, Drawable drawable)); /* 78 */
    void (*tk_GeometryRequest) _ANSI_ARGS_((Tk_Window tkwin, int reqWidth, int reqHeight)); /* 79 */
    Tk_3DBorder (*tk_Get3DBorder) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, Tk_Uid colorName)); /* 80 */
    void (*tk_GetAllBindings) _ANSI_ARGS_((Tcl_Interp * interp, Tk_BindingTable bindingTable, ClientData object)); /* 81 */
    int (*tk_GetAnchor) _ANSI_ARGS_((Tcl_Interp * interp, char * string, Tk_Anchor * anchorPtr)); /* 82 */
    char * (*tk_GetAtomName) _ANSI_ARGS_((Tk_Window tkwin, Atom atom)); /* 83 */
    char * (*tk_GetBinding) _ANSI_ARGS_((Tcl_Interp * interp, Tk_BindingTable bindingTable, ClientData object, char * eventString)); /* 84 */
    Pixmap (*tk_GetBitmap) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, Tk_Uid string)); /* 85 */
    Pixmap (*tk_GetBitmapFromData) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, char * source, int width, int height)); /* 86 */
    int (*tk_GetCapStyle) _ANSI_ARGS_((Tcl_Interp * interp, char * string, int * capPtr)); /* 87 */
    XColor * (*tk_GetColor) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, Tk_Uid name)); /* 88 */
    XColor * (*tk_GetColorByValue) _ANSI_ARGS_((Tk_Window tkwin, XColor * colorPtr)); /* 89 */
    Colormap (*tk_GetColormap) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, char * string)); /* 90 */
    Tk_Cursor (*tk_GetCursor) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, Tk_Uid string)); /* 91 */
    Tk_Cursor (*tk_GetCursorFromData) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, char * source, char * mask, int width, int height, int xHot, int yHot, Tk_Uid fg, Tk_Uid bg)); /* 92 */
    Tk_Font (*tk_GetFont) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, CONST char * string)); /* 93 */
    Tk_Font (*tk_GetFontFromObj) _ANSI_ARGS_((Tk_Window tkwin, Tcl_Obj * objPtr)); /* 94 */
    void (*tk_GetFontMetrics) _ANSI_ARGS_((Tk_Font font, Tk_FontMetrics * fmPtr)); /* 95 */
    GC (*tk_GetGC) _ANSI_ARGS_((Tk_Window tkwin, unsigned long valueMask, XGCValues * valuePtr)); /* 96 */
    Tk_Image (*tk_GetImage) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, char * name, Tk_ImageChangedProc * changeProc, ClientData clientData)); /* 97 */
    ClientData (*tk_GetImageMasterData) _ANSI_ARGS_((Tcl_Interp * interp, char * name, Tk_ImageType ** typePtrPtr)); /* 98 */
    Tk_ItemType * (*tk_GetItemTypes) _ANSI_ARGS_((void)); /* 99 */
    int (*tk_GetJoinStyle) _ANSI_ARGS_((Tcl_Interp * interp, char * string, int * joinPtr)); /* 100 */
    int (*tk_GetJustify) _ANSI_ARGS_((Tcl_Interp * interp, char * string, Tk_Justify * justifyPtr)); /* 101 */
    int (*tk_GetNumMainWindows) _ANSI_ARGS_((void)); /* 102 */
    Tk_Uid (*tk_GetOption) _ANSI_ARGS_((Tk_Window tkwin, char * name, char * className)); /* 103 */
    int (*tk_GetPixels) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, char * string, int * intPtr)); /* 104 */
    Pixmap (*tk_GetPixmap) _ANSI_ARGS_((Display * display, Drawable d, int width, int height, int depth)); /* 105 */
    int (*tk_GetRelief) _ANSI_ARGS_((Tcl_Interp * interp, char * name, int * reliefPtr)); /* 106 */
    void (*tk_GetRootCoords) _ANSI_ARGS_((Tk_Window tkwin, int * xPtr, int * yPtr)); /* 107 */
    int (*tk_GetScrollInfo) _ANSI_ARGS_((Tcl_Interp * interp, int argc, char ** argv, double * dblPtr, int * intPtr)); /* 108 */
    int (*tk_GetScreenMM) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, char * string, double * doublePtr)); /* 109 */
    int (*tk_GetSelection) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, Atom selection, Atom target, Tk_GetSelProc * proc, ClientData clientData)); /* 110 */
    Tk_Uid (*tk_GetUid) _ANSI_ARGS_((CONST char * string)); /* 111 */
    Visual * (*tk_GetVisual) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, char * string, int * depthPtr, Colormap * colormapPtr)); /* 112 */
    void (*tk_GetVRootGeometry) _ANSI_ARGS_((Tk_Window tkwin, int * xPtr, int * yPtr, int * widthPtr, int * heightPtr)); /* 113 */
    int (*tk_Grab) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, int grabGlobal)); /* 114 */
    void (*tk_HandleEvent) _ANSI_ARGS_((XEvent * eventPtr)); /* 115 */
    Tk_Window (*tk_IdToWindow) _ANSI_ARGS_((Display * display, Window window)); /* 116 */
    void (*tk_ImageChanged) _ANSI_ARGS_((Tk_ImageMaster master, int x, int y, int width, int height, int imageWidth, int imageHeight)); /* 117 */
    int (*tk_Init) _ANSI_ARGS_((Tcl_Interp * interp)); /* 118 */
    Atom (*tk_InternAtom) _ANSI_ARGS_((Tk_Window tkwin, char * name)); /* 119 */
    int (*tk_IntersectTextLayout) _ANSI_ARGS_((Tk_TextLayout layout, int x, int y, int width, int height)); /* 120 */
    void (*tk_MaintainGeometry) _ANSI_ARGS_((Tk_Window slave, Tk_Window master, int x, int y, int width, int height)); /* 121 */
    Tk_Window (*tk_MainWindow) _ANSI_ARGS_((Tcl_Interp * interp)); /* 122 */
    void (*tk_MakeWindowExist) _ANSI_ARGS_((Tk_Window tkwin)); /* 123 */
    void (*tk_ManageGeometry) _ANSI_ARGS_((Tk_Window tkwin, Tk_GeomMgr * mgrPtr, ClientData clientData)); /* 124 */
    void (*tk_MapWindow) _ANSI_ARGS_((Tk_Window tkwin)); /* 125 */
    int (*tk_MeasureChars) _ANSI_ARGS_((Tk_Font tkfont, CONST char * source, int maxChars, int maxPixels, int flags, int * lengthPtr)); /* 126 */
    void (*tk_MoveResizeWindow) _ANSI_ARGS_((Tk_Window tkwin, int x, int y, int width, int height)); /* 127 */
    void (*tk_MoveWindow) _ANSI_ARGS_((Tk_Window tkwin, int x, int y)); /* 128 */
    void (*tk_MoveToplevelWindow) _ANSI_ARGS_((Tk_Window tkwin, int x, int y)); /* 129 */
    char * (*tk_NameOf3DBorder) _ANSI_ARGS_((Tk_3DBorder border)); /* 130 */
    char * (*tk_NameOfAnchor) _ANSI_ARGS_((Tk_Anchor anchor)); /* 131 */
    char * (*tk_NameOfBitmap) _ANSI_ARGS_((Display * display, Pixmap bitmap)); /* 132 */
    char * (*tk_NameOfCapStyle) _ANSI_ARGS_((int cap)); /* 133 */
    char * (*tk_NameOfColor) _ANSI_ARGS_((XColor * colorPtr)); /* 134 */
    char * (*tk_NameOfCursor) _ANSI_ARGS_((Display * display, Tk_Cursor cursor)); /* 135 */
    char * (*tk_NameOfFont) _ANSI_ARGS_((Tk_Font font)); /* 136 */
    char * (*tk_NameOfImage) _ANSI_ARGS_((Tk_ImageMaster imageMaster)); /* 137 */
    char * (*tk_NameOfJoinStyle) _ANSI_ARGS_((int join)); /* 138 */
    char * (*tk_NameOfJustify) _ANSI_ARGS_((Tk_Justify justify)); /* 139 */
    char * (*tk_NameOfRelief) _ANSI_ARGS_((int relief)); /* 140 */
    Tk_Window (*tk_NameToWindow) _ANSI_ARGS_((Tcl_Interp * interp, char * pathName, Tk_Window tkwin)); /* 141 */
    void (*tk_OwnSelection) _ANSI_ARGS_((Tk_Window tkwin, Atom selection, Tk_LostSelProc * proc, ClientData clientData)); /* 142 */
    int (*tk_ParseArgv) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, int * argcPtr, char ** argv, Tk_ArgvInfo * argTable, int flags)); /* 143 */
    void (*tk_PhotoPutBlock) _ANSI_ARGS_((Tk_PhotoHandle handle, Tk_PhotoImageBlock * blockPtr, int x, int y, int width, int height)); /* 144 */
    void (*tk_PhotoPutZoomedBlock) _ANSI_ARGS_((Tk_PhotoHandle handle, Tk_PhotoImageBlock * blockPtr, int x, int y, int width, int height, int zoomX, int zoomY, int subsampleX, int subsampleY)); /* 145 */
    int (*tk_PhotoGetImage) _ANSI_ARGS_((Tk_PhotoHandle handle, Tk_PhotoImageBlock * blockPtr)); /* 146 */
    void (*tk_PhotoBlank) _ANSI_ARGS_((Tk_PhotoHandle handle)); /* 147 */
    void (*tk_PhotoExpand) _ANSI_ARGS_((Tk_PhotoHandle handle, int width, int height)); /* 148 */
    void (*tk_PhotoGetSize) _ANSI_ARGS_((Tk_PhotoHandle handle, int * widthPtr, int * heightPtr)); /* 149 */
    void (*tk_PhotoSetSize) _ANSI_ARGS_((Tk_PhotoHandle handle, int width, int height)); /* 150 */
    int (*tk_PointToChar) _ANSI_ARGS_((Tk_TextLayout layout, int x, int y)); /* 151 */
    int (*tk_PostscriptFontName) _ANSI_ARGS_((Tk_Font tkfont, Tcl_DString * dsPtr)); /* 152 */
    void (*tk_PreserveColormap) _ANSI_ARGS_((Display * display, Colormap colormap)); /* 153 */
    void (*tk_QueueWindowEvent) _ANSI_ARGS_((XEvent * eventPtr, Tcl_QueuePosition position)); /* 154 */
    void (*tk_RedrawImage) _ANSI_ARGS_((Tk_Image image, int imageX, int imageY, int width, int height, Drawable drawable, int drawableX, int drawableY)); /* 155 */
    void (*tk_ResizeWindow) _ANSI_ARGS_((Tk_Window tkwin, int width, int height)); /* 156 */
    int (*tk_RestackWindow) _ANSI_ARGS_((Tk_Window tkwin, int aboveBelow, Tk_Window other)); /* 157 */
    Tk_RestrictProc * (*tk_RestrictEvents) _ANSI_ARGS_((Tk_RestrictProc * proc, ClientData arg, ClientData * prevArgPtr)); /* 158 */
    int (*tk_SafeInit) _ANSI_ARGS_((Tcl_Interp * interp)); /* 159 */
    char * (*tk_SetAppName) _ANSI_ARGS_((Tk_Window tkwin, char * name)); /* 160 */
    void (*tk_SetBackgroundFromBorder) _ANSI_ARGS_((Tk_Window tkwin, Tk_3DBorder border)); /* 161 */
    void (*tk_SetClass) _ANSI_ARGS_((Tk_Window tkwin, char * className)); /* 162 */
    void (*tk_SetGrid) _ANSI_ARGS_((Tk_Window tkwin, int reqWidth, int reqHeight, int gridWidth, int gridHeight)); /* 163 */
    void (*tk_SetInternalBorder) _ANSI_ARGS_((Tk_Window tkwin, int width)); /* 164 */
    void (*tk_SetWindowBackground) _ANSI_ARGS_((Tk_Window tkwin, unsigned long pixel)); /* 165 */
    void (*tk_SetWindowBackgroundPixmap) _ANSI_ARGS_((Tk_Window tkwin, Pixmap pixmap)); /* 166 */
    void (*tk_SetWindowBorder) _ANSI_ARGS_((Tk_Window tkwin, unsigned long pixel)); /* 167 */
    void (*tk_SetWindowBorderWidth) _ANSI_ARGS_((Tk_Window tkwin, int width)); /* 168 */
    void (*tk_SetWindowBorderPixmap) _ANSI_ARGS_((Tk_Window tkwin, Pixmap pixmap)); /* 169 */
    void (*tk_SetWindowColormap) _ANSI_ARGS_((Tk_Window tkwin, Colormap colormap)); /* 170 */
    int (*tk_SetWindowVisual) _ANSI_ARGS_((Tk_Window tkwin, Visual * visual, int depth, Colormap colormap)); /* 171 */
    void (*tk_SizeOfBitmap) _ANSI_ARGS_((Display * display, Pixmap bitmap, int * widthPtr, int * heightPtr)); /* 172 */
    void (*tk_SizeOfImage) _ANSI_ARGS_((Tk_Image image, int * widthPtr, int * heightPtr)); /* 173 */
    int (*tk_StrictMotif) _ANSI_ARGS_((Tk_Window tkwin)); /* 174 */
    void (*tk_TextLayoutToPostscript) _ANSI_ARGS_((Tcl_Interp * interp, Tk_TextLayout layout)); /* 175 */
    int (*tk_TextWidth) _ANSI_ARGS_((Tk_Font font, CONST char * string, int numChars)); /* 176 */
    void (*tk_UndefineCursor) _ANSI_ARGS_((Tk_Window window)); /* 177 */
    void (*tk_UnderlineChars) _ANSI_ARGS_((Display * display, Drawable drawable, GC gc, Tk_Font tkfont, CONST char * source, int x, int y, int firstChar, int lastChar)); /* 178 */
    void (*tk_UnderlineTextLayout) _ANSI_ARGS_((Display * display, Drawable drawable, GC gc, Tk_TextLayout layout, int x, int y, int underline)); /* 179 */
    void (*tk_Ungrab) _ANSI_ARGS_((Tk_Window tkwin)); /* 180 */
    void (*tk_UnmaintainGeometry) _ANSI_ARGS_((Tk_Window slave, Tk_Window master)); /* 181 */
    void (*tk_UnmapWindow) _ANSI_ARGS_((Tk_Window tkwin)); /* 182 */
    void (*tk_UnsetGrid) _ANSI_ARGS_((Tk_Window tkwin)); /* 183 */
    void (*tk_UpdatePointer) _ANSI_ARGS_((Tk_Window tkwin, int x, int y, int state)); /* 184 */
    Pixmap (*tk_AllocBitmapFromObj) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, Tcl_Obj * objPtr)); /* 185 */
    Tk_3DBorder (*tk_Alloc3DBorderFromObj) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, Tcl_Obj * objPtr)); /* 186 */
    XColor * (*tk_AllocColorFromObj) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, Tcl_Obj * objPtr)); /* 187 */
    Tk_Cursor (*tk_AllocCursorFromObj) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, Tcl_Obj * objPtr)); /* 188 */
    Tk_Font (*tk_AllocFontFromObj) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, Tcl_Obj * objPtr)); /* 189 */
    Tk_OptionTable (*tk_CreateOptionTable) _ANSI_ARGS_((Tcl_Interp * interp, CONST Tk_OptionSpec * templatePtr)); /* 190 */
    void (*tk_DeleteOptionTable) _ANSI_ARGS_((Tk_OptionTable optionTable)); /* 191 */
    void (*tk_Free3DBorderFromObj) _ANSI_ARGS_((Tk_Window tkwin, Tcl_Obj * objPtr)); /* 192 */
    void (*tk_FreeBitmapFromObj) _ANSI_ARGS_((Tk_Window tkwin, Tcl_Obj * objPtr)); /* 193 */
    void (*tk_FreeColorFromObj) _ANSI_ARGS_((Tk_Window tkwin, Tcl_Obj * objPtr)); /* 194 */
    void (*tk_FreeConfigOptions) _ANSI_ARGS_((char * recordPtr, Tk_OptionTable optionToken, Tk_Window tkwin)); /* 195 */
    void (*tk_FreeSavedOptions) _ANSI_ARGS_((Tk_SavedOptions * savePtr)); /* 196 */
    void (*tk_FreeCursorFromObj) _ANSI_ARGS_((Tk_Window tkwin, Tcl_Obj * objPtr)); /* 197 */
    void (*tk_FreeFontFromObj) _ANSI_ARGS_((Tk_Window tkwin, Tcl_Obj * objPtr)); /* 198 */
    Tk_3DBorder (*tk_Get3DBorderFromObj) _ANSI_ARGS_((Tk_Window tkwin, Tcl_Obj * objPtr)); /* 199 */
    int (*tk_GetAnchorFromObj) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr, Tk_Anchor * anchorPtr)); /* 200 */
    Pixmap (*tk_GetBitmapFromObj) _ANSI_ARGS_((Tk_Window tkwin, Tcl_Obj * objPtr)); /* 201 */
    XColor * (*tk_GetColorFromObj) _ANSI_ARGS_((Tk_Window tkwin, Tcl_Obj * objPtr)); /* 202 */
    Tk_Cursor (*tk_GetCursorFromObj) _ANSI_ARGS_((Tk_Window tkwin, Tcl_Obj * objPtr)); /* 203 */
    Tcl_Obj * (*tk_GetOptionInfo) _ANSI_ARGS_((Tcl_Interp * interp, char * recordPtr, Tk_OptionTable optionTable, Tcl_Obj * namePtr, Tk_Window tkwin)); /* 204 */
    Tcl_Obj * (*tk_GetOptionValue) _ANSI_ARGS_((Tcl_Interp * interp, char * recordPtr, Tk_OptionTable optionTable, Tcl_Obj * namePtr, Tk_Window tkwin)); /* 205 */
    int (*tk_GetJustifyFromObj) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr, Tk_Justify * justifyPtr)); /* 206 */
    int (*tk_GetMMFromObj) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, Tcl_Obj * objPtr, double * doublePtr)); /* 207 */
    int (*tk_GetPixelsFromObj) _ANSI_ARGS_((Tcl_Interp * interp, Tk_Window tkwin, Tcl_Obj * objPtr, int * intPtr)); /* 208 */
    int (*tk_GetReliefFromObj) _ANSI_ARGS_((Tcl_Interp * interp, Tcl_Obj * objPtr, int * resultPtr)); /* 209 */
    int (*tk_GetScrollInfoObj) _ANSI_ARGS_((Tcl_Interp * interp, int objc, Tcl_Obj *CONST objv[], double * dblPtr, int * intPtr)); /* 210 */
    int (*tk_InitOptions) _ANSI_ARGS_((Tcl_Interp * interp, char * recordPtr, Tk_OptionTable optionToken, Tk_Window tkwin)); /* 211 */
    void (*tk_MainEx) _ANSI_ARGS_((int argc, char ** argv, Tcl_AppInitProc * appInitProc, Tcl_Interp * interp)); /* 212 */
    void (*tk_RestoreSavedOptions) _ANSI_ARGS_((Tk_SavedOptions * savePtr)); /* 213 */
    int (*tk_SetOptions) _ANSI_ARGS_((Tcl_Interp * interp, char * recordPtr, Tk_OptionTable optionTable, int objc, Tcl_Obj *CONST objv[], Tk_Window tkwin, Tk_SavedOptions * savePtr, int * maskPtr)); /* 214 */
} TkStubs;

extern TkStubs *tkStubsPtr;

#if defined(USE_TK_STUBS) && !defined(USE_TK_STUB_PROCS)

/*
 * Inline function declarations:
 */

#ifndef Tk_MainLoop
#define Tk_MainLoop() \
	(tkStubsPtr->tk_MainLoop)() /* 0 */
#endif
#ifndef Tk_3DBorderColor
#define Tk_3DBorderColor(border) \
	(tkStubsPtr->tk_3DBorderColor)(border) /* 1 */
#endif
#ifndef Tk_3DBorderGC
#define Tk_3DBorderGC(tkwin, border, which) \
	(tkStubsPtr->tk_3DBorderGC)(tkwin, border, which) /* 2 */
#endif
#ifndef Tk_3DHorizontalBevel
#define Tk_3DHorizontalBevel(tkwin, drawable, border, x, y, width, height, leftIn, rightIn, topBevel, relief) \
	(tkStubsPtr->tk_3DHorizontalBevel)(tkwin, drawable, border, x, y, width, height, leftIn, rightIn, topBevel, relief) /* 3 */
#endif
#ifndef Tk_3DVerticalBevel
#define Tk_3DVerticalBevel(tkwin, drawable, border, x, y, width, height, leftBevel, relief) \
	(tkStubsPtr->tk_3DVerticalBevel)(tkwin, drawable, border, x, y, width, height, leftBevel, relief) /* 4 */
#endif
#ifndef Tk_AddOption
#define Tk_AddOption(tkwin, name, value, priority) \
	(tkStubsPtr->tk_AddOption)(tkwin, name, value, priority) /* 5 */
#endif
#ifndef Tk_BindEvent
#define Tk_BindEvent(bindingTable, eventPtr, tkwin, numObjects, objectPtr) \
	(tkStubsPtr->tk_BindEvent)(bindingTable, eventPtr, tkwin, numObjects, objectPtr) /* 6 */
#endif
#ifndef Tk_CanvasDrawableCoords
#define Tk_CanvasDrawableCoords(canvas, x, y, drawableXPtr, drawableYPtr) \
	(tkStubsPtr->tk_CanvasDrawableCoords)(canvas, x, y, drawableXPtr, drawableYPtr) /* 7 */
#endif
#ifndef Tk_CanvasEventuallyRedraw
#define Tk_CanvasEventuallyRedraw(canvas, x1, y1, x2, y2) \
	(tkStubsPtr->tk_CanvasEventuallyRedraw)(canvas, x1, y1, x2, y2) /* 8 */
#endif
#ifndef Tk_CanvasGetCoord
#define Tk_CanvasGetCoord(interp, canvas, string, doublePtr) \
	(tkStubsPtr->tk_CanvasGetCoord)(interp, canvas, string, doublePtr) /* 9 */
#endif
#ifndef Tk_CanvasGetTextInfo
#define Tk_CanvasGetTextInfo(canvas) \
	(tkStubsPtr->tk_CanvasGetTextInfo)(canvas) /* 10 */
#endif
#ifndef Tk_CanvasPsBitmap
#define Tk_CanvasPsBitmap(interp, canvas, bitmap, x, y, width, height) \
	(tkStubsPtr->tk_CanvasPsBitmap)(interp, canvas, bitmap, x, y, width, height) /* 11 */
#endif
#ifndef Tk_CanvasPsColor
#define Tk_CanvasPsColor(interp, canvas, colorPtr) \
	(tkStubsPtr->tk_CanvasPsColor)(interp, canvas, colorPtr) /* 12 */
#endif
#ifndef Tk_CanvasPsFont
#define Tk_CanvasPsFont(interp, canvas, font) \
	(tkStubsPtr->tk_CanvasPsFont)(interp, canvas, font) /* 13 */
#endif
#ifndef Tk_CanvasPsPath
#define Tk_CanvasPsPath(interp, canvas, coordPtr, numPoints) \
	(tkStubsPtr->tk_CanvasPsPath)(interp, canvas, coordPtr, numPoints) /* 14 */
#endif
#ifndef Tk_CanvasPsStipple
#define Tk_CanvasPsStipple(interp, canvas, bitmap) \
	(tkStubsPtr->tk_CanvasPsStipple)(interp, canvas, bitmap) /* 15 */
#endif
#ifndef Tk_CanvasPsY
#define Tk_CanvasPsY(canvas, y) \
	(tkStubsPtr->tk_CanvasPsY)(canvas, y) /* 16 */
#endif
#ifndef Tk_CanvasSetStippleOrigin
#define Tk_CanvasSetStippleOrigin(canvas, gc) \
	(tkStubsPtr->tk_CanvasSetStippleOrigin)(canvas, gc) /* 17 */
#endif
#ifndef Tk_CanvasTagsParseProc
#define Tk_CanvasTagsParseProc(clientData, interp, tkwin, value, widgRec, offset) \
	(tkStubsPtr->tk_CanvasTagsParseProc)(clientData, interp, tkwin, value, widgRec, offset) /* 18 */
#endif
#ifndef Tk_CanvasTagsPrintProc
#define Tk_CanvasTagsPrintProc(clientData, tkwin, widgRec, offset, freeProcPtr) \
	(tkStubsPtr->tk_CanvasTagsPrintProc)(clientData, tkwin, widgRec, offset, freeProcPtr) /* 19 */
#endif
#ifndef Tk_CanvasTkwin
#define Tk_CanvasTkwin(canvas) \
	(tkStubsPtr->tk_CanvasTkwin)(canvas) /* 20 */
#endif
#ifndef Tk_CanvasWindowCoords
#define Tk_CanvasWindowCoords(canvas, x, y, screenXPtr, screenYPtr) \
	(tkStubsPtr->tk_CanvasWindowCoords)(canvas, x, y, screenXPtr, screenYPtr) /* 21 */
#endif
#ifndef Tk_ChangeWindowAttributes
#define Tk_ChangeWindowAttributes(tkwin, valueMask, attsPtr) \
	(tkStubsPtr->tk_ChangeWindowAttributes)(tkwin, valueMask, attsPtr) /* 22 */
#endif
#ifndef Tk_CharBbox
#define Tk_CharBbox(layout, index, xPtr, yPtr, widthPtr, heightPtr) \
	(tkStubsPtr->tk_CharBbox)(layout, index, xPtr, yPtr, widthPtr, heightPtr) /* 23 */
#endif
#ifndef Tk_ClearSelection
#define Tk_ClearSelection(tkwin, selection) \
	(tkStubsPtr->tk_ClearSelection)(tkwin, selection) /* 24 */
#endif
#ifndef Tk_ClipboardAppend
#define Tk_ClipboardAppend(interp, tkwin, target, format, buffer) \
	(tkStubsPtr->tk_ClipboardAppend)(interp, tkwin, target, format, buffer) /* 25 */
#endif
#ifndef Tk_ClipboardClear
#define Tk_ClipboardClear(interp, tkwin) \
	(tkStubsPtr->tk_ClipboardClear)(interp, tkwin) /* 26 */
#endif
#ifndef Tk_ConfigureInfo
#define Tk_ConfigureInfo(interp, tkwin, specs, widgRec, argvName, flags) \
	(tkStubsPtr->tk_ConfigureInfo)(interp, tkwin, specs, widgRec, argvName, flags) /* 27 */
#endif
#ifndef Tk_ConfigureValue
#define Tk_ConfigureValue(interp, tkwin, specs, widgRec, argvName, flags) \
	(tkStubsPtr->tk_ConfigureValue)(interp, tkwin, specs, widgRec, argvName, flags) /* 28 */
#endif
#ifndef Tk_ConfigureWidget
#define Tk_ConfigureWidget(interp, tkwin, specs, argc, argv, widgRec, flags) \
	(tkStubsPtr->tk_ConfigureWidget)(interp, tkwin, specs, argc, argv, widgRec, flags) /* 29 */
#endif
#ifndef Tk_ConfigureWindow
#define Tk_ConfigureWindow(tkwin, valueMask, valuePtr) \
	(tkStubsPtr->tk_ConfigureWindow)(tkwin, valueMask, valuePtr) /* 30 */
#endif
#ifndef Tk_ComputeTextLayout
#define Tk_ComputeTextLayout(font, string, numChars, wrapLength, justify, flags, widthPtr, heightPtr) \
	(tkStubsPtr->tk_ComputeTextLayout)(font, string, numChars, wrapLength, justify, flags, widthPtr, heightPtr) /* 31 */
#endif
#ifndef Tk_CoordsToWindow
#define Tk_CoordsToWindow(rootX, rootY, tkwin) \
	(tkStubsPtr->tk_CoordsToWindow)(rootX, rootY, tkwin) /* 32 */
#endif
#ifndef Tk_CreateBinding
#define Tk_CreateBinding(interp, bindingTable, object, eventString, command, append) \
	(tkStubsPtr->tk_CreateBinding)(interp, bindingTable, object, eventString, command, append) /* 33 */
#endif
#ifndef Tk_CreateBindingTable
#define Tk_CreateBindingTable(interp) \
	(tkStubsPtr->tk_CreateBindingTable)(interp) /* 34 */
#endif
#ifndef Tk_CreateErrorHandler
#define Tk_CreateErrorHandler(display, errNum, request, minorCode, errorProc, clientData) \
	(tkStubsPtr->tk_CreateErrorHandler)(display, errNum, request, minorCode, errorProc, clientData) /* 35 */
#endif
#ifndef Tk_CreateEventHandler
#define Tk_CreateEventHandler(token, mask, proc, clientData) \
	(tkStubsPtr->tk_CreateEventHandler)(token, mask, proc, clientData) /* 36 */
#endif
#ifndef Tk_CreateGenericHandler
#define Tk_CreateGenericHandler(proc, clientData) \
	(tkStubsPtr->tk_CreateGenericHandler)(proc, clientData) /* 37 */
#endif
#ifndef Tk_CreateImageType
#define Tk_CreateImageType(typePtr) \
	(tkStubsPtr->tk_CreateImageType)(typePtr) /* 38 */
#endif
#ifndef Tk_CreateItemType
#define Tk_CreateItemType(typePtr) \
	(tkStubsPtr->tk_CreateItemType)(typePtr) /* 39 */
#endif
#ifndef Tk_CreatePhotoImageFormat
#define Tk_CreatePhotoImageFormat(formatPtr) \
	(tkStubsPtr->tk_CreatePhotoImageFormat)(formatPtr) /* 40 */
#endif
#ifndef Tk_CreateSelHandler
#define Tk_CreateSelHandler(tkwin, selection, target, proc, clientData, format) \
	(tkStubsPtr->tk_CreateSelHandler)(tkwin, selection, target, proc, clientData, format) /* 41 */
#endif
#ifndef Tk_CreateWindow
#define Tk_CreateWindow(interp, parent, name, screenName) \
	(tkStubsPtr->tk_CreateWindow)(interp, parent, name, screenName) /* 42 */
#endif
#ifndef Tk_CreateWindowFromPath
#define Tk_CreateWindowFromPath(interp, tkwin, pathName, screenName) \
	(tkStubsPtr->tk_CreateWindowFromPath)(interp, tkwin, pathName, screenName) /* 43 */
#endif
#ifndef Tk_DefineBitmap
#define Tk_DefineBitmap(interp, name, source, width, height) \
	(tkStubsPtr->tk_DefineBitmap)(interp, name, source, width, height) /* 44 */
#endif
#ifndef Tk_DefineCursor
#define Tk_DefineCursor(window, cursor) \
	(tkStubsPtr->tk_DefineCursor)(window, cursor) /* 45 */
#endif
#ifndef Tk_DeleteAllBindings
#define Tk_DeleteAllBindings(bindingTable, object) \
	(tkStubsPtr->tk_DeleteAllBindings)(bindingTable, object) /* 46 */
#endif
#ifndef Tk_DeleteBinding
#define Tk_DeleteBinding(interp, bindingTable, object, eventString) \
	(tkStubsPtr->tk_DeleteBinding)(interp, bindingTable, object, eventString) /* 47 */
#endif
#ifndef Tk_DeleteBindingTable
#define Tk_DeleteBindingTable(bindingTable) \
	(tkStubsPtr->tk_DeleteBindingTable)(bindingTable) /* 48 */
#endif
#ifndef Tk_DeleteErrorHandler
#define Tk_DeleteErrorHandler(handler) \
	(tkStubsPtr->tk_DeleteErrorHandler)(handler) /* 49 */
#endif
#ifndef Tk_DeleteEventHandler
#define Tk_DeleteEventHandler(token, mask, proc, clientData) \
	(tkStubsPtr->tk_DeleteEventHandler)(token, mask, proc, clientData) /* 50 */
#endif
#ifndef Tk_DeleteGenericHandler
#define Tk_DeleteGenericHandler(proc, clientData) \
	(tkStubsPtr->tk_DeleteGenericHandler)(proc, clientData) /* 51 */
#endif
#ifndef Tk_DeleteImage
#define Tk_DeleteImage(interp, name) \
	(tkStubsPtr->tk_DeleteImage)(interp, name) /* 52 */
#endif
#ifndef Tk_DeleteSelHandler
#define Tk_DeleteSelHandler(tkwin, selection, target) \
	(tkStubsPtr->tk_DeleteSelHandler)(tkwin, selection, target) /* 53 */
#endif
#ifndef Tk_DestroyWindow
#define Tk_DestroyWindow(tkwin) \
	(tkStubsPtr->tk_DestroyWindow)(tkwin) /* 54 */
#endif
#ifndef Tk_DisplayName
#define Tk_DisplayName(tkwin) \
	(tkStubsPtr->tk_DisplayName)(tkwin) /* 55 */
#endif
#ifndef Tk_DistanceToTextLayout
#define Tk_DistanceToTextLayout(layout, x, y) \
	(tkStubsPtr->tk_DistanceToTextLayout)(layout, x, y) /* 56 */
#endif
#ifndef Tk_Draw3DPolygon
#define Tk_Draw3DPolygon(tkwin, drawable, border, pointPtr, numPoints, borderWidth, leftRelief) \
	(tkStubsPtr->tk_Draw3DPolygon)(tkwin, drawable, border, pointPtr, numPoints, borderWidth, leftRelief) /* 57 */
#endif
#ifndef Tk_Draw3DRectangle
#define Tk_Draw3DRectangle(tkwin, drawable, border, x, y, width, height, borderWidth, relief) \
	(tkStubsPtr->tk_Draw3DRectangle)(tkwin, drawable, border, x, y, width, height, borderWidth, relief) /* 58 */
#endif
#ifndef Tk_DrawChars
#define Tk_DrawChars(display, drawable, gc, tkfont, source, numChars, x, y) \
	(tkStubsPtr->tk_DrawChars)(display, drawable, gc, tkfont, source, numChars, x, y) /* 59 */
#endif
#ifndef Tk_DrawFocusHighlight
#define Tk_DrawFocusHighlight(tkwin, gc, width, drawable) \
	(tkStubsPtr->tk_DrawFocusHighlight)(tkwin, gc, width, drawable) /* 60 */
#endif
#ifndef Tk_DrawTextLayout
#define Tk_DrawTextLayout(display, drawable, gc, layout, x, y, firstChar, lastChar) \
	(tkStubsPtr->tk_DrawTextLayout)(display, drawable, gc, layout, x, y, firstChar, lastChar) /* 61 */
#endif
#ifndef Tk_Fill3DPolygon
#define Tk_Fill3DPolygon(tkwin, drawable, border, pointPtr, numPoints, borderWidth, leftRelief) \
	(tkStubsPtr->tk_Fill3DPolygon)(tkwin, drawable, border, pointPtr, numPoints, borderWidth, leftRelief) /* 62 */
#endif
#ifndef Tk_Fill3DRectangle
#define Tk_Fill3DRectangle(tkwin, drawable, border, x, y, width, height, borderWidth, relief) \
	(tkStubsPtr->tk_Fill3DRectangle)(tkwin, drawable, border, x, y, width, height, borderWidth, relief) /* 63 */
#endif
#ifndef Tk_FindPhoto
#define Tk_FindPhoto(interp, imageName) \
	(tkStubsPtr->tk_FindPhoto)(interp, imageName) /* 64 */
#endif
#ifndef Tk_FontId
#define Tk_FontId(font) \
	(tkStubsPtr->tk_FontId)(font) /* 65 */
#endif
#ifndef Tk_Free3DBorder
#define Tk_Free3DBorder(border) \
	(tkStubsPtr->tk_Free3DBorder)(border) /* 66 */
#endif
#ifndef Tk_FreeBitmap
#define Tk_FreeBitmap(display, bitmap) \
	(tkStubsPtr->tk_FreeBitmap)(display, bitmap) /* 67 */
#endif
#ifndef Tk_FreeColor
#define Tk_FreeColor(colorPtr) \
	(tkStubsPtr->tk_FreeColor)(colorPtr) /* 68 */
#endif
#ifndef Tk_FreeColormap
#define Tk_FreeColormap(display, colormap) \
	(tkStubsPtr->tk_FreeColormap)(display, colormap) /* 69 */
#endif
#ifndef Tk_FreeCursor
#define Tk_FreeCursor(display, cursor) \
	(tkStubsPtr->tk_FreeCursor)(display, cursor) /* 70 */
#endif
#ifndef Tk_FreeFont
#define Tk_FreeFont(f) \
	(tkStubsPtr->tk_FreeFont)(f) /* 71 */
#endif
#ifndef Tk_FreeGC
#define Tk_FreeGC(display, gc) \
	(tkStubsPtr->tk_FreeGC)(display, gc) /* 72 */
#endif
#ifndef Tk_FreeImage
#define Tk_FreeImage(image) \
	(tkStubsPtr->tk_FreeImage)(image) /* 73 */
#endif
#ifndef Tk_FreeOptions
#define Tk_FreeOptions(specs, widgRec, display, needFlags) \
	(tkStubsPtr->tk_FreeOptions)(specs, widgRec, display, needFlags) /* 74 */
#endif
#ifndef Tk_FreePixmap
#define Tk_FreePixmap(display, pixmap) \
	(tkStubsPtr->tk_FreePixmap)(display, pixmap) /* 75 */
#endif
#ifndef Tk_FreeTextLayout
#define Tk_FreeTextLayout(textLayout) \
	(tkStubsPtr->tk_FreeTextLayout)(textLayout) /* 76 */
#endif
#ifndef Tk_FreeXId
#define Tk_FreeXId(display, xid) \
	(tkStubsPtr->tk_FreeXId)(display, xid) /* 77 */
#endif
#ifndef Tk_GCForColor
#define Tk_GCForColor(colorPtr, drawable) \
	(tkStubsPtr->tk_GCForColor)(colorPtr, drawable) /* 78 */
#endif
#ifndef Tk_GeometryRequest
#define Tk_GeometryRequest(tkwin, reqWidth, reqHeight) \
	(tkStubsPtr->tk_GeometryRequest)(tkwin, reqWidth, reqHeight) /* 79 */
#endif
#ifndef Tk_Get3DBorder
#define Tk_Get3DBorder(interp, tkwin, colorName) \
	(tkStubsPtr->tk_Get3DBorder)(interp, tkwin, colorName) /* 80 */
#endif
#ifndef Tk_GetAllBindings
#define Tk_GetAllBindings(interp, bindingTable, object) \
	(tkStubsPtr->tk_GetAllBindings)(interp, bindingTable, object) /* 81 */
#endif
#ifndef Tk_GetAnchor
#define Tk_GetAnchor(interp, string, anchorPtr) \
	(tkStubsPtr->tk_GetAnchor)(interp, string, anchorPtr) /* 82 */
#endif
#ifndef Tk_GetAtomName
#define Tk_GetAtomName(tkwin, atom) \
	(tkStubsPtr->tk_GetAtomName)(tkwin, atom) /* 83 */
#endif
#ifndef Tk_GetBinding
#define Tk_GetBinding(interp, bindingTable, object, eventString) \
	(tkStubsPtr->tk_GetBinding)(interp, bindingTable, object, eventString) /* 84 */
#endif
#ifndef Tk_GetBitmap
#define Tk_GetBitmap(interp, tkwin, string) \
	(tkStubsPtr->tk_GetBitmap)(interp, tkwin, string) /* 85 */
#endif
#ifndef Tk_GetBitmapFromData
#define Tk_GetBitmapFromData(interp, tkwin, source, width, height) \
	(tkStubsPtr->tk_GetBitmapFromData)(interp, tkwin, source, width, height) /* 86 */
#endif
#ifndef Tk_GetCapStyle
#define Tk_GetCapStyle(interp, string, capPtr) \
	(tkStubsPtr->tk_GetCapStyle)(interp, string, capPtr) /* 87 */
#endif
#ifndef Tk_GetColor
#define Tk_GetColor(interp, tkwin, name) \
	(tkStubsPtr->tk_GetColor)(interp, tkwin, name) /* 88 */
#endif
#ifndef Tk_GetColorByValue
#define Tk_GetColorByValue(tkwin, colorPtr) \
	(tkStubsPtr->tk_GetColorByValue)(tkwin, colorPtr) /* 89 */
#endif
#ifndef Tk_GetColormap
#define Tk_GetColormap(interp, tkwin, string) \
	(tkStubsPtr->tk_GetColormap)(interp, tkwin, string) /* 90 */
#endif
#ifndef Tk_GetCursor
#define Tk_GetCursor(interp, tkwin, string) \
	(tkStubsPtr->tk_GetCursor)(interp, tkwin, string) /* 91 */
#endif
#ifndef Tk_GetCursorFromData
#define Tk_GetCursorFromData(interp, tkwin, source, mask, width, height, xHot, yHot, fg, bg) \
	(tkStubsPtr->tk_GetCursorFromData)(interp, tkwin, source, mask, width, height, xHot, yHot, fg, bg) /* 92 */
#endif
#ifndef Tk_GetFont
#define Tk_GetFont(interp, tkwin, string) \
	(tkStubsPtr->tk_GetFont)(interp, tkwin, string) /* 93 */
#endif
#ifndef Tk_GetFontFromObj
#define Tk_GetFontFromObj(tkwin, objPtr) \
	(tkStubsPtr->tk_GetFontFromObj)(tkwin, objPtr) /* 94 */
#endif
#ifndef Tk_GetFontMetrics
#define Tk_GetFontMetrics(font, fmPtr) \
	(tkStubsPtr->tk_GetFontMetrics)(font, fmPtr) /* 95 */
#endif
#ifndef Tk_GetGC
#define Tk_GetGC(tkwin, valueMask, valuePtr) \
	(tkStubsPtr->tk_GetGC)(tkwin, valueMask, valuePtr) /* 96 */
#endif
#ifndef Tk_GetImage
#define Tk_GetImage(interp, tkwin, name, changeProc, clientData) \
	(tkStubsPtr->tk_GetImage)(interp, tkwin, name, changeProc, clientData) /* 97 */
#endif
#ifndef Tk_GetImageMasterData
#define Tk_GetImageMasterData(interp, name, typePtrPtr) \
	(tkStubsPtr->tk_GetImageMasterData)(interp, name, typePtrPtr) /* 98 */
#endif
#ifndef Tk_GetItemTypes
#define Tk_GetItemTypes() \
	(tkStubsPtr->tk_GetItemTypes)() /* 99 */
#endif
#ifndef Tk_GetJoinStyle
#define Tk_GetJoinStyle(interp, string, joinPtr) \
	(tkStubsPtr->tk_GetJoinStyle)(interp, string, joinPtr) /* 100 */
#endif
#ifndef Tk_GetJustify
#define Tk_GetJustify(interp, string, justifyPtr) \
	(tkStubsPtr->tk_GetJustify)(interp, string, justifyPtr) /* 101 */
#endif
#ifndef Tk_GetNumMainWindows
#define Tk_GetNumMainWindows() \
	(tkStubsPtr->tk_GetNumMainWindows)() /* 102 */
#endif
#ifndef Tk_GetOption
#define Tk_GetOption(tkwin, name, className) \
	(tkStubsPtr->tk_GetOption)(tkwin, name, className) /* 103 */
#endif
#ifndef Tk_GetPixels
#define Tk_GetPixels(interp, tkwin, string, intPtr) \
	(tkStubsPtr->tk_GetPixels)(interp, tkwin, string, intPtr) /* 104 */
#endif
#ifndef Tk_GetPixmap
#define Tk_GetPixmap(display, d, width, height, depth) \
	(tkStubsPtr->tk_GetPixmap)(display, d, width, height, depth) /* 105 */
#endif
#ifndef Tk_GetRelief
#define Tk_GetRelief(interp, name, reliefPtr) \
	(tkStubsPtr->tk_GetRelief)(interp, name, reliefPtr) /* 106 */
#endif
#ifndef Tk_GetRootCoords
#define Tk_GetRootCoords(tkwin, xPtr, yPtr) \
	(tkStubsPtr->tk_GetRootCoords)(tkwin, xPtr, yPtr) /* 107 */
#endif
#ifndef Tk_GetScrollInfo
#define Tk_GetScrollInfo(interp, argc, argv, dblPtr, intPtr) \
	(tkStubsPtr->tk_GetScrollInfo)(interp, argc, argv, dblPtr, intPtr) /* 108 */
#endif
#ifndef Tk_GetScreenMM
#define Tk_GetScreenMM(interp, tkwin, string, doublePtr) \
	(tkStubsPtr->tk_GetScreenMM)(interp, tkwin, string, doublePtr) /* 109 */
#endif
#ifndef Tk_GetSelection
#define Tk_GetSelection(interp, tkwin, selection, target, proc, clientData) \
	(tkStubsPtr->tk_GetSelection)(interp, tkwin, selection, target, proc, clientData) /* 110 */
#endif
#ifndef Tk_GetUid
#define Tk_GetUid(string) \
	(tkStubsPtr->tk_GetUid)(string) /* 111 */
#endif
#ifndef Tk_GetVisual
#define Tk_GetVisual(interp, tkwin, string, depthPtr, colormapPtr) \
	(tkStubsPtr->tk_GetVisual)(interp, tkwin, string, depthPtr, colormapPtr) /* 112 */
#endif
#ifndef Tk_GetVRootGeometry
#define Tk_GetVRootGeometry(tkwin, xPtr, yPtr, widthPtr, heightPtr) \
	(tkStubsPtr->tk_GetVRootGeometry)(tkwin, xPtr, yPtr, widthPtr, heightPtr) /* 113 */
#endif
#ifndef Tk_Grab
#define Tk_Grab(interp, tkwin, grabGlobal) \
	(tkStubsPtr->tk_Grab)(interp, tkwin, grabGlobal) /* 114 */
#endif
#ifndef Tk_HandleEvent
#define Tk_HandleEvent(eventPtr) \
	(tkStubsPtr->tk_HandleEvent)(eventPtr) /* 115 */
#endif
#ifndef Tk_IdToWindow
#define Tk_IdToWindow(display, window) \
	(tkStubsPtr->tk_IdToWindow)(display, window) /* 116 */
#endif
#ifndef Tk_ImageChanged
#define Tk_ImageChanged(master, x, y, width, height, imageWidth, imageHeight) \
	(tkStubsPtr->tk_ImageChanged)(master, x, y, width, height, imageWidth, imageHeight) /* 117 */
#endif
#ifndef Tk_Init
#define Tk_Init(interp) \
	(tkStubsPtr->tk_Init)(interp) /* 118 */
#endif
#ifndef Tk_InternAtom
#define Tk_InternAtom(tkwin, name) \
	(tkStubsPtr->tk_InternAtom)(tkwin, name) /* 119 */
#endif
#ifndef Tk_IntersectTextLayout
#define Tk_IntersectTextLayout(layout, x, y, width, height) \
	(tkStubsPtr->tk_IntersectTextLayout)(layout, x, y, width, height) /* 120 */
#endif
#ifndef Tk_MaintainGeometry
#define Tk_MaintainGeometry(slave, master, x, y, width, height) \
	(tkStubsPtr->tk_MaintainGeometry)(slave, master, x, y, width, height) /* 121 */
#endif
#ifndef Tk_MainWindow
#define Tk_MainWindow(interp) \
	(tkStubsPtr->tk_MainWindow)(interp) /* 122 */
#endif
#ifndef Tk_MakeWindowExist
#define Tk_MakeWindowExist(tkwin) \
	(tkStubsPtr->tk_MakeWindowExist)(tkwin) /* 123 */
#endif
#ifndef Tk_ManageGeometry
#define Tk_ManageGeometry(tkwin, mgrPtr, clientData) \
	(tkStubsPtr->tk_ManageGeometry)(tkwin, mgrPtr, clientData) /* 124 */
#endif
#ifndef Tk_MapWindow
#define Tk_MapWindow(tkwin) \
	(tkStubsPtr->tk_MapWindow)(tkwin) /* 125 */
#endif
#ifndef Tk_MeasureChars
#define Tk_MeasureChars(tkfont, source, maxChars, maxPixels, flags, lengthPtr) \
	(tkStubsPtr->tk_MeasureChars)(tkfont, source, maxChars, maxPixels, flags, lengthPtr) /* 126 */
#endif
#ifndef Tk_MoveResizeWindow
#define Tk_MoveResizeWindow(tkwin, x, y, width, height) \
	(tkStubsPtr->tk_MoveResizeWindow)(tkwin, x, y, width, height) /* 127 */
#endif
#ifndef Tk_MoveWindow
#define Tk_MoveWindow(tkwin, x, y) \
	(tkStubsPtr->tk_MoveWindow)(tkwin, x, y) /* 128 */
#endif
#ifndef Tk_MoveToplevelWindow
#define Tk_MoveToplevelWindow(tkwin, x, y) \
	(tkStubsPtr->tk_MoveToplevelWindow)(tkwin, x, y) /* 129 */
#endif
#ifndef Tk_NameOf3DBorder
#define Tk_NameOf3DBorder(border) \
	(tkStubsPtr->tk_NameOf3DBorder)(border) /* 130 */
#endif
#ifndef Tk_NameOfAnchor
#define Tk_NameOfAnchor(anchor) \
	(tkStubsPtr->tk_NameOfAnchor)(anchor) /* 131 */
#endif
#ifndef Tk_NameOfBitmap
#define Tk_NameOfBitmap(display, bitmap) \
	(tkStubsPtr->tk_NameOfBitmap)(display, bitmap) /* 132 */
#endif
#ifndef Tk_NameOfCapStyle
#define Tk_NameOfCapStyle(cap) \
	(tkStubsPtr->tk_NameOfCapStyle)(cap) /* 133 */
#endif
#ifndef Tk_NameOfColor
#define Tk_NameOfColor(colorPtr) \
	(tkStubsPtr->tk_NameOfColor)(colorPtr) /* 134 */
#endif
#ifndef Tk_NameOfCursor
#define Tk_NameOfCursor(display, cursor) \
	(tkStubsPtr->tk_NameOfCursor)(display, cursor) /* 135 */
#endif
#ifndef Tk_NameOfFont
#define Tk_NameOfFont(font) \
	(tkStubsPtr->tk_NameOfFont)(font) /* 136 */
#endif
#ifndef Tk_NameOfImage
#define Tk_NameOfImage(imageMaster) \
	(tkStubsPtr->tk_NameOfImage)(imageMaster) /* 137 */
#endif
#ifndef Tk_NameOfJoinStyle
#define Tk_NameOfJoinStyle(join) \
	(tkStubsPtr->tk_NameOfJoinStyle)(join) /* 138 */
#endif
#ifndef Tk_NameOfJustify
#define Tk_NameOfJustify(justify) \
	(tkStubsPtr->tk_NameOfJustify)(justify) /* 139 */
#endif
#ifndef Tk_NameOfRelief
#define Tk_NameOfRelief(relief) \
	(tkStubsPtr->tk_NameOfRelief)(relief) /* 140 */
#endif
#ifndef Tk_NameToWindow
#define Tk_NameToWindow(interp, pathName, tkwin) \
	(tkStubsPtr->tk_NameToWindow)(interp, pathName, tkwin) /* 141 */
#endif
#ifndef Tk_OwnSelection
#define Tk_OwnSelection(tkwin, selection, proc, clientData) \
	(tkStubsPtr->tk_OwnSelection)(tkwin, selection, proc, clientData) /* 142 */
#endif
#ifndef Tk_ParseArgv
#define Tk_ParseArgv(interp, tkwin, argcPtr, argv, argTable, flags) \
	(tkStubsPtr->tk_ParseArgv)(interp, tkwin, argcPtr, argv, argTable, flags) /* 143 */
#endif
#ifndef Tk_PhotoPutBlock
#define Tk_PhotoPutBlock(handle, blockPtr, x, y, width, height) \
	(tkStubsPtr->tk_PhotoPutBlock)(handle, blockPtr, x, y, width, height) /* 144 */
#endif
#ifndef Tk_PhotoPutZoomedBlock
#define Tk_PhotoPutZoomedBlock(handle, blockPtr, x, y, width, height, zoomX, zoomY, subsampleX, subsampleY) \
	(tkStubsPtr->tk_PhotoPutZoomedBlock)(handle, blockPtr, x, y, width, height, zoomX, zoomY, subsampleX, subsampleY) /* 145 */
#endif
#ifndef Tk_PhotoGetImage
#define Tk_PhotoGetImage(handle, blockPtr) \
	(tkStubsPtr->tk_PhotoGetImage)(handle, blockPtr) /* 146 */
#endif
#ifndef Tk_PhotoBlank
#define Tk_PhotoBlank(handle) \
	(tkStubsPtr->tk_PhotoBlank)(handle) /* 147 */
#endif
#ifndef Tk_PhotoExpand
#define Tk_PhotoExpand(handle, width, height) \
	(tkStubsPtr->tk_PhotoExpand)(handle, width, height) /* 148 */
#endif
#ifndef Tk_PhotoGetSize
#define Tk_PhotoGetSize(handle, widthPtr, heightPtr) \
	(tkStubsPtr->tk_PhotoGetSize)(handle, widthPtr, heightPtr) /* 149 */
#endif
#ifndef Tk_PhotoSetSize
#define Tk_PhotoSetSize(handle, width, height) \
	(tkStubsPtr->tk_PhotoSetSize)(handle, width, height) /* 150 */
#endif
#ifndef Tk_PointToChar
#define Tk_PointToChar(layout, x, y) \
	(tkStubsPtr->tk_PointToChar)(layout, x, y) /* 151 */
#endif
#ifndef Tk_PostscriptFontName
#define Tk_PostscriptFontName(tkfont, dsPtr) \
	(tkStubsPtr->tk_PostscriptFontName)(tkfont, dsPtr) /* 152 */
#endif
#ifndef Tk_PreserveColormap
#define Tk_PreserveColormap(display, colormap) \
	(tkStubsPtr->tk_PreserveColormap)(display, colormap) /* 153 */
#endif
#ifndef Tk_QueueWindowEvent
#define Tk_QueueWindowEvent(eventPtr, position) \
	(tkStubsPtr->tk_QueueWindowEvent)(eventPtr, position) /* 154 */
#endif
#ifndef Tk_RedrawImage
#define Tk_RedrawImage(image, imageX, imageY, width, height, drawable, drawableX, drawableY) \
	(tkStubsPtr->tk_RedrawImage)(image, imageX, imageY, width, height, drawable, drawableX, drawableY) /* 155 */
#endif
#ifndef Tk_ResizeWindow
#define Tk_ResizeWindow(tkwin, width, height) \
	(tkStubsPtr->tk_ResizeWindow)(tkwin, width, height) /* 156 */
#endif
#ifndef Tk_RestackWindow
#define Tk_RestackWindow(tkwin, aboveBelow, other) \
	(tkStubsPtr->tk_RestackWindow)(tkwin, aboveBelow, other) /* 157 */
#endif
#ifndef Tk_RestrictEvents
#define Tk_RestrictEvents(proc, arg, prevArgPtr) \
	(tkStubsPtr->tk_RestrictEvents)(proc, arg, prevArgPtr) /* 158 */
#endif
#ifndef Tk_SafeInit
#define Tk_SafeInit(interp) \
	(tkStubsPtr->tk_SafeInit)(interp) /* 159 */
#endif
#ifndef Tk_SetAppName
#define Tk_SetAppName(tkwin, name) \
	(tkStubsPtr->tk_SetAppName)(tkwin, name) /* 160 */
#endif
#ifndef Tk_SetBackgroundFromBorder
#define Tk_SetBackgroundFromBorder(tkwin, border) \
	(tkStubsPtr->tk_SetBackgroundFromBorder)(tkwin, border) /* 161 */
#endif
#ifndef Tk_SetClass
#define Tk_SetClass(tkwin, className) \
	(tkStubsPtr->tk_SetClass)(tkwin, className) /* 162 */
#endif
#ifndef Tk_SetGrid
#define Tk_SetGrid(tkwin, reqWidth, reqHeight, gridWidth, gridHeight) \
	(tkStubsPtr->tk_SetGrid)(tkwin, reqWidth, reqHeight, gridWidth, gridHeight) /* 163 */
#endif
#ifndef Tk_SetInternalBorder
#define Tk_SetInternalBorder(tkwin, width) \
	(tkStubsPtr->tk_SetInternalBorder)(tkwin, width) /* 164 */
#endif
#ifndef Tk_SetWindowBackground
#define Tk_SetWindowBackground(tkwin, pixel) \
	(tkStubsPtr->tk_SetWindowBackground)(tkwin, pixel) /* 165 */
#endif
#ifndef Tk_SetWindowBackgroundPixmap
#define Tk_SetWindowBackgroundPixmap(tkwin, pixmap) \
	(tkStubsPtr->tk_SetWindowBackgroundPixmap)(tkwin, pixmap) /* 166 */
#endif
#ifndef Tk_SetWindowBorder
#define Tk_SetWindowBorder(tkwin, pixel) \
	(tkStubsPtr->tk_SetWindowBorder)(tkwin, pixel) /* 167 */
#endif
#ifndef Tk_SetWindowBorderWidth
#define Tk_SetWindowBorderWidth(tkwin, width) \
	(tkStubsPtr->tk_SetWindowBorderWidth)(tkwin, width) /* 168 */
#endif
#ifndef Tk_SetWindowBorderPixmap
#define Tk_SetWindowBorderPixmap(tkwin, pixmap) \
	(tkStubsPtr->tk_SetWindowBorderPixmap)(tkwin, pixmap) /* 169 */
#endif
#ifndef Tk_SetWindowColormap
#define Tk_SetWindowColormap(tkwin, colormap) \
	(tkStubsPtr->tk_SetWindowColormap)(tkwin, colormap) /* 170 */
#endif
#ifndef Tk_SetWindowVisual
#define Tk_SetWindowVisual(tkwin, visual, depth, colormap) \
	(tkStubsPtr->tk_SetWindowVisual)(tkwin, visual, depth, colormap) /* 171 */
#endif
#ifndef Tk_SizeOfBitmap
#define Tk_SizeOfBitmap(display, bitmap, widthPtr, heightPtr) \
	(tkStubsPtr->tk_SizeOfBitmap)(display, bitmap, widthPtr, heightPtr) /* 172 */
#endif
#ifndef Tk_SizeOfImage
#define Tk_SizeOfImage(image, widthPtr, heightPtr) \
	(tkStubsPtr->tk_SizeOfImage)(image, widthPtr, heightPtr) /* 173 */
#endif
#ifndef Tk_StrictMotif
#define Tk_StrictMotif(tkwin) \
	(tkStubsPtr->tk_StrictMotif)(tkwin) /* 174 */
#endif
#ifndef Tk_TextLayoutToPostscript
#define Tk_TextLayoutToPostscript(interp, layout) \
	(tkStubsPtr->tk_TextLayoutToPostscript)(interp, layout) /* 175 */
#endif
#ifndef Tk_TextWidth
#define Tk_TextWidth(font, string, numChars) \
	(tkStubsPtr->tk_TextWidth)(font, string, numChars) /* 176 */
#endif
#ifndef Tk_UndefineCursor
#define Tk_UndefineCursor(window) \
	(tkStubsPtr->tk_UndefineCursor)(window) /* 177 */
#endif
#ifndef Tk_UnderlineChars
#define Tk_UnderlineChars(display, drawable, gc, tkfont, source, x, y, firstChar, lastChar) \
	(tkStubsPtr->tk_UnderlineChars)(display, drawable, gc, tkfont, source, x, y, firstChar, lastChar) /* 178 */
#endif
#ifndef Tk_UnderlineTextLayout
#define Tk_UnderlineTextLayout(display, drawable, gc, layout, x, y, underline) \
	(tkStubsPtr->tk_UnderlineTextLayout)(display, drawable, gc, layout, x, y, underline) /* 179 */
#endif
#ifndef Tk_Ungrab
#define Tk_Ungrab(tkwin) \
	(tkStubsPtr->tk_Ungrab)(tkwin) /* 180 */
#endif
#ifndef Tk_UnmaintainGeometry
#define Tk_UnmaintainGeometry(slave, master) \
	(tkStubsPtr->tk_UnmaintainGeometry)(slave, master) /* 181 */
#endif
#ifndef Tk_UnmapWindow
#define Tk_UnmapWindow(tkwin) \
	(tkStubsPtr->tk_UnmapWindow)(tkwin) /* 182 */
#endif
#ifndef Tk_UnsetGrid
#define Tk_UnsetGrid(tkwin) \
	(tkStubsPtr->tk_UnsetGrid)(tkwin) /* 183 */
#endif
#ifndef Tk_UpdatePointer
#define Tk_UpdatePointer(tkwin, x, y, state) \
	(tkStubsPtr->tk_UpdatePointer)(tkwin, x, y, state) /* 184 */
#endif
#ifndef Tk_AllocBitmapFromObj
#define Tk_AllocBitmapFromObj(interp, tkwin, objPtr) \
	(tkStubsPtr->tk_AllocBitmapFromObj)(interp, tkwin, objPtr) /* 185 */
#endif
#ifndef Tk_Alloc3DBorderFromObj
#define Tk_Alloc3DBorderFromObj(interp, tkwin, objPtr) \
	(tkStubsPtr->tk_Alloc3DBorderFromObj)(interp, tkwin, objPtr) /* 186 */
#endif
#ifndef Tk_AllocColorFromObj
#define Tk_AllocColorFromObj(interp, tkwin, objPtr) \
	(tkStubsPtr->tk_AllocColorFromObj)(interp, tkwin, objPtr) /* 187 */
#endif
#ifndef Tk_AllocCursorFromObj
#define Tk_AllocCursorFromObj(interp, tkwin, objPtr) \
	(tkStubsPtr->tk_AllocCursorFromObj)(interp, tkwin, objPtr) /* 188 */
#endif
#ifndef Tk_AllocFontFromObj
#define Tk_AllocFontFromObj(interp, tkwin, objPtr) \
	(tkStubsPtr->tk_AllocFontFromObj)(interp, tkwin, objPtr) /* 189 */
#endif
#ifndef Tk_CreateOptionTable
#define Tk_CreateOptionTable(interp, templatePtr) \
	(tkStubsPtr->tk_CreateOptionTable)(interp, templatePtr) /* 190 */
#endif
#ifndef Tk_DeleteOptionTable
#define Tk_DeleteOptionTable(optionTable) \
	(tkStubsPtr->tk_DeleteOptionTable)(optionTable) /* 191 */
#endif
#ifndef Tk_Free3DBorderFromObj
#define Tk_Free3DBorderFromObj(tkwin, objPtr) \
	(tkStubsPtr->tk_Free3DBorderFromObj)(tkwin, objPtr) /* 192 */
#endif
#ifndef Tk_FreeBitmapFromObj
#define Tk_FreeBitmapFromObj(tkwin, objPtr) \
	(tkStubsPtr->tk_FreeBitmapFromObj)(tkwin, objPtr) /* 193 */
#endif
#ifndef Tk_FreeColorFromObj
#define Tk_FreeColorFromObj(tkwin, objPtr) \
	(tkStubsPtr->tk_FreeColorFromObj)(tkwin, objPtr) /* 194 */
#endif
#ifndef Tk_FreeConfigOptions
#define Tk_FreeConfigOptions(recordPtr, optionToken, tkwin) \
	(tkStubsPtr->tk_FreeConfigOptions)(recordPtr, optionToken, tkwin) /* 195 */
#endif
#ifndef Tk_FreeSavedOptions
#define Tk_FreeSavedOptions(savePtr) \
	(tkStubsPtr->tk_FreeSavedOptions)(savePtr) /* 196 */
#endif
#ifndef Tk_FreeCursorFromObj
#define Tk_FreeCursorFromObj(tkwin, objPtr) \
	(tkStubsPtr->tk_FreeCursorFromObj)(tkwin, objPtr) /* 197 */
#endif
#ifndef Tk_FreeFontFromObj
#define Tk_FreeFontFromObj(tkwin, objPtr) \
	(tkStubsPtr->tk_FreeFontFromObj)(tkwin, objPtr) /* 198 */
#endif
#ifndef Tk_Get3DBorderFromObj
#define Tk_Get3DBorderFromObj(tkwin, objPtr) \
	(tkStubsPtr->tk_Get3DBorderFromObj)(tkwin, objPtr) /* 199 */
#endif
#ifndef Tk_GetAnchorFromObj
#define Tk_GetAnchorFromObj(interp, objPtr, anchorPtr) \
	(tkStubsPtr->tk_GetAnchorFromObj)(interp, objPtr, anchorPtr) /* 200 */
#endif
#ifndef Tk_GetBitmapFromObj
#define Tk_GetBitmapFromObj(tkwin, objPtr) \
	(tkStubsPtr->tk_GetBitmapFromObj)(tkwin, objPtr) /* 201 */
#endif
#ifndef Tk_GetColorFromObj
#define Tk_GetColorFromObj(tkwin, objPtr) \
	(tkStubsPtr->tk_GetColorFromObj)(tkwin, objPtr) /* 202 */
#endif
#ifndef Tk_GetCursorFromObj
#define Tk_GetCursorFromObj(tkwin, objPtr) \
	(tkStubsPtr->tk_GetCursorFromObj)(tkwin, objPtr) /* 203 */
#endif
#ifndef Tk_GetOptionInfo
#define Tk_GetOptionInfo(interp, recordPtr, optionTable, namePtr, tkwin) \
	(tkStubsPtr->tk_GetOptionInfo)(interp, recordPtr, optionTable, namePtr, tkwin) /* 204 */
#endif
#ifndef Tk_GetOptionValue
#define Tk_GetOptionValue(interp, recordPtr, optionTable, namePtr, tkwin) \
	(tkStubsPtr->tk_GetOptionValue)(interp, recordPtr, optionTable, namePtr, tkwin) /* 205 */
#endif
#ifndef Tk_GetJustifyFromObj
#define Tk_GetJustifyFromObj(interp, objPtr, justifyPtr) \
	(tkStubsPtr->tk_GetJustifyFromObj)(interp, objPtr, justifyPtr) /* 206 */
#endif
#ifndef Tk_GetMMFromObj
#define Tk_GetMMFromObj(interp, tkwin, objPtr, doublePtr) \
	(tkStubsPtr->tk_GetMMFromObj)(interp, tkwin, objPtr, doublePtr) /* 207 */
#endif
#ifndef Tk_GetPixelsFromObj
#define Tk_GetPixelsFromObj(interp, tkwin, objPtr, intPtr) \
	(tkStubsPtr->tk_GetPixelsFromObj)(interp, tkwin, objPtr, intPtr) /* 208 */
#endif
#ifndef Tk_GetReliefFromObj
#define Tk_GetReliefFromObj(interp, objPtr, resultPtr) \
	(tkStubsPtr->tk_GetReliefFromObj)(interp, objPtr, resultPtr) /* 209 */
#endif
#ifndef Tk_GetScrollInfoObj
#define Tk_GetScrollInfoObj(interp, objc, objv, dblPtr, intPtr) \
	(tkStubsPtr->tk_GetScrollInfoObj)(interp, objc, objv, dblPtr, intPtr) /* 210 */
#endif
#ifndef Tk_InitOptions
#define Tk_InitOptions(interp, recordPtr, optionToken, tkwin) \
	(tkStubsPtr->tk_InitOptions)(interp, recordPtr, optionToken, tkwin) /* 211 */
#endif
#ifndef Tk_MainEx
#define Tk_MainEx(argc, argv, appInitProc, interp) \
	(tkStubsPtr->tk_MainEx)(argc, argv, appInitProc, interp) /* 212 */
#endif
#ifndef Tk_RestoreSavedOptions
#define Tk_RestoreSavedOptions(savePtr) \
	(tkStubsPtr->tk_RestoreSavedOptions)(savePtr) /* 213 */
#endif
#ifndef Tk_SetOptions
#define Tk_SetOptions(interp, recordPtr, optionTable, objc, objv, tkwin, savePtr, maskPtr) \
	(tkStubsPtr->tk_SetOptions)(interp, recordPtr, optionTable, objc, objv, tkwin, savePtr, maskPtr) /* 214 */
#endif

#endif /* defined(USE_TK_STUBS) && !defined(USE_TK_STUB_PROCS) */

/* !END!: Do not edit above this line. */

#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLIMPORT

#endif /* _TKDECLS */

