//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TextAttribute
//	Include File:	textattr.h
//	Purpose:	Implement a way of giving a WWW style of attribute to
//			a segment of a stream of data.
//	Remarks/Portability/Dependencies/Restrictions:
//		The difference between the start and end of an attribute is
//		called extent.  Extent can be considered a correlation to
//		calling strlen on a string.
//		An extent of 0 means no duration, 1 means 1 byte, etc...
//		A negative extent is equivalent to 0 extent.
//		Once an attribute type is set by the constructor, it can
//		never be changed.
//	Revision History:
//		02-01-94	created
//		02-09-94	Split all members into seperate files.
#include"textattr.h"

void TextAttribute::Begin(const signed long int sli_Offset)	{
//	Purpose:	Set the offset into a stream.
//	Arguments:	sli_Offset	The offset into the stream.
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//		Provides a mechanism for change.
//		This in no way changes the value of the extent, and the
//		extent will actualy stay in place and grow or shrink with
//		the new beginning offset unless specifically adjusted also.
//	Revision History:
//		02-01-94	created.

	sli_StreamOffset = sli_Offset;
}
