//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide the view of a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-02-94	Began a major revision to fully handle a
//				multiple document interface with WWW, take
//				over the formatting and drawing of the
//				old gridtext functions of HText, and optimize
//				memory usage, selecting anchors, the usage of
//				HText's new image file.  See gridtext.
//		02-09-94	Split all members into seperate files.
#include"turlview.h"
#include"trace.h"

void TURLView::registerText(HText *HTp_doc)	{
//	Purpose:	Keep a pointer to our hypertext document after it
//			is created.
//	Arguments:	HTp_doc	The hypertext object.
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//		The actual call made to this function is done in gridtext.cpp
//	Revision History:
//		01-25-94	created
#ifndef RELEASE
	trace("Registering HText with view.");
#endif // RELEASE
	//	Keep the pointer.
	HTp_HyperDoc = HTp_doc;
}
