//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide the view of a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-02-94	Began a major revision to fully handle a
//				multiple document interface with WWW, take
//				over the formatting and drawing of the
//				old gridtext functions of HText, and optimize
//				memory usage, selecting anchors, the usage of
//				HText's new image file.  See gridtext.
//		02-09-94	Split all members into seperate files.
//		02-24-94	Revised to work with a rendered image file.
#include"turlview.h"

void TURLView::AnchorInView()	{
//	Purpose:	Move the view coordinates so that the selected anchor
//			is viewable.
//	Arguments:	void
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//		Will redraw screen if necessary
//	Revision History:
//		01-30-94	created

	//	Only continue if there are valid anchors in the document.
	if(TAp_selected == NULL)	{
		return;
	}

	//	Only if the anchor is off the y screen do we do the below.
	if(TAp_selected->getEnd() <= (signed long int)(TNSCp_lines->
		at(delta.y)) || TAp_selected->getBegin() >= (signed long int)
		(TNSCp_lines->at((delta.y + size.y < limit.y) ?
		delta.y + size.y : limit.y - 1)))	{

		//	Find the line containing the anchor.
		for(unsigned short int usi_find = 0U; usi_find < TNSCp_lines
			->getCount(); usi_find++)	{

			//	Break if anchor is before the line.
			if(TAp_selected->getBegin() < (signed long int)(
				TNSCp_lines->at(usi_find)))	{
				//	Back up a line.
				if(usi_find != 0U)	{
					usi_find--;
				}
				break;
			}
		}
		//	If no line was found, set to line 1.
		if(usi_find == TNSCp_lines->getCount())	{
			usi_find = 0U;
		}

#ifdef TODO
#error X value may also be off screen.
#endif // TODO

		//	If this is near the last line of the file, should
		//	show a full last screen.
		if(usi_find + size.y >= limit.y)	{
			usi_find = limit.y - size.y > 0 ? limit.y - size.y :
				0;
		}

		//	If this is near the start of the file, show a complete
		//	first page.
		if(usi_find < size.y)	{
			usi_find = 0U;
		}

		//	Set where we should draw the screen only if line not
		//	on screen.
		scrollTo(delta.x, usi_find);
	}
	else	{
		//	Draw the view so that the selected anchor is viewable.
		drawView();
	}
}
